/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.mod.albedo;

import com.creativemd.creativecore.common.utils.mc.ColorUtils;
import com.creativemd.littletiles.common.mod.coloredlights.ColoredLightsManager;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.LittleTileColored;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import elucent.albedo.event.GatherLightsEvent;
import elucent.albedo.lighting.ILightProvider;
import elucent.albedo.lighting.Light;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AlbedoExtension {
    @CapabilityInject(value=ILightProvider.class)
    public static Capability<ILightProvider> LIGHT_PROVIDER_CAPABILITY;

    @SubscribeEvent
    public static void tileEntityCapability(AttachCapabilitiesEvent<TileEntity> event) {
        if (event.getObject() instanceof TileEntityLittleTiles) {
            final TileEntityLittleTiles te = (TileEntityLittleTiles)event.getObject();
            event.addCapability(new ResourceLocation("littletiles", "light"), new ICapabilityProvider(){

                public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                    return LIGHT_PROVIDER_CAPABILITY == capability;
                }

                public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                    if (capability == LIGHT_PROVIDER_CAPABILITY) {
                        return (T)new ILightProvider(){

                            @SideOnly(value=Side.CLIENT)
                            public void gatherLights(GatherLightsEvent paramGatherLightsEvent, Entity paramEntity) {
                                if (ColoredLightsManager.isInstalled()) {
                                    AxisAlignedBB box = null;
                                    int color = -1;
                                    for (LittleTile tile : te) {
                                        if (tile.getBlock() != ColoredLightsManager.getInvertedColorsBlock()) continue;
                                        int tileColor = ColoredLightsManager.getColorFromBlock(tile.getBlockState());
                                        if (tile instanceof LittleTileColored) {
                                            tileColor = ColorUtils.blend((int)tileColor, (int)((LittleTileColored)tile).color);
                                        }
                                        if (box == null) {
                                            box = tile.getCompleteBox().getBox(te.getContext(), te.func_174877_v());
                                            color = tileColor;
                                            continue;
                                        }
                                        box = box.func_111270_a(tile.getCompleteBox().getBox(te.getContext(), te.func_174877_v()));
                                        color = ColorUtils.blend((int)color, (int)tileColor);
                                    }
                                    if (box != null) {
                                        paramGatherLightsEvent.add(new Light.Builder().pos(box.func_189972_c()).color(color, false).radius(15.0f).build());
                                    }
                                }
                            }
                        };
                    }
                    return null;
                }
            });
        }
    }
}

