/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.item;

import com.creativemd.creativecore.client.rendering.RenderCubeObject;
import com.creativemd.creativecore.client.rendering.model.ICreativeRendered;
import com.creativemd.creativecore.common.gui.container.SubContainer;
import com.creativemd.creativecore.common.gui.container.SubGui;
import com.creativemd.creativecore.common.gui.opener.GuiHandler;
import com.creativemd.creativecore.common.gui.opener.IGuiCreator;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.gui.SubGuiRecipe;
import com.creativemd.littletiles.client.render.cache.ItemModelCache;
import com.creativemd.littletiles.common.container.SubContainerRecipe;
import com.creativemd.littletiles.common.mod.chiselsandbits.ChiselsAndBitsManager;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemRecipe
extends Item
implements ICreativeRendered,
IGuiCreator {
    @SideOnly(value=Side.CLIENT)
    public static IBakedModel model;

    public ItemRecipe() {
        this.func_77637_a(LittleTiles.littleTab);
        this.field_77787_bX = true;
    }

    public String func_77653_i(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("structure") && stack.func_77978_p().func_74775_l("structure").func_74764_b("name")) {
            return stack.func_77978_p().func_74775_l("structure").func_74779_i("name");
        }
        return super.func_77653_i(stack);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (hand == EnumHand.OFF_HAND) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (!player.func_70093_af() && stack.func_77942_o() && !stack.func_77978_p().func_74764_b("x")) {
            if (!world.field_72995_K) {
                GuiHandler.openGuiItem((EntityPlayer)player, (World)world);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public LittlePreviews saveBlocks(World world, ItemStack stack, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        LittlePreviews previews = new LittlePreviews(LittleGridContext.getMin());
        for (int posX = minX; posX <= maxX; ++posX) {
            for (int posY = minY; posY <= maxY; ++posY) {
                for (int posZ = minZ; posZ <= maxZ; ++posZ) {
                    BlockPos newPos = new BlockPos(posX, posY, posZ);
                    TileEntity tileEntity = world.func_175625_s(newPos);
                    if (tileEntity instanceof TileEntityLittleTiles) {
                        TileEntityLittleTiles te = (TileEntityLittleTiles)tileEntity;
                        for (LittleTile tile : te) {
                            LittlePreview preview = previews.addPreview(null, tile.getPreviewTile(), te.getContext());
                            preview.box.add(new LittleVec((posX - minX) * previews.getContext().size, (posY - minY) * previews.getContext().size, (posZ - minZ) * previews.getContext().size));
                        }
                        continue;
                    }
                    LittlePreviews specialPreviews = ChiselsAndBitsManager.getPreviews(tileEntity);
                    if (specialPreviews == null) continue;
                    for (int i = 0; i < specialPreviews.size(); ++i) {
                        LittlePreview preview = previews.addPreview(null, specialPreviews.get(i), LittleGridContext.get(ChiselsAndBitsManager.convertingFrom));
                        preview.box.add(new LittleVec((posX - minX) * previews.getContext().size, (posY - minY) * previews.getContext().size, (posZ - minZ) * previews.getContext().size));
                    }
                }
            }
        }
        previews.removeOffset();
        return previews;
    }

    public void saveRecipe(World world, EntityPlayer player, ItemStack stack, BlockPos second) {
        int firstX = stack.func_77978_p().func_74762_e("x");
        int firstY = stack.func_77978_p().func_74762_e("y");
        int firstZ = stack.func_77978_p().func_74762_e("z");
        stack.func_77978_p().func_82580_o("x");
        stack.func_77978_p().func_82580_o("y");
        stack.func_77978_p().func_82580_o("z");
        LittlePreview.savePreview(this.saveBlocks(world, stack, Math.min(firstX, second.func_177958_n()), Math.min(firstY, second.func_177956_o()), Math.min(firstZ, second.func_177952_p()), Math.max(firstX, second.func_177958_n()), Math.max(firstY, second.func_177956_o()), Math.max(firstZ, second.func_177952_p())), stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            if (!world.field_72995_K) {
                stack.func_77982_d(null);
            }
            return EnumActionResult.SUCCESS;
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("x")) {
            if (!world.field_72995_K) {
                this.saveRecipe(world, player, stack, pos);
                player.func_145747_a((ITextComponent)new TextComponentTranslation("Second position: x=" + pos.func_177958_n() + ",y=" + pos.func_177956_o() + ",z=" + pos.func_177952_p(), new Object[0]));
            }
            return EnumActionResult.SUCCESS;
        }
        if (!stack.func_77942_o()) {
            if (!world.field_72995_K) {
                stack.func_77982_d(new NBTTagCompound());
                stack.func_77978_p().func_74768_a("x", pos.func_177958_n());
                stack.func_77978_p().func_74768_a("y", pos.func_177956_o());
                stack.func_77978_p().func_74768_a("z", pos.func_177952_p());
                player.func_145747_a((ITextComponent)new TextComponentTranslation("First position: x=" + pos.func_177958_n() + ",y=" + pos.func_177956_o() + ",z=" + pos.func_177952_p(), new Object[0]));
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77942_o()) {
            if (stack.func_77978_p().func_74764_b("x")) {
                tooltip.add("First pos: x=" + stack.func_77978_p().func_74762_e("x") + ",y=" + stack.func_77978_p().func_74762_e("y") + ",z=" + stack.func_77978_p().func_74762_e("z"));
            } else {
                String id = "none";
                if (stack.func_77978_p().func_74764_b("structure")) {
                    id = stack.func_77978_p().func_74775_l("structure").func_74779_i("id");
                }
                tooltip.add("structure: " + id);
                tooltip.add("contains " + stack.func_77978_p().func_74762_e("count") + " tiles");
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public SubGui getGui(EntityPlayer player, ItemStack stack, World world, BlockPos pos, IBlockState state) {
        return new SubGuiRecipe(stack);
    }

    public SubContainer getContainer(EntityPlayer player, ItemStack stack, World world, BlockPos pos, IBlockState state) {
        return new SubContainerRecipe(player, stack);
    }

    @SideOnly(value=Side.CLIENT)
    public ArrayList<RenderCubeObject> getRenderingCubes(IBlockState state, TileEntity te, ItemStack stack) {
        if (stack.func_77942_o() && !stack.func_77978_p().func_74764_b("x")) {
            return LittlePreview.getCubes(stack);
        }
        return new ArrayList<RenderCubeObject>();
    }

    public ModelResourceLocation getBackgroundLocation() {
        return new ModelResourceLocation("littletiles:recipe_background", "inventory");
    }

    @SideOnly(value=Side.CLIENT)
    public void applyCustomOpenGLHackery(ItemStack stack, ItemCameraTransforms.TransformType cameraTransformType) {
        Minecraft mc = Minecraft.func_71410_x();
        GlStateManager.func_179094_E();
        if (cameraTransformType == ItemCameraTransforms.TransformType.GUI || !stack.func_77942_o() || !stack.func_77978_p().func_74764_b("tiles")) {
            if (cameraTransformType == ItemCameraTransforms.TransformType.GUI) {
                GlStateManager.func_179097_i();
            }
            if (model == null) {
                model = mc.func_175599_af().func_175037_a().func_178083_a().func_174953_a(this.getBackgroundLocation());
            }
            ForgeHooksClient.handleCameraTransforms((IBakedModel)model, (ItemCameraTransforms.TransformType)cameraTransformType, (boolean)false);
            try {
                mc.func_175599_af().func_180454_a(new ItemStack(Items.field_151121_aF), model);
            }
            catch (Exception e) {
                model = null;
                return;
            }
            if (cameraTransformType == ItemCameraTransforms.TransformType.GUI) {
                GlStateManager.func_179126_j();
            }
        }
        GlStateManager.func_179121_F();
        if (stack.func_77942_o() && !stack.func_77978_p().func_74764_b("x")) {
            LittleVec size = LittlePreview.getSize(stack);
            LittleGridContext context = LittleGridContext.get(stack.func_77978_p());
            double scaler = 1.0 / Math.max(1.0, Math.max(1.0, Math.max(size.getPosX(context), Math.max(size.getPosY(context), size.getPosZ(context)))));
            GlStateManager.func_179139_a((double)scaler, (double)scaler, (double)scaler);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void saveCachedModel(EnumFacing facing, BlockRenderLayer layer, List<BakedQuad> cachedQuads, IBlockState state, TileEntity te, ItemStack stack, boolean threaded) {
        ItemModelCache.cacheModel(stack, facing, cachedQuads);
    }

    @SideOnly(value=Side.CLIENT)
    public List<BakedQuad> getCachedModel(EnumFacing facing, BlockRenderLayer layer, IBlockState state, TileEntity te, ItemStack stack, boolean threaded) {
        return ItemModelCache.requestCache(stack, facing);
    }
}

