/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.item;

import com.creativemd.creativecore.client.rendering.RenderCubeObject;
import com.creativemd.creativecore.client.rendering.model.ICreativeRendered;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.gui.configure.SubGuiConfigure;
import com.creativemd.littletiles.client.gui.configure.SubGuiModeSelector;
import com.creativemd.littletiles.client.render.cache.ItemModelCache;
import com.creativemd.littletiles.common.api.ILittleTile;
import com.creativemd.littletiles.common.item.ItemLittleChisel;
import com.creativemd.littletiles.common.item.ItemMultiTiles;
import com.creativemd.littletiles.common.structure.registry.LittleStructureRegistry;
import com.creativemd.littletiles.common.structure.type.premade.LittleStructurePremade;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.place.PlacementMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPremadeStructure
extends Item
implements ICreativeRendered,
ILittleTile {
    private static HashMap<String, LittlePreviews> cachedPreviews = new HashMap();

    public ItemPremadeStructure() {
        this.func_77637_a(LittleTiles.littleTab);
        this.field_77787_bX = true;
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + "." + ItemPremadeStructure.getPremadeId(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public List<RenderCubeObject> getRenderingCubes(IBlockState state, TileEntity te, ItemStack stack) {
        LittlePreviews previews;
        LittleStructurePremade.LittleStructureTypePremade premade = (LittleStructurePremade.LittleStructureTypePremade)LittleStructureRegistry.getStructureType(stack.func_77978_p().func_74775_l("structure").func_74779_i("id"));
        List<RenderCubeObject> cubes = premade.getRenderingCubes(previews = this.getLittlePreview(stack));
        if (cubes == null) {
            cubes = new ArrayList<RenderCubeObject>();
            for (LittlePreview preview : previews.allPreviews()) {
                cubes.add(preview.getCubeBlock(previews.getContext()));
            }
        }
        return cubes;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public LittleGridContext getPositionContext(ItemStack stack) {
        return ItemMultiTiles.currentContext;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public SubGuiConfigure getConfigureGUIAdvanced(EntityPlayer player, ItemStack stack) {
        return new SubGuiModeSelector(stack, ItemMultiTiles.currentContext, ItemLittleChisel.currentMode){

            @Override
            public void saveConfiguration(LittleGridContext context, PlacementMode mode) {
                ItemLittleChisel.currentMode = mode;
                ItemMultiTiles.currentContext = context;
            }
        };
    }

    @SideOnly(value=Side.CLIENT)
    public void saveCachedModel(EnumFacing facing, BlockRenderLayer layer, List<BakedQuad> cachedQuads, IBlockState state, TileEntity te, ItemStack stack, boolean threaded) {
        if (stack != null) {
            ItemModelCache.cacheModel(ItemPremadeStructure.getPremade((ItemStack)stack).stack, facing, cachedQuads);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List<BakedQuad> getCachedModel(EnumFacing facing, BlockRenderLayer layer, IBlockState state, TileEntity te, ItemStack stack, boolean threaded) {
        if (stack == null) {
            return null;
        }
        LittleStructurePremade.LittleStructurePremadeEntry entry = ItemPremadeStructure.getPremade(stack);
        if (entry == null) {
            return null;
        }
        return ItemModelCache.requestCache(entry.stack, facing);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            for (LittleStructurePremade.LittleStructureTypePremade entry : LittleStructurePremade.getPremadeStructureTypes()) {
                list.add((Object)entry.createItemStack());
            }
        }
    }

    @Override
    public boolean hasLittlePreview(ItemStack stack) {
        return true;
    }

    public void removeUnnecessaryData(ItemStack stack) {
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_82580_o("tiles");
            stack.func_77978_p().func_82580_o("size");
            stack.func_77978_p().func_82580_o("min");
        }
    }

    public static void clearCache() {
        cachedPreviews.clear();
    }

    @Override
    public LittlePreviews getLittlePreview(ItemStack stack) {
        String id = ItemPremadeStructure.getPremadeId(stack);
        if (cachedPreviews.containsKey(id)) {
            return cachedPreviews.get(id).copy();
        }
        return LittleStructurePremade.getPreviews(id).copy();
    }

    @Override
    public void saveLittlePreview(ItemStack stack, LittlePreviews previews) {
        cachedPreviews.put(ItemPremadeStructure.getPremadeId(stack), previews);
    }

    @Override
    public boolean sendTransformationUpdate() {
        return false;
    }

    @Override
    public boolean containsIngredients(ItemStack stack) {
        return true;
    }

    @Override
    public PlacementMode getPlacementMode(ItemStack stack) {
        if (!ItemMultiTiles.currentMode.canPlaceStructures()) {
            return PlacementMode.getStructureDefault();
        }
        return ItemMultiTiles.currentMode;
    }

    @Override
    public boolean shouldCache() {
        return false;
    }

    @Override
    public boolean snapToGridByDefault() {
        return true;
    }

    public static String getPremadeId(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74775_l("structure").func_74779_i("id");
        }
        return null;
    }

    public static LittleStructurePremade.LittleStructurePremadeEntry getPremade(ItemStack stack) {
        if (stack.func_77942_o()) {
            return LittleStructurePremade.getStructurePremadeEntry(stack.func_77978_p().func_74775_l("structure").func_74779_i("id"));
        }
        return null;
    }
}

