/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.event;

import com.creativemd.creativecore.common.gui.opener.GuiHandler;
import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.mc.ColorUtils;
import com.creativemd.littletiles.client.LittleTilesClient;
import com.creativemd.littletiles.client.event.PickBlockEvent;
import com.creativemd.littletiles.client.gui.configure.SubGuiConfigure;
import com.creativemd.littletiles.client.render.cache.ItemModelCache;
import com.creativemd.littletiles.client.render.cache.RenderingThread;
import com.creativemd.littletiles.client.render.overlay.PreviewRenderer;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.block.LittleActionPlaceStack;
import com.creativemd.littletiles.common.action.tool.LittleActionGlowstone;
import com.creativemd.littletiles.common.api.IBoxSelector;
import com.creativemd.littletiles.common.api.ILittleIngredientInventory;
import com.creativemd.littletiles.common.api.ILittleTile;
import com.creativemd.littletiles.common.block.BlockTile;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.packet.LittleFlipPacket;
import com.creativemd.littletiles.common.packet.LittleRotatePacket;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.type.LittleBed;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.LittleTileColored;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.box.LittleBoxes;
import com.creativemd.littletiles.common.tile.math.vec.LittleAbsoluteVec;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.util.ingredient.LittleIngredients;
import com.creativemd.littletiles.common.util.ingredient.LittleInventory;
import com.creativemd.littletiles.common.util.ingredient.NotEnoughIngredientsException;
import com.creativemd.littletiles.common.util.place.PlacementHelper;
import com.creativemd.littletiles.common.util.place.PlacementMode;
import com.creativemd.littletiles.common.util.place.PlacementPosition;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IntHashMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.entity.player.SleepingLocationCheckEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleEventHandler {
    public static ItemStack lastSelectedItem = null;
    public static IBoxSelector blockSelector = null;
    public static ILittleTile iLittleTile = null;
    @SideOnly(value=Side.CLIENT)
    private boolean leftClicked;
    @SideOnly(value=Side.CLIENT)
    private static ResourceLocation RES_UNDERWATER_OVERLAY;
    static List<EntityPlayer> blockTilePrevent;
    private static Field setTileEntitiesField;
    @SideOnly(value=Side.CLIENT)
    public static int transparencySortingIndex;
    private static Field prevRenderSortX;
    private static Field prevRenderSortY;
    private static Field prevRenderSortZ;
    @SideOnly(value=Side.CLIENT)
    private static List<RenderChunk> queuedRenderChunksUpdate;
    private static Field entitiesById;

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onMouseWheelClick(PickBlockEvent event) {
        ItemStack stack;
        ILittleTile iTile;
        if (event.result != null && event.result.field_72313_a == RayTraceResult.Type.BLOCK && (iTile = PlacementHelper.getLittleInterface(stack = event.player.func_184614_ca())) != null && iTile.onMouseWheelClickBlock(event.world, event.player, stack, event.result)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLeftClickAir(PlayerInteractEvent.LeftClickEmpty event) {
        ItemStack stack;
        ILittleTile iLittleTile;
        if (event.getWorld().field_72995_K && (iLittleTile = PlacementHelper.getLittleInterface(stack = event.getItemStack())) != null) {
            iLittleTile.onClickAir(event.getEntityPlayer(), stack);
        }
    }

    @SubscribeEvent
    public void onLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getWorld().field_72995_K) {
            if (!this.leftClicked) {
                ItemStack stack = event.getItemStack();
                if (event.getHitVec() == null) {
                    return;
                }
                RayTraceResult ray = new RayTraceResult(event.getHitVec(), event.getFace(), event.getPos());
                if (lastSelectedItem != null && lastSelectedItem.func_77973_b() != stack.func_77973_b()) {
                    if (blockSelector != null) {
                        blockSelector.onDeselect(event.getWorld(), lastSelectedItem, event.getEntityPlayer());
                        blockSelector = null;
                    }
                    if (iLittleTile != null) {
                        iLittleTile.onDeselect(event.getEntityPlayer(), lastSelectedItem);
                        iLittleTile = null;
                    }
                    lastSelectedItem = null;
                }
                if (stack.func_77973_b() instanceof IBoxSelector) {
                    if (((IBoxSelector)stack.func_77973_b()).onClickBlock(event.getWorld(), stack, event.getEntityPlayer(), ray, new LittleAbsoluteVec(ray, ((IBoxSelector)stack.func_77973_b()).getContext(stack)))) {
                        // empty if block
                    }
                    event.setCanceled(true);
                    blockSelector = (IBoxSelector)stack.func_77973_b();
                    lastSelectedItem = stack;
                }
                if ((iLittleTile = PlacementHelper.getLittleInterface(stack)) != null) {
                    if (iLittleTile.onClickBlock(event.getWorld(), event.getEntityPlayer(), stack, LittleEventHandler.getPosition(event.getWorld(), iLittleTile, stack, ray), ray)) {
                        event.setCanceled(true);
                    }
                    lastSelectedItem = stack;
                }
                this.leftClicked = true;
            }
        } else if (event.getItemStack().func_77973_b() instanceof IBoxSelector) {
            event.setCanceled(true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void renderOverlay(RenderBlockOverlayEvent event) {
        double d0;
        BlockPos blockpos;
        EntityPlayer player;
        TileEntity te;
        if (RES_UNDERWATER_OVERLAY == null) {
            RES_UNDERWATER_OVERLAY = new ResourceLocation("textures/misc/underwater.png");
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (event.getOverlayType() == RenderBlockOverlayEvent.OverlayType.WATER && (te = player.field_70170_p.func_175625_s(blockpos = new BlockPos(player.field_70165_t, d0 = player.field_70163_u + (double)(player = event.getPlayer()).func_70047_e(), player.field_70161_v))) instanceof TileEntityLittleTiles) {
            AxisAlignedBB bb = player.func_174813_aQ();
            for (LittleTile tile : (TileEntityLittleTiles)te) {
                if (!(tile instanceof LittleTileColored) || !tile.isMaterial(Material.field_151586_h) || !tile.box.getBox(tile.getContext(), blockpos).func_72326_a(bb)) continue;
                mc.func_110434_K().func_110577_a(RES_UNDERWATER_OVERLAY);
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder = tessellator.func_178180_c();
                float f = mc.field_71439_g.func_70013_c();
                Vec3d color = ColorUtils.IntToVec((int)((LittleTileColored)tile).color);
                GlStateManager.func_179131_c((float)(f * (float)color.field_72450_a), (float)(f * (float)color.field_72448_b), (float)(f * (float)color.field_72449_c), (float)0.5f);
                GlStateManager.func_179147_l();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_179094_E();
                float f1 = 4.0f;
                float f2 = -1.0f;
                float f3 = 1.0f;
                float f4 = -1.0f;
                float f5 = 1.0f;
                float f6 = -0.5f;
                float f7 = -mc.field_71439_g.field_70177_z / 64.0f;
                float f8 = mc.field_71439_g.field_70125_A / 64.0f;
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                bufferbuilder.func_181662_b(-1.0, -1.0, -0.5).func_187315_a((double)(4.0f + f7), (double)(4.0f + f8)).func_181675_d();
                bufferbuilder.func_181662_b(1.0, -1.0, -0.5).func_187315_a((double)(0.0f + f7), (double)(4.0f + f8)).func_181675_d();
                bufferbuilder.func_181662_b(1.0, 1.0, -0.5).func_187315_a((double)(0.0f + f7), (double)(0.0f + f8)).func_181675_d();
                bufferbuilder.func_181662_b(-1.0, 1.0, -0.5).func_187315_a((double)(4.0f + f7), (double)(0.0f + f8)).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.func_179121_F();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179084_k();
                event.setCanceled(true);
                return;
            }
        }
    }

    @SubscribeEvent
    public void breakSpeed(PlayerEvent.BreakSpeed event) {
        ItemStack stack = event.getEntityPlayer().func_184614_ca();
        if (stack.func_77973_b() instanceof IBoxSelector) {
            event.setNewSpeed(0.0f);
        }
    }

    public static void addBlockTilePrevent(EntityPlayer player) {
        blockTilePrevent.add(player);
    }

    public static boolean consumeBlockTilePrevent(EntityPlayer player) {
        int index = blockTilePrevent.indexOf(player);
        if (index == -1) {
            return false;
        }
        blockTilePrevent.remove(index);
        return true;
    }

    @SubscribeEvent
    public void onInteractAir(PlayerInteractEvent.RightClickEmpty event) {
        if (!event.getWorld().field_72995_K && LittleEventHandler.consumeBlockTilePrevent(event.getEntityPlayer())) {
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public void onInteractEntity(PlayerInteractEvent.EntityInteractSpecific event) {
        if (!event.getWorld().field_72995_K && LittleEventHandler.consumeBlockTilePrevent(event.getEntityPlayer())) {
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent.RightClickBlock event) {
        ILittleTile iTile;
        BlockTile.TEResult te;
        if (!event.getWorld().field_72995_K && LittleEventHandler.consumeBlockTilePrevent(event.getEntityPlayer())) {
            event.setCanceled(true);
            return;
        }
        ItemStack stack = event.getEntityPlayer().func_184586_b(EnumHand.MAIN_HAND);
        if (event.getWorld().field_72995_K && event.getHand() == EnumHand.MAIN_HAND && stack.func_77973_b() == Items.field_151114_aO && event.getEntityPlayer().func_70093_af() && (te = BlockTile.loadTeAndTile((IBlockAccess)event.getEntityPlayer().field_70170_p, event.getPos(), event.getEntityPlayer())).isComplete()) {
            new LittleActionGlowstone(event.getWorld(), event.getPos(), event.getEntityPlayer()).execute();
            event.setCanceled(true);
        }
        if ((iTile = PlacementHelper.getLittleInterface(stack)) != null) {
            if (event.getHand() == EnumHand.MAIN_HAND && event.getWorld().field_72995_K) {
                this.onRightInteractClient(iTile, event.getEntityPlayer(), event.getHand(), event.getWorld(), stack, event.getPos(), event.getFace());
            }
            event.setCanceled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void worldUnload(WorldEvent.Unload event) {
        if (event.getWorld().field_72995_K) {
            LittleTile.MissingBlockHandler.unload();
            ItemModelCache.unload();
            for (int i = 0; i < RenderingThread.threads.size(); ++i) {
                RenderingThread thread = RenderingThread.threads.get(i);
                if (thread == null) continue;
                thread.interrupt();
                thread.updateCoords.clear();
                RenderingThread.threads.set(i, null);
            }
            RenderingThread.chunks.clear();
            if (setTileEntitiesField == null) {
                setTileEntitiesField = ReflectionHelper.findField(RenderGlobal.class, (String[])new String[]{"setTileEntities", "field_181024_n"});
            }
            try {
                Set set;
                Set set2 = set = (Set)setTileEntitiesField.get(Minecraft.func_71410_x().field_71438_f);
                synchronized (set2) {
                    set.clear();
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static PlacementPosition getPosition(World world, ILittleTile iTile, ItemStack stack, RayTraceResult result) {
        return PreviewRenderer.marked != null ? PreviewRenderer.marked.position.copy() : PlacementHelper.getPosition(world, result, iTile.getPositionContext(stack), iTile, stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void onRightInteractClient(ILittleTile iTile, EntityPlayer player, EnumHand hand, World world, ItemStack stack, BlockPos pos, EnumFacing facing) {
        PlacementPosition position = LittleEventHandler.getPosition(world, iTile, stack, Minecraft.func_71410_x().field_71476_x);
        if (iTile.onRightClick(world, player, stack, position.copy(), Minecraft.func_71410_x().field_71476_x)) {
            if (!stack.func_190926_b() && player.func_175151_a(pos.func_177972_a(facing), facing, stack)) {
                PlacementMode mode = iTile.getPlacementMode(stack).place();
                new LittleActionPlaceStack(iTile.getLittlePreview(stack, false, PreviewRenderer.marked != null), position, PreviewRenderer.isCentered(player, iTile), PreviewRenderer.isFixed(player, iTile), mode).execute();
                PreviewRenderer.marked = null;
            }
            iTile.onDeselect(player, stack);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void drawHighlight(DrawBlockHighlightEvent event) {
        if (event.getTarget().field_72313_a == RayTraceResult.Type.BLOCK) {
            EntityPlayer player = event.getPlayer();
            World world = event.getPlayer().func_130014_f_();
            BlockPos pos = event.getTarget().func_178782_a();
            IBlockState state = world.func_180495_p(pos);
            ItemStack stack = player.func_184586_b(EnumHand.MAIN_HAND);
            if (stack.func_77973_b() instanceof IBoxSelector) {
                IBoxSelector selector = (IBoxSelector)stack.func_77973_b();
                LittleAbsoluteVec result = new LittleAbsoluteVec(event.getTarget(), selector.getContext(stack));
                if (selector.hasCustomBox(world, stack, player, state, event.getTarget(), result)) {
                    while (LittleTilesClient.flip.func_151468_f()) {
                        LittleEventHandler.processFlipKey(player, stack);
                    }
                    while (LittleTilesClient.up.func_151468_f()) {
                        LittleEventHandler.processRotateKey(player, Rotation.Z_CLOCKWISE, stack);
                    }
                    while (LittleTilesClient.down.func_151468_f()) {
                        LittleEventHandler.processRotateKey(player, Rotation.Z_COUNTER_CLOCKWISE, stack);
                    }
                    while (LittleTilesClient.right.func_151468_f()) {
                        LittleEventHandler.processRotateKey(player, Rotation.Y_COUNTER_CLOCKWISE, stack);
                    }
                    while (LittleTilesClient.left.func_151468_f()) {
                        LittleEventHandler.processRotateKey(player, Rotation.Y_CLOCKWISE, stack);
                    }
                    double d0 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.getPartialTicks();
                    double d1 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.getPartialTicks();
                    double d2 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.getPartialTicks();
                    LittleBoxes boxes = ((IBoxSelector)stack.func_77973_b()).getBox(world, stack, player, event.getTarget(), result);
                    GlStateManager.func_179147_l();
                    GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                    GlStateManager.func_187441_d((float)4.0f);
                    GlStateManager.func_179098_w();
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(PreviewRenderer.WHITE_TEXTURE);
                    GlStateManager.func_179132_a((boolean)false);
                    for (int i = 0; i < boxes.size(); ++i) {
                        RenderGlobal.func_189697_a((AxisAlignedBB)((LittleBox)boxes.get(i)).getBox(boxes.context).func_186670_a(boxes.pos).func_186662_g((double)0.002f).func_72317_d(-d0, -d1, -d2), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                    }
                    if (state.func_185904_a() != Material.field_151579_a && world.func_175723_af().func_177746_a(pos)) {
                        GlStateManager.func_187441_d((float)1.0f);
                        RenderGlobal.func_189697_a((AxisAlignedBB)state.func_185918_c(world, pos).func_186662_g((double)0.002f).func_72317_d(-d0, -d1, -d2), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                    }
                    GlStateManager.func_179132_a((boolean)true);
                    GlStateManager.func_179098_w();
                    GlStateManager.func_179084_k();
                    event.setCanceled(true);
                }
            }
        }
    }

    public static void processFlipKey(EntityPlayer player, ItemStack stack) {
        int i4 = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        EnumFacing direction = null;
        switch (i4) {
            case 0: {
                direction = EnumFacing.SOUTH;
                break;
            }
            case 1: {
                direction = EnumFacing.WEST;
                break;
            }
            case 2: {
                direction = EnumFacing.NORTH;
                break;
            }
            case 3: {
                direction = EnumFacing.EAST;
            }
        }
        if (player.field_70125_A > 45.0f) {
            direction = EnumFacing.DOWN;
        }
        if (player.field_70125_A < -45.0f) {
            direction = EnumFacing.UP;
        }
        LittleFlipPacket packet = new LittleFlipPacket(direction.func_176740_k());
        packet.executeClient(player);
        if (stack.func_77973_b() instanceof IBoxSelector && !((IBoxSelector)stack.func_77973_b()).sendTransformationUpdate()) {
            return;
        }
        ILittleTile tile = PlacementHelper.getLittleInterface(stack);
        if (tile != null && !tile.sendTransformationUpdate()) {
            return;
        }
        PacketHandler.sendPacketToServer((CreativeCorePacket)packet);
    }

    public static void processRotateKey(EntityPlayer player, Rotation rotation, ItemStack stack) {
        LittleRotatePacket packet = new LittleRotatePacket(rotation);
        packet.executeClient(player);
        if (stack.func_77973_b() instanceof IBoxSelector && !((IBoxSelector)stack.func_77973_b()).sendTransformationUpdate()) {
            return;
        }
        ILittleTile tile = PlacementHelper.getLittleInterface(stack);
        if (tile != null && !tile.sendTransformationUpdate()) {
            return;
        }
        PacketHandler.sendPacketToServer((CreativeCorePacket)packet);
    }

    @SubscribeEvent
    public void isSleepingLocationAllowed(SleepingLocationCheckEvent event) {
        try {
            LittleStructure bed = (LittleStructure)LittleBed.littleBed.get(event.getEntityPlayer());
            if (bed instanceof LittleBed && ((LittleBed)bed).sleepingPlayer == event.getEntityPlayer()) {
                event.setResult(Event.Result.ALLOW);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        try {
            LittleStructure bed = (LittleStructure)LittleBed.littleBed.get(event.player);
            if (bed instanceof LittleBed) {
                ((LittleBed)bed).sleepingPlayer = null;
            }
            LittleBed.littleBed.set(event.player, null);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        blockTilePrevent.remove(event.player);
    }

    @SubscribeEvent
    public void onWakeUp(PlayerWakeUpEvent event) {
        try {
            LittleStructure bed = (LittleStructure)LittleBed.littleBed.get(event.getEntityPlayer());
            if (bed instanceof LittleBed) {
                ((LittleBed)bed).sleepingPlayer = null;
            }
            LittleBed.littleBed.set(event.getEntityPlayer(), null);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onPickup(EntityItemPickupEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        EntityItem entityItem = event.getItem();
        ItemStack stack = entityItem.func_92059_d();
        if (stack.func_77973_b() instanceof ILittleIngredientInventory && ((ILittleIngredientInventory)stack.func_77973_b()).shouldBeMerged()) {
            LittleIngredients ingredients = ((ILittleIngredientInventory)stack.func_77973_b()).getInventory(stack);
            LittleInventory inventory = new LittleInventory(player);
            inventory.allowDrop = false;
            if (ingredients == null) {
                entityItem.func_70106_y();
                event.setCanceled(true);
                event.setResult(Event.Result.DENY);
                return;
            }
            try {
                if (LittleAction.canGive(player, inventory, ingredients)) {
                    LittleAction.give(player, inventory, ingredients);
                    player.func_71001_a((Entity)entityItem, 1);
                    entityItem.func_70106_y();
                    event.setCanceled(true);
                    event.setResult(Event.Result.DENY);
                }
            }
            catch (NotEnoughIngredientsException notEnoughIngredientsException) {
                // empty catch block
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onPlayerSleep(PlayerSleepInBedEvent event) {
        TileEntityLittleTiles te;
        if (event.getEntityPlayer().field_70170_p.func_180495_p(event.getPos()).func_177230_c() instanceof BlockTile && (te = BlockTile.loadTe((IBlockAccess)event.getEntityPlayer().field_70170_p, event.getPos())) != null) {
            for (LittleTile tile : te) {
                LittleStructure structure;
                if (!tile.isConnectedToStructure() || !((structure = tile.connection.getStructure(tile.te.func_145831_w())) instanceof LittleBed) || !((LittleBed)structure).hasBeenActivated) continue;
                ((LittleBed)structure).trySleep(event.getEntityPlayer(), structure.getHighestCenterVec());
                event.setResult(EntityPlayer.SleepResult.OK);
                ((LittleBed)structure).hasBeenActivated = false;
                return;
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71439_g != null && mc.field_71438_f != null) {
                Entity entityIn;
                if (prevRenderSortX == null) {
                    prevRenderSortX = ReflectionHelper.findField(RenderGlobal.class, (String[])new String[]{"prevRenderSortX", "field_147596_f"});
                    prevRenderSortY = ReflectionHelper.findField(RenderGlobal.class, (String[])new String[]{"prevRenderSortY", "field_147597_g"});
                    prevRenderSortZ = ReflectionHelper.findField(RenderGlobal.class, (String[])new String[]{"prevRenderSortZ", "field_147602_h"});
                }
                if ((entityIn = mc.func_175606_aa()) == null) {
                    return;
                }
                try {
                    double d0 = entityIn.field_70165_t - prevRenderSortX.getDouble(mc.field_71438_f);
                    double d1 = entityIn.field_70163_u - prevRenderSortY.getDouble(mc.field_71438_f);
                    double d2 = entityIn.field_70161_v - prevRenderSortZ.getDouble(mc.field_71438_f);
                    if (d0 * d0 + d1 * d1 + d2 * d2 > 1.0) {
                        ++transparencySortingIndex;
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SideOnly(value=Side.CLIENT)
    public static void queueChunkUpdate(RenderChunk chunk) {
        if (queuedRenderChunksUpdate == null) {
            queuedRenderChunksUpdate = new ArrayList<RenderChunk>();
        }
        List<RenderChunk> list = queuedRenderChunksUpdate;
        synchronized (list) {
            if (!queuedRenderChunksUpdate.contains(chunk)) {
                queuedRenderChunksUpdate.add(chunk);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Minecraft mc = Minecraft.func_71410_x();
            if (queuedRenderChunksUpdate == null) {
                queuedRenderChunksUpdate = new ArrayList<RenderChunk>();
            }
            List<RenderChunk> list = queuedRenderChunksUpdate;
            synchronized (list) {
                if (!queuedRenderChunksUpdate.isEmpty()) {
                    Iterator<RenderChunk> iterator = queuedRenderChunksUpdate.iterator();
                    while (iterator.hasNext()) {
                        RenderChunk chunk = iterator.next();
                        if (chunk.func_178569_m()) continue;
                        chunk.func_178575_a(false);
                        iterator.remove();
                    }
                }
            }
            ItemModelCache.tick((World)mc.field_71441_e);
            if (this.leftClicked && !mc.field_71474_y.field_74312_F.func_151470_d()) {
                this.leftClicked = false;
            }
            if (mc.field_71439_g != null) {
                SubGuiConfigure gui;
                ILittleTile iTile;
                ItemStack stack = mc.field_71439_g.func_184614_ca();
                if (lastSelectedItem != null && lastSelectedItem.func_77973_b() != stack.func_77973_b()) {
                    if (blockSelector != null) {
                        blockSelector.onDeselect((World)mc.field_71441_e, lastSelectedItem, (EntityPlayer)mc.field_71439_g);
                        blockSelector = null;
                    }
                    if (iLittleTile != null) {
                        iLittleTile.onDeselect((EntityPlayer)mc.field_71439_g, lastSelectedItem);
                        iLittleTile = null;
                    }
                    lastSelectedItem = null;
                }
                while (LittleTilesClient.configure.func_151468_f()) {
                    iTile = PlacementHelper.getLittleInterface(stack);
                    if (iTile != null) {
                        gui = iTile.getConfigureGUI((EntityPlayer)mc.field_71439_g, stack);
                        if (gui == null) continue;
                        GuiHandler.openGui((String)"configure", (NBTTagCompound)new NBTTagCompound());
                        continue;
                    }
                    if (!(stack.func_77973_b() instanceof IBoxSelector) || (gui = ((IBoxSelector)stack.func_77973_b()).getConfigureGUI((EntityPlayer)mc.field_71439_g, stack)) == null) continue;
                    GuiHandler.openGui((String)"configure", (NBTTagCompound)new NBTTagCompound());
                }
                while (LittleTilesClient.configureAdvanced.func_151468_f()) {
                    iTile = PlacementHelper.getLittleInterface(stack);
                    if (iTile != null) {
                        gui = iTile.getConfigureGUIAdvanced((EntityPlayer)mc.field_71439_g, stack);
                        if (gui == null) continue;
                        GuiHandler.openGui((String)"configureadvanced", (NBTTagCompound)new NBTTagCompound());
                        continue;
                    }
                    if (!(stack.func_77973_b() instanceof IBoxSelector) || (gui = ((IBoxSelector)stack.func_77973_b()).getConfigureGUIAdvanced((EntityPlayer)mc.field_71439_g, stack)) == null) continue;
                    GuiHandler.openGui((String)"configureadvanced", (NBTTagCompound)new NBTTagCompound());
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean cancelEntitySpawn(WorldClient world, int entityID, Entity entity) {
        if (entity instanceof EntityAnimation) {
            ((EntityAnimation)entity).addDoor();
            if (((EntityAnimation)entity).spawnedInWorld) {
                entity.func_145769_d(entityID);
                try {
                    ((IntHashMap)entitiesById.get(world)).func_76038_a(entityID, (Object)entity);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
                return true;
            }
            ((EntityAnimation)entity).spawnedInWorld = true;
            return false;
        }
        return false;
    }

    static {
        blockTilePrevent = new ArrayList<EntityPlayer>();
        entitiesById = ReflectionHelper.findField(World.class, (String[])new String[]{"entitiesById", "field_175729_l"});
    }
}

