/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.entity.old;

import com.creativemd.creativecore.common.utils.math.box.OrientatedBoundingBox;
import com.creativemd.creativecore.common.utils.math.vec.IVecOrigin;
import com.creativemd.creativecore.common.world.CreativeWorld;
import com.creativemd.creativecore.common.world.FakeWorld;
import com.creativemd.creativecore.common.world.SubWorld;
import com.creativemd.littletiles.client.render.entity.LittleRenderChunk;
import com.creativemd.littletiles.common.block.BlockTile;
import com.creativemd.littletiles.common.entity.AABBCombiner;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.vec.LittleAbsoluteVec;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.math.vec.LittleVecContext;
import com.creativemd.littletiles.common.tile.preview.LittleAbsolutePreviews;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.google.common.base.Predicate;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import javax.vecmath.Vector3d;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Deprecated
public abstract class EntityOldAnimation
extends Entity {
    protected static Predicate<Entity> NO_ANIMATION = new Predicate<Entity>(){

        public boolean apply(Entity input) {
            return !(input instanceof EntityOldAnimation);
        }
    };
    protected LittleAbsoluteVec center;
    protected LittleVecContext inBlockCenter;
    protected BlockPos baseOffset;
    protected BlockPos chunkOffset;
    protected BlockPos inChunkOffset;
    protected LittleVec additionalAxis;
    public Vector3d rotationCenter;
    public Vector3d rotationCenterInsideBlock;
    public CreativeWorld fakeWorld;
    public IVecOrigin origin;
    public LittleAbsolutePreviews previews;
    public ArrayList<TileEntityLittleTiles> blocks;
    public double prevWorldRotX = 0.0;
    public double prevWorldRotY = 0.0;
    public double prevWorldRotZ = 0.0;
    public double worldRotX = 0.0;
    public double worldRotY = 0.0;
    public double worldRotZ = 0.0;
    public boolean preventPush = false;
    public boolean noCollision = false;
    public AABBCombiner collisionBoxWorker;
    public List<OrientatedBoundingBox> worldCollisionBoxes;
    public OrientatedBoundingBox worldBoundingBox;
    @SideOnly(value=Side.CLIENT)
    public LinkedHashMap<BlockPos, LittleRenderChunk> renderChunks;
    @SideOnly(value=Side.CLIENT)
    public ArrayList<TileEntityLittleTiles> renderQueue;
    @SideOnly(value=Side.CLIENT)
    public boolean spawnedInWorld;
    public boolean addedDoor = false;

    public static int intFloorDiv(int p_76137_0_, int p_76137_1_) {
        return p_76137_0_ < 0 ? -((-p_76137_0_ - 1) / p_76137_1_) - 1 : p_76137_0_ / p_76137_1_;
    }

    public void setCenterVec(LittleAbsoluteVec axis, LittleVec additional) {
        axis.removeInternalBlockOffset();
        this.center = axis;
        this.baseOffset = axis.getPos();
        this.inBlockCenter = axis.getVecContext();
        this.chunkOffset = EntityOldAnimation.getRenderChunkPos(this.baseOffset);
        int chunkX = EntityOldAnimation.intFloorDiv(this.baseOffset.func_177958_n(), 16);
        int chunkY = EntityOldAnimation.intFloorDiv(this.baseOffset.func_177956_o(), 16);
        int chunkZ = EntityOldAnimation.intFloorDiv(this.baseOffset.func_177952_p(), 16);
        this.inChunkOffset = new BlockPos(this.baseOffset.func_177958_n() - chunkX * 16, this.baseOffset.func_177956_o() - chunkY * 16, this.baseOffset.func_177952_p() - chunkZ * 16);
        this.additionalAxis = additional;
        this.rotationCenter = new Vector3d(axis.getPosX() + this.additionalAxis.getPosX(axis.getContext()) / 2.0, axis.getPosY() + this.additionalAxis.getPosY(axis.getContext()) / 2.0, axis.getPosZ() + this.additionalAxis.getPosZ(axis.getContext()) / 2.0);
        this.rotationCenterInsideBlock = new Vector3d(this.inBlockCenter.getPosX() + this.additionalAxis.getPosX(this.inBlockCenter.getContext()) / 2.0, this.inBlockCenter.getPosY() + this.additionalAxis.getPosY(this.inBlockCenter.getContext()) / 2.0, this.inBlockCenter.getPosZ() + this.additionalAxis.getPosZ(this.inBlockCenter.getContext()) / 2.0);
        this.fakeWorld.setOrigin(this.rotationCenter);
        this.origin = this.fakeWorld.getOrigin();
    }

    public static BlockPos getRenderChunkPos(BlockPos blockPos) {
        return new BlockPos(blockPos.func_177958_n() >> 4, blockPos.func_177956_o() >> 4, blockPos.func_177952_p() >> 4);
    }

    public LittleAbsoluteVec getCenter() {
        return this.center;
    }

    public LittleVecContext getInsideBlockCenter() {
        return this.inBlockCenter;
    }

    public BlockPos getAxisPos() {
        return this.baseOffset;
    }

    public BlockPos getAxisChunkPos() {
        return this.chunkOffset;
    }

    public BlockPos getInsideChunkPos() {
        return this.inChunkOffset;
    }

    public Vec3d getRotVector(float partialTicks) {
        return new Vec3d(this.prevWorldRotX + (this.worldRotX - this.prevWorldRotX) * (double)partialTicks, this.prevWorldRotY + (this.worldRotY - this.prevWorldRotY) * (double)partialTicks, this.prevWorldRotZ + (this.worldRotZ - this.prevWorldRotZ) * (double)partialTicks);
    }

    public void updateWorldCollision() {
        double minX = 2.147483647E9;
        double minY = 2.147483647E9;
        double minZ = 2.147483647E9;
        double maxX = -2.147483648E9;
        double maxY = -2.147483648E9;
        double maxZ = -2.147483648E9;
        this.worldCollisionBoxes = new ArrayList<OrientatedBoundingBox>();
        for (TileEntityLittleTiles te : this.blocks) {
            AxisAlignedBB bb = te.getSelectionBox();
            minX = Math.min(minX, bb.field_72340_a);
            minY = Math.min(minY, bb.field_72338_b);
            minZ = Math.min(minZ, bb.field_72339_c);
            maxX = Math.max(maxX, bb.field_72336_d);
            maxY = Math.max(maxY, bb.field_72337_e);
            maxZ = Math.max(maxZ, bb.field_72334_f);
            ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
            for (LittleTile tile : te) {
                List<LittleBox> tileBoxes = tile.getCollisionBoxes();
                for (LittleBox box : tileBoxes) {
                    boxes.add(box.getBox(te.getContext(), te.func_174877_v()));
                }
            }
            for (AxisAlignedBB box : boxes) {
                this.worldCollisionBoxes.add(new OrientatedBoundingBox(this.origin, box));
            }
        }
        this.collisionBoxWorker = new AABBCombiner(this.worldCollisionBoxes, 0.0);
        this.worldBoundingBox = new OrientatedBoundingBox(this.origin, minX, minY, minZ, maxX, maxY, maxZ);
    }

    private static double minIgnore(double par1, double par2) {
        if (Math.abs(par2) < Math.abs(par1)) {
            return par2;
        }
        return par1;
    }

    private static double maxIgnore(double par1, double par2) {
        if (Math.abs(par2) > Math.abs(par1)) {
            return par2;
        }
        return par1;
    }

    public double getRot(EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return this.worldRotX;
            }
            case Y: {
                return this.worldRotY;
            }
            case Z: {
                return this.worldRotZ;
            }
        }
        return 0.0;
    }

    public void rotXTo(double x) {
        this.rotateAnimation(x - this.worldRotX, 0.0, 0.0);
    }

    public void rotYTo(double y) {
        this.rotateAnimation(0.0, y - this.worldRotY, 0.0);
    }

    public void rotZTo(double z) {
        this.rotateAnimation(0.0, 0.0, z - this.worldRotZ);
    }

    public void rotateAnimation(double rotX, double rotY, double rotZ) {
        this.moveAndRotateAnimation(0.0, 0.0, 0.0, rotX, rotY, rotZ);
    }

    public void moveAndRotateAnimation(double x, double y, double z, double rotX, double rotY, double rotZ) {
        this.field_70165_t += x;
        this.field_70163_u += y;
        this.field_70161_v += z;
        this.worldRotX += rotX;
        this.worldRotY += rotY;
        this.worldRotZ += rotZ;
        this.updateOrigin();
    }

    public void moveXTo(double x) {
        this.moveAnimation(x - this.field_70165_t, 0.0, 0.0);
    }

    public void moveYTo(double y) {
        this.moveAnimation(0.0, y - this.field_70163_u, 0.0);
    }

    public void moveZTo(double z) {
        this.moveAnimation(0.0, 0.0, z - this.field_70161_v);
    }

    public void moveAnimation(double x, double y, double z) {
        this.moveAndRotateAnimation(x, y, z, 0.0, 0.0, 0.0);
    }

    @SideOnly(value=Side.CLIENT)
    public void unloadRenderCache() {
        if (this.renderChunks == null) {
            return;
        }
        for (LittleRenderChunk chunk : this.renderChunks.values()) {
            chunk.unload();
        }
    }

    public EntityOldAnimation(World worldIn) {
        super(worldIn);
    }

    public EntityOldAnimation(World world, CreativeWorld fakeWorld, ArrayList<TileEntityLittleTiles> blocks, LittleAbsolutePreviews previews, UUID uuid, LittleAbsoluteVec center, LittleVec additional) {
        this(world);
        this.blocks = blocks;
        this.previews = previews;
        this.field_96093_i = uuid;
        this.field_189513_ar = this.field_96093_i.toString();
        this.fakeWorld = fakeWorld;
        this.fakeWorld.parent = this;
        this.setCenterVec(center, additional);
        this.updateWorldCollision();
        this.func_70107_b(this.baseOffset.func_177958_n(), this.baseOffset.func_177956_o(), this.baseOffset.func_177952_p());
    }

    @SideOnly(value=Side.CLIENT)
    public void createClient() {
        if (this.blocks != null) {
            this.renderChunks = new LinkedHashMap();
            this.renderQueue = new ArrayList<TileEntityLittleTiles>(this.blocks);
        }
    }

    protected void handleForces() {
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
    }

    public void updateBoundingBox() {
        boolean moved;
        if (this.worldBoundingBox == null || this.fakeWorld == null) {
            return;
        }
        boolean rotated = this.prevWorldRotX != this.worldRotX || this.prevWorldRotY != this.worldRotY || this.field_70166_s != this.worldRotZ;
        boolean bl = moved = this.field_70169_q != this.field_70165_t || this.field_70167_r != this.field_70163_u || this.field_70166_s != this.field_70161_v;
        if (rotated || moved) {
            this.func_174826_a(this.origin.getAxisAlignedBox((AxisAlignedBB)this.worldBoundingBox));
        }
    }

    public void updateOrigin() {
        this.origin.off(this.field_70165_t - (double)this.getAxisPos().func_177958_n(), this.field_70163_u - (double)this.getAxisPos().func_177956_o(), this.field_70161_v - (double)this.getAxisPos().func_177952_p());
        this.origin.rot(this.worldRotX, this.worldRotY, this.worldRotZ);
    }

    public void onTick() {
    }

    public void onPostTick() {
    }

    public void func_70071_h_() {
        this.onUpdateForReal();
    }

    public void onUpdateForReal() {
        if (this.blocks == null && !this.field_70170_p.field_72995_K) {
            this.field_70128_L = true;
        }
        if (this.blocks == null) {
            return;
        }
        if (this.collisionBoxWorker != null) {
            this.collisionBoxWorker.work();
            if (this.collisionBoxWorker.hasFinished()) {
                this.collisionBoxWorker = null;
            }
        }
        this.prevWorldRotX = this.worldRotX;
        this.prevWorldRotY = this.worldRotY;
        this.prevWorldRotZ = this.worldRotZ;
        this.handleForces();
        super.func_70071_h_();
        this.onTick();
        this.onPostTick();
        this.updateBoundingBox();
        for (TileEntity te : this.fakeWorld.field_175730_i) {
            ((ITickable)te).func_73660_a();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
    }

    public void func_70080_a(double x, double y, double z, float yaw, float pitch) {
    }

    public void func_70634_a(double x, double y, double z) {
    }

    public void func_70012_b(double x, double y, double z, float yaw, float pitch) {
    }

    public void setInitialPosition(double x, double y, double z) {
        this.func_70107_b(x, y, z);
    }

    public void func_70107_b(double x, double y, double z) {
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        this.updateBoundingBox();
    }

    public void func_70106_y() {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70128_L = true;
        }
    }

    public boolean func_70067_L() {
        return true;
    }

    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return null;
    }

    public AxisAlignedBB func_70046_E() {
        return null;
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        return true;
    }

    public EnumActionResult func_184199_a(EntityPlayer player, Vec3d vec, EnumHand hand) {
        return EnumActionResult.SUCCESS;
    }

    protected abstract void copyExtra(EntityOldAnimation var1);

    public EntityOldAnimation copy() {
        EntityOldAnimation animation = null;
        try {
            animation = (EntityOldAnimation)((Object)((Object)((Object)this)).getClass().getConstructor(World.class).newInstance(this.field_70170_p));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
        animation.func_184221_a(this.func_110124_au());
        animation.fakeWorld = this.fakeWorld;
        animation.setCenterVec(this.center.copy(), this.additionalAxis.copy());
        animation.previews = this.previews.copy();
        animation.blocks = this.blocks;
        animation.worldBoundingBox = this.worldBoundingBox;
        animation.worldCollisionBoxes = new ArrayList<OrientatedBoundingBox>(this.worldCollisionBoxes);
        if (this.field_70170_p.field_72995_K) {
            animation.renderChunks = this.renderChunks;
            animation.renderQueue = this.renderQueue;
        }
        animation.prevWorldRotX = this.prevWorldRotX;
        animation.prevWorldRotY = this.prevWorldRotY;
        animation.prevWorldRotZ = this.prevWorldRotZ;
        animation.worldRotX = this.worldRotX;
        animation.worldRotY = this.worldRotY;
        animation.worldRotZ = this.worldRotZ;
        this.copyExtra(animation);
        return animation;
    }

    protected void reloadPreviews(LittleStructure parent, BlockPos pos) {
        this.previews = parent.getAbsolutePreviews(pos);
    }

    public LittleStructure getParentStructure() {
        for (TileEntityLittleTiles te : this.blocks) {
            for (LittleTile tile : te) {
                if (tile.connection.isLink()) continue;
                LittleStructure structure = tile.connection.getStructureWithoutLoading();
                if (structure.parent != null && !structure.parent.isLinkToAnotherWorld()) continue;
                return structure;
            }
        }
        return null;
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.fakeWorld = compound.func_74767_n("subworld") ? SubWorld.createFakeWorld((World)this.field_70170_p) : FakeWorld.createFakeWorld((String)this.func_189512_bd(), (boolean)this.field_70170_p.field_72995_K);
        this.setCenterVec(new LittleAbsoluteVec("axis", compound), new LittleVec("additional", compound));
        NBTTagList list = compound.func_150295_c("tileEntity", (int)compound.func_74732_a());
        this.blocks = new ArrayList();
        LittleStructure parent = null;
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt = list.func_150305_b(i);
            TileEntityLittleTiles te = (TileEntityLittleTiles)TileEntity.func_190200_a((World)this.fakeWorld, (NBTTagCompound)nbt);
            te.func_145834_a((World)this.fakeWorld);
            this.blocks.add(te);
            for (LittleTile tile : te) {
                if (tile.connection.isLink()) continue;
                LittleStructure structure = tile.connection.getStructureWithoutLoading();
                if (structure.parent != null && !structure.parent.isLinkToAnotherWorld()) continue;
                parent = structure;
            }
            this.fakeWorld.func_175656_a(te.func_174877_v(), BlockTile.getState(te.isTicking(), te.isRendered()));
            this.fakeWorld.func_175690_a(te.func_174877_v(), (TileEntity)te);
        }
        int[] array = compound.func_74759_k("previewPos");
        BlockPos pos = array.length == 3 ? new BlockPos(array[0], array[1], array[2]) : this.baseOffset;
        this.reloadPreviews(parent, pos);
        this.updateWorldCollision();
        this.updateBoundingBox();
    }

    protected void func_70014_b(NBTTagCompound compound) {
        this.center.writeToNBT("axis", compound);
        this.additionalAxis.writeToNBT("additional", compound);
        compound.func_74757_a("subworld", this.fakeWorld.hasParent());
        NBTTagList list = new NBTTagList();
        for (TileEntityLittleTiles te : this.blocks) {
            list.func_74742_a((NBTBase)te.func_189515_b(new NBTTagCompound()));
        }
        compound.func_74782_a("tileEntity", (NBTBase)list);
        compound.func_74783_a("previewPos", new int[]{this.previews.pos.func_177958_n(), this.previews.pos.func_177956_o(), this.previews.pos.func_177952_p()});
    }
}

