/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.entity;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.mc.WorldUtils;
import com.creativemd.creativecore.common.utils.type.HashMapList;
import com.creativemd.creativecore.common.utils.type.UUIDSupplier;
import com.creativemd.creativecore.common.world.CreativeWorld;
import com.creativemd.creativecore.common.world.IOrientatedWorld;
import com.creativemd.littletiles.client.render.world.RenderUploader;
import com.creativemd.littletiles.client.render.world.RenderUtils;
import com.creativemd.littletiles.common.entity.EntityAnimationController;
import com.creativemd.littletiles.common.packet.LittlePlacedAnimationPacket;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.animation.AnimationController;
import com.creativemd.littletiles.common.structure.animation.AnimationState;
import com.creativemd.littletiles.common.structure.animation.AnimationTimeline;
import com.creativemd.littletiles.common.structure.type.door.LittleDoor;
import com.creativemd.littletiles.common.tile.preview.LittleAbsolutePreviews;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.util.place.Placement;
import com.creativemd.littletiles.common.util.place.PlacementHelper;
import com.creativemd.littletiles.common.util.place.PlacementMode;
import com.creativemd.littletiles.common.util.place.PlacementResult;
import com.creativemd.littletiles.common.util.vec.LittleTransformation;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class DoorController
extends EntityAnimationController {
    protected boolean placedOnServer = false;
    protected boolean isWaitingForApprove = false;
    protected int ticksToWait = -1;
    protected static final int waitTimeApprove = 300;
    protected Boolean placed = null;
    public static final String openedState = "opened";
    public static final String closedState = "closed";
    public Boolean turnBack;
    public int duration;
    public int completeDuration;
    public int interpolation;
    public EntityPlayer activator;
    public LittleDoor.DoorOpeningResult result;
    public UUIDSupplier supplier;
    public boolean noClip;
    protected boolean modifiedTransition;

    public DoorController() {
    }

    public DoorController(LittleDoor.DoorOpeningResult result, UUIDSupplier supplier, AnimationState closed, AnimationState opened, Boolean turnBack, int duration, int completeDuration, int interpolation) {
        this.result = result;
        this.supplier = supplier;
        this.turnBack = turnBack;
        this.duration = duration;
        this.completeDuration = completeDuration;
        this.interpolation = interpolation;
        this.addState(openedState, opened);
        this.addStateAndSelect(closedState, closed);
        this.generateAllTransistions(duration);
        this.modifiedTransition = false;
        this.stretchTransitions();
    }

    public DoorController(LittleDoor.DoorOpeningResult result, UUIDSupplier supplier, AnimationState closed, AnimationState opened, Boolean turnBack, int duration, int completeDuration, AnimationTimeline open, AnimationTimeline close, int interpolation) {
        this.result = result;
        this.supplier = supplier;
        this.turnBack = turnBack;
        this.duration = duration;
        this.completeDuration = completeDuration;
        this.interpolation = interpolation;
        this.addState(openedState, opened);
        this.addStateAndSelect(closedState, closed);
        this.addTransition(closedState, openedState, open);
        this.addTransition(openedState, closedState, close);
        this.stretchTransitions();
    }

    @Override
    public boolean noClip() {
        return this.noClip;
    }

    @Override
    public AnimationController addTransition(String from, String to, AnimationTimeline animation) {
        this.modifiedTransition = true;
        return super.addTransition(from, to, animation);
    }

    public DoorController(LittleDoor.DoorOpeningResult result, UUIDSupplier supplier, AnimationState opened, Boolean turnBack, int duration, int completeDuration, int interpolation) {
        this(result, supplier, new AnimationState(), opened, turnBack, duration, completeDuration, interpolation);
    }

    protected void stretchTransitions() {
        this.completeDuration = Math.max(this.completeDuration, this.duration);
        for (AnimationTimeline timeline : this.stateTransition.values()) {
            timeline.duration = this.completeDuration;
        }
    }

    @Override
    public int getInterpolationType() {
        return this.interpolation;
    }

    @Override
    public EntityPlayer activator() {
        return this.activator;
    }

    public void markWaitingForApprove() {
        this.isWaitingForApprove = true;
    }

    public boolean activate() {
        if (this.placed != null) {
            return false;
        }
        boolean isOpen = this.currentState.name.equals(openedState);
        if (!this.isChanging()) {
            this.startTransition(isOpen ? closedState : openedState);
            return true;
        }
        return false;
    }

    @Override
    public AnimationState tick() {
        if (this.parent.field_70170_p.field_72995_K && this.placed != null) {
            if (this.isWaitingForApprove) {
                if (this.ticksToWait < 0) {
                    this.ticksToWait = 300;
                } else if (this.ticksToWait == 0) {
                    this.parent.field_70128_L = true;
                } else {
                    --this.ticksToWait;
                }
            } else {
                this.place();
            }
        }
        if (this.isChanging()) {
            if (!this.parent.structure.loadChildren()) {
                return this.currentState.state;
            }
            ((LittleDoor)this.parent.structure).beforeTick(this.parent, this.tick);
            AnimationState state = super.tick();
            ((LittleDoor)this.parent.structure).afterTick(this.parent, this.tick);
            return state;
        }
        return super.tick();
    }

    @Override
    public void startTransition(String key) {
        super.startTransition(key);
        ((LittleDoor)this.parent.structure).startAnimation(this.parent);
    }

    @Override
    public void endTransition() {
        super.endTransition();
        ((LittleDoor)this.parent.structure).finishAnimation(this.parent);
        if (this.turnBack != null && this.turnBack.booleanValue() == this.currentState.name.equals(openedState)) {
            if (this.isWaitingForApprove) {
                this.placed = false;
            } else {
                this.place();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void place() {
        LittleDoor newDoor;
        if (!this.parent.structure.load()) {
            System.out.println(new TextComponentTranslation("exception.door.notloaded", new Object[0]).func_150254_d());
            return;
        }
        if (!this.parent.structure.loadChildren()) {
            System.out.println(new TextComponentTranslation("exception.door.brokenchild", new Object[0]).func_150254_d());
            return;
        }
        if (!this.parent.structure.loadParent()) {
            System.out.println(new TextComponentTranslation("exception.door.brokenparent", new Object[0]).func_150254_d());
            return;
        }
        World world = this.parent.field_70170_p;
        LittleAbsolutePreviews previews = this.parent.structure.getAbsolutePreviewsSameWorldOnly(this.parent.absolutePreviewPos);
        Placement placement = new Placement(null, PlacementHelper.getAbsolutePreviews(world, previews, previews.pos, PlacementMode.all));
        PlacementResult result = placement.tryPlace();
        if (result != null) {
            newDoor = (LittleDoor)result.parentStructure;
            if (!(world instanceof CreativeWorld) && world.field_72995_K && !this.placedOnServer) {
                newDoor.waitingForApproval = true;
            }
            if (this.parent.structure.parent != null) {
                LittleStructure parentStructure = this.parent.structure.parent.getStructure(world);
                newDoor.updateParentConnection(this.parent.structure.parent.getChildID(), parentStructure);
                parentStructure.updateChildConnection(this.parent.structure.parent.getChildID(), newDoor);
            }
        } else {
            this.parent.markRemoved();
            if (!world.field_72995_K) {
                WorldUtils.dropItem((World)world, (ItemStack)this.parent.structure.getStructureDrop(), (BlockPos)this.parent.center.baseOffset);
            }
            return;
        }
        newDoor.transferChildrenFromAnimation(this.parent);
        this.parent.markRemoved();
        if (!world.field_72995_K) {
            WorldServer serverWorld = (WorldServer)(world instanceof IOrientatedWorld ? ((IOrientatedWorld)world).getRealWorld() : world);
            PacketHandler.sendPacketToTrackingPlayers((CreativeCorePacket)new LittlePlacedAnimationPacket(newDoor.getMainTile(), this.parent.func_110124_au()), (Entity)this.parent.getAbsoluteParent(), (WorldServer)serverWorld, null);
        } else {
            boolean subWorld = world instanceof IOrientatedWorld;
            HashMapList chunks = subWorld ? null : new HashMapList();
            for (TileEntityLittleTiles te : result.tileEntities) {
                TileEntity oldTE;
                if (te.inRenderingQueue == null) {
                    te.inRenderingQueue = new AtomicBoolean();
                }
                if (!((oldTE = this.parent.fakeWorld.func_175625_s(te.func_174877_v())) instanceof TileEntityLittleTiles) || ((TileEntityLittleTiles)oldTE).buffer == null) continue;
                AtomicBoolean atomicBoolean = te.inRenderingQueue;
                synchronized (atomicBoolean) {
                    if (te.inRenderingQueue.get() || te.buffer != null && te.buffer.isEmpty()) {
                        if (te.buffer == null) {
                            te.buffer = ((TileEntityLittleTiles)oldTE).buffer;
                        } else {
                            te.buffer.combine(((TileEntityLittleTiles)oldTE).buffer);
                        }
                    }
                    if (subWorld) {
                        RenderUtils.getRenderChunk((IOrientatedWorld)te.func_145831_w(), te.func_174877_v()).addRenderData(te);
                    } else {
                        chunks.add((Object)RenderUtils.getRenderChunk(RenderUtils.getViewFrustum(), te.func_174877_v()), (Object)((TileEntityLittleTiles)oldTE));
                    }
                }
            }
            if (!subWorld) {
                for (Map.Entry entry : chunks.entrySet()) {
                    RenderUploader.uploadRenderData((RenderChunk)entry.getKey(), (List)entry.getValue());
                }
            }
            this.placed = true;
        }
    }

    @Override
    protected void writeToNBTExtra(NBTTagCompound nbt) {
        nbt.func_74782_a(closedState, (NBTBase)this.getState((String)closedState).state.writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a(openedState, (NBTBase)this.getState((String)openedState).state.writeToNBT(new NBTTagCompound()));
        if (!this.result.isEmpty()) {
            nbt.func_74782_a("result", (NBTBase)this.result.nbt);
        }
        nbt.func_74778_a("originaluuid", this.supplier.original().toString());
        nbt.func_74778_a("uuid", this.supplier.uuid.toString());
        nbt.func_74757_a("isOpen", this.currentState.name.equals(openedState));
        if (this.isChanging()) {
            nbt.func_74768_a("tick", this.tick);
        }
        nbt.func_74768_a("duration", this.duration);
        nbt.func_74768_a("completeDuration", this.completeDuration);
        nbt.func_74774_a("turnBack", (byte)(this.turnBack == null ? 0 : (this.turnBack != false ? 1 : -1)));
        nbt.func_74768_a("interpolation", this.interpolation);
        if (this.modifiedTransition) {
            NBTTagList list = new NBTTagList();
            for (Map.Entry entry : this.stateTransition.entrySet()) {
                NBTTagCompound transitionNBT = ((AnimationTimeline)entry.getValue()).writeToNBT(new NBTTagCompound());
                transitionNBT.func_74778_a("key", (String)entry.getKey());
                list.func_74742_a((NBTBase)transitionNBT);
            }
            nbt.func_74782_a("transitions", (NBTBase)list);
        }
        nbt.func_74757_a("noClip", this.noClip);
    }

    @Override
    protected void readFromNBT(NBTTagCompound nbt) {
        byte turnBackData;
        this.addState(closedState, new AnimationState(nbt.func_74775_l(closedState)));
        this.addState(openedState, new AnimationState(nbt.func_74775_l(openedState)));
        this.result = nbt.func_74764_b("result") ? new LittleDoor.DoorOpeningResult(nbt.func_74775_l("result")) : LittleDoor.EMPTY_OPENING_RESULT;
        this.supplier = new UUIDSupplier(UUID.fromString(nbt.func_74779_i("originaluuid")), UUID.fromString(nbt.func_74779_i("uuid")));
        this.duration = nbt.func_74762_e("duration");
        this.completeDuration = nbt.func_74762_e("completeDuration");
        this.interpolation = nbt.func_74762_e("interpolation");
        if (nbt.func_74764_b("transitions")) {
            NBTTagList list = nbt.func_150295_c("transitions", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound transitionNBT = list.func_150305_b(i);
                this.addTransition(transitionNBT.func_74779_i("key"), new AnimationTimeline(transitionNBT));
            }
            this.modifiedTransition = true;
        } else {
            this.generateAllTransistions(this.duration);
            this.stretchTransitions();
        }
        boolean isOpen = nbt.func_74767_n("isOpen");
        this.currentState = isOpen ? this.getState(openedState) : this.getState(closedState);
        if (nbt.func_74764_b("tick")) {
            this.startTransition(isOpen ? closedState : openedState);
            this.tick = nbt.func_74762_e("tick");
        }
        this.turnBack = (turnBackData = nbt.func_74771_c("turnBack")) == 0 ? null : Boolean.valueOf(turnBackData > 0);
        this.noClip = nbt.func_74767_n("noClip");
    }

    @Override
    public void onServerApproves() {
        this.isWaitingForApprove = false;
    }

    @Override
    public void onServerPlaces() {
        this.placedOnServer = true;
    }

    @Override
    public void transform(LittleTransformation transformation) {
        for (AnimationController.AnimationControllerState state : this.states.values()) {
            state.transform(transformation);
        }
        for (AnimationTimeline timeline : this.stateTransition.values()) {
            int i;
            Rotation rotation;
            if (transformation.rotX != 0) {
                rotation = transformation.getRotation(EnumFacing.Axis.X);
                for (i = 0; i < Math.abs(transformation.rotX); ++i) {
                    timeline.transform(rotation);
                }
            }
            if (transformation.rotY != 0) {
                rotation = transformation.getRotation(EnumFacing.Axis.Y);
                for (i = 0; i < Math.abs(transformation.rotY); ++i) {
                    timeline.transform(rotation);
                }
            }
            if (transformation.rotZ == 0) continue;
            rotation = transformation.getRotation(EnumFacing.Axis.Z);
            for (i = 0; i < Math.abs(transformation.rotZ); ++i) {
                timeline.transform(rotation);
            }
        }
        if (this.tickingState != null) {
            this.tickingState.clear();
        } else if (this.isChanging()) {
            this.tickingState = new AnimationState();
        }
        if (this.isChanging()) {
            this.animation.tick(this.tick, this.tickingState);
        }
    }
}

