/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.command;

import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.type.door.LittleDoor;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.world.WorldAnimationHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class OpenCommand
extends CommandBase {
    public String func_71517_b() {
        return "lt-open";
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.open.usage";
    }

    protected boolean checkStructureName(LittleStructure structure, String[] args) {
        if (args.length > 3) {
            for (int i = 3; i < args.length; ++i) {
                if (structure.name == null || !structure.name.equalsIgnoreCase(args[i])) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 3) {
            throw new WrongUsageException("commands.open.usage", new Object[0]);
        }
        BlockPos blockpos = OpenCommand.func_175757_a((ICommandSender)sender, (String[])args, (int)0, (boolean)false);
        World world = sender.func_130014_f_();
        ArrayList<LittleDoor> doors = new ArrayList<LittleDoor>();
        for (LittleDoor door : WorldAnimationHandler.getHandler(world).findAnimations(blockpos)) {
            if (!this.checkStructureName(door, args)) continue;
            doors.add(door);
        }
        TileEntity tileEntity = world.func_175625_s(blockpos);
        if (tileEntity instanceof TileEntityLittleTiles) {
            for (LittleTile tile : (TileEntityLittleTiles)tileEntity) {
                LittleStructure structure;
                if (!tile.isConnectedToStructure() || !((structure = tile.connection.getStructure(tile.te.func_145831_w())) instanceof LittleDoor) || !this.checkStructureName(structure = ((LittleDoor)structure).getParentDoor(), args) || doors.contains(structure)) continue;
                if (structure.load()) {
                    doors.add((LittleDoor)structure);
                    continue;
                }
                OpenCommand.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"commands.open.notloaded", (Object[])new Object[0]);
            }
        }
        for (LittleDoor door : doors) {
            try {
                door.activate(null, null, null, true);
            }
            catch (LittleActionException littleActionException) {}
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length > 0 && args.length <= 3) {
            return OpenCommand.func_175771_a((String[])args, (int)0, (BlockPos)targetPos);
        }
        return Collections.emptyList();
    }
}

