/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.block;

import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.api.IFakeRenderingBlock;
import com.creativemd.littletiles.common.api.block.ISpecialBlockHandler;
import com.creativemd.littletiles.common.tile.LittleTile;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockLTTransparentColored
extends Block
implements ISpecialBlockHandler,
IFakeRenderingBlock {
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);

    public BlockLTTransparentColored() {
        super(Material.field_151576_e);
        this.func_149647_a(LittleTiles.littleTab);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)EnumType.clean)));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        IBlockState iblockstate = blockAccess.func_180495_p(pos.func_177972_a(side));
        Block block = iblockstate.func_177230_c();
        if (block == this && blockState.func_177229_b(VARIANT) == iblockstate.func_177229_b(VARIANT)) {
            return false;
        }
        return super.func_176225_a(blockState, blockAccess, pos, side);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (int i = 0; i < EnumType.values().length; ++i) {
            items.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    @Override
    public boolean canWalkThrough(LittleTile tile) {
        return ((EnumType)((Object)tile.getBlockState().func_177229_b(VARIANT))).isWater();
    }

    @Override
    public boolean isMaterial(LittleTile tile, Material material) {
        if (((EnumType)((Object)tile.getBlockState().func_177229_b(VARIANT))).isWater()) {
            return material == Material.field_151586_h;
        }
        return ISpecialBlockHandler.super.isMaterial(tile, material);
    }

    @Override
    public boolean isLiquid(LittleTile tile) {
        if (((EnumType)((Object)tile.getBlockState().func_177229_b(VARIANT))).isWater()) {
            return true;
        }
        return ISpecialBlockHandler.super.isLiquid(tile);
    }

    @Override
    public boolean canBeConvertedToVanilla(LittleTile tile) {
        return !((EnumType)((Object)tile.getBlockState().func_177229_b(VARIANT))).isWater();
    }

    @Override
    public IBlockState getFakeState(IBlockState state) {
        if (((EnumType)((Object)state.func_177229_b(VARIANT))).isWater()) {
            return Blocks.field_150355_j.func_176223_P();
        }
        return state;
    }

    @Override
    public boolean onBlockActivated(LittleTile tile, World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (((EnumType)((Object)state.func_177229_b(VARIANT))).isWater() && hand == EnumHand.MAIN_HAND && heldItem.func_77973_b() instanceof ItemBucket) {
            if (state.func_177229_b(VARIANT) == EnumType.water) {
                tile.setBlock(LittleTiles.flowingWater, 0);
            } else {
                tile.setBlock(LittleTiles.whiteFlowingWater, 0);
            }
            tile.te.updateTiles();
            return true;
        }
        return ISpecialBlockHandler.super.onBlockActivated(tile, worldIn, pos, state, playerIn, hand, heldItem, side, hitX, hitY, hitZ);
    }

    @Override
    public Vec3d getFogColor(World world, LittleTile tile, BlockPos pos, IBlockState state, Entity entity, Vec3d originalColor, float partialTicks) {
        if (((EnumType)((Object)state.func_177229_b(VARIANT))).isWater()) {
            float f12 = 0.0f;
            if (entity instanceof EntityLivingBase) {
                EntityLivingBase ent = (EntityLivingBase)entity;
                f12 = (float)EnchantmentHelper.func_185292_c((EntityLivingBase)ent) * 0.2f;
                if (ent.func_70644_a(MobEffects.field_76427_o)) {
                    f12 = f12 * 0.3f + 0.6f;
                }
            }
            return new Vec3d((double)(0.02f + f12), (double)(0.02f + f12), (double)(0.2f + f12));
        }
        return ISpecialBlockHandler.super.getFogColor(world, tile, pos, state, entity, originalColor, partialTicks);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canBeRenderCombined(LittleTile thisTile, LittleTile tile) {
        if (EnumType.values()[thisTile.getMeta()].isWater()) {
            return tile.getBlock() == LittleTiles.flowingWater;
        }
        return false;
    }

    public static enum EnumType implements IStringSerializable
    {
        clean,
        thick,
        thin,
        thinner,
        thinnest,
        water{

            @Override
            public boolean isWater() {
                return true;
            }
        }
        ,
        white_water{

            @Override
            public boolean isWater() {
                return true;
            }
        };


        public boolean isWater() {
            return false;
        }

        public static EnumType byMetadata(int meta) {
            return EnumType.values()[meta];
        }

        public int getMetadata() {
            return this.ordinal();
        }

        public String func_176610_l() {
            return this.name();
        }
    }
}

