/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.block;

import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.api.block.ISpecialBlockHandler;
import com.creativemd.littletiles.common.tile.LittleTile;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockLTColored
extends Block
implements ISpecialBlockHandler {
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);

    public BlockLTColored() {
        super(Material.field_151576_e);
        this.func_149647_a(LittleTiles.littleTab);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)EnumType.clean)));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (int i = 0; i < EnumType.values().length; ++i) {
            items.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public int func_149750_m(IBlockState state) {
        if (state.func_177229_b(VARIANT) == EnumType.light_clean) {
            return 15;
        }
        return 0;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state.func_177229_b(VARIANT) == EnumType.light_clean) {
            return 15;
        }
        return 0;
    }

    @Override
    public boolean canWalkThrough(LittleTile tile) {
        return ((EnumType)((Object)tile.getBlockState().func_177229_b(VARIANT))).isLava();
    }

    @Override
    public boolean isMaterial(LittleTile tile, Material material) {
        if (((EnumType)((Object)tile.getBlockState().func_177229_b(VARIANT))).isLava()) {
            return material == Material.field_151587_i;
        }
        return ISpecialBlockHandler.super.isMaterial(tile, material);
    }

    @Override
    public boolean isLiquid(LittleTile tile) {
        if (((EnumType)((Object)tile.getBlockState().func_177229_b(VARIANT))).isLava()) {
            return true;
        }
        return ISpecialBlockHandler.super.isLiquid(tile);
    }

    @Override
    public boolean canBeConvertedToVanilla(LittleTile tile) {
        return !((EnumType)((Object)tile.getBlockState().func_177229_b(VARIANT))).isLava();
    }

    @Override
    public boolean onBlockActivated(LittleTile tile, World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (((EnumType)((Object)state.func_177229_b(VARIANT))).isLava() && hand == EnumHand.MAIN_HAND && heldItem.func_77973_b() instanceof ItemBucket) {
            if (state.func_177229_b(VARIANT) == EnumType.lava) {
                tile.setBlock(LittleTiles.flowingLava, 0);
            } else {
                tile.setBlock(LittleTiles.whiteFlowingLava, 0);
            }
            tile.te.updateTiles();
            return true;
        }
        return ISpecialBlockHandler.super.onBlockActivated(tile, worldIn, pos, state, playerIn, hand, heldItem, side, hitX, hitY, hitZ);
    }

    @Override
    public Vec3d getFogColor(World world, LittleTile tile, BlockPos pos, IBlockState state, Entity entity, Vec3d originalColor, float partialTicks) {
        if (((EnumType)((Object)state.func_177229_b(VARIANT))).isLava()) {
            return new Vec3d((double)0.6f, (double)0.1f, 0.0);
        }
        return ISpecialBlockHandler.super.getFogColor(world, tile, pos, state, entity, originalColor, partialTicks);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canBeRenderCombined(LittleTile thisTile, LittleTile tile) {
        if (EnumType.values()[thisTile.getMeta()].isLava()) {
            return tile.getBlock() == LittleTiles.flowingLava;
        }
        return false;
    }

    public static enum EnumType implements IStringSerializable
    {
        clean,
        floor,
        grainy_big,
        grainy,
        grainy_low,
        brick,
        bordered,
        brick_big,
        structured,
        broken_brick_big,
        clay,
        light_clean,
        lava{

            @Override
            public boolean isLava() {
                return true;
            }
        }
        ,
        plank,
        white_lava{

            @Override
            public boolean isLava() {
                return true;
            }
        };


        public boolean isLava() {
            return false;
        }

        public static EnumType byMetadata(int meta) {
            return EnumType.values()[meta];
        }

        public int getMetadata() {
            return this.ordinal();
        }

        public String func_176610_l() {
            return this.name();
        }
    }
}

