/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.api.block;

import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface ISpecialBlockHandler {
    default public boolean canBeConvertedToVanilla(LittleTile tile) {
        return true;
    }

    default public List<LittleBox> getCollisionBoxes(LittleTile tile, List<LittleBox> defaultBoxes) {
        if (this.canWalkThrough(tile)) {
            return Collections.EMPTY_LIST;
        }
        return defaultBoxes;
    }

    default public boolean canWalkThrough(LittleTile tile) {
        return false;
    }

    default public boolean onBlockActivated(LittleTile tile, World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    default public void onTileExplodes(LittleTile tile, Explosion explosion) {
    }

    default public void randomDisplayTick(LittleTile tile, IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
    }

    default public boolean isMaterial(LittleTile tile, Material material) {
        return tile.getBlockState().func_185904_a() == material;
    }

    default public boolean isLiquid(LittleTile tile) {
        return tile.getBlockState().func_185904_a().func_76224_d();
    }

    default public Vec3d modifyAcceleration(LittleTile tile, Entity entityIn, Vec3d motion) {
        return null;
    }

    default public LittlePreview getPreview(LittleTile tile) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    default public boolean canBeRenderCombined(LittleTile thisTile, LittleTile tile) {
        return false;
    }

    default public boolean shouldCheckForCollision(LittleTile tile) {
        return false;
    }

    default public void onEntityCollidedWithBlock(World worldIn, LittleTile tile, BlockPos pos, IBlockState state, Entity entityIn) {
    }

    default public Vec3d getFogColor(World world, LittleTile tile, BlockPos pos, IBlockState state, Entity entity, Vec3d originalColor, float partialTicks) {
        return originalColor;
    }

    default public void flipPreview(EnumFacing.Axis axis, LittlePreview preview, LittleVec doubledCenter) {
    }

    default public void rotatePreview(Rotation rotation, LittlePreview preview, LittleVec doubledCenter) {
    }
}

