/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.action.block;

import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionCombined;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.LittleActionInteract;
import com.creativemd.littletiles.common.action.block.LittleActionDestroyBoxes;
import com.creativemd.littletiles.common.action.block.LittleActionPlaceAbsolute;
import com.creativemd.littletiles.common.block.BlockTile;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.math.box.LittleAbsoluteBox;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.box.LittleBoxes;
import com.creativemd.littletiles.common.tile.preview.LittleAbsolutePreviews;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.tile.registry.LittleTileRegistry;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tileentity.TileList;
import com.creativemd.littletiles.common.util.ingredient.LittleInventory;
import com.creativemd.littletiles.common.util.place.Placement;
import com.creativemd.littletiles.common.util.place.PlacementHelper;
import com.creativemd.littletiles.common.util.place.PlacementMode;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class LittleActionReplace
extends LittleActionInteract {
    public LittlePreview toReplace;
    public LittleAbsolutePreviews replacedTiles;
    public LittleBoxes boxes;

    public LittleActionReplace(World world, BlockPos blockPos, EntityPlayer player, LittlePreview toReplace) {
        super(world, blockPos, player);
        this.toReplace = toReplace;
    }

    public LittleActionReplace() {
    }

    @Override
    public void writeBytes(ByteBuf buf) {
        super.writeBytes(buf);
        NBTTagCompound nbt = new NBTTagCompound();
        this.toReplace.writeToNBT(nbt);
        LittleActionReplace.writeNBT((ByteBuf)buf, (NBTTagCompound)nbt);
    }

    @Override
    public void readBytes(ByteBuf buf) {
        super.readBytes(buf);
        this.toReplace = LittleTileRegistry.loadPreview(LittleActionReplace.readNBT((ByteBuf)buf));
    }

    @Override
    protected boolean isRightClick() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean action(World world, TileEntityLittleTiles te, LittleTile tile, ItemStack stack, EntityPlayer player, RayTraceResult moving, BlockPos pos, boolean secondMode) throws LittleActionException {
        if (!world.field_72995_K) {
            BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, te.func_174877_v(), te.getBlockTileState(), player);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) {
                LittleActionReplace.sendBlockResetToClient(world, (EntityPlayerMP)player, te);
                return false;
            }
        }
        this.replacedTiles = new LittleAbsolutePreviews(pos, te.getContext());
        this.boxes = new LittleBoxes(pos, te.getContext());
        if (LittleTiles.CONFIG.isTransparencyRestricted(player)) {
            LittleActionReplace.isAllowedToPlacePreview(player, this.toReplace);
        }
        if (BlockTile.selectEntireBlock(player, secondMode)) {
            ArrayList<LittleTile> toRemove = new ArrayList<LittleTile>();
            LittlePreviews toBePlaced = new LittlePreviews(te.getContext());
            LittlePreviews previews = new LittlePreviews(te.getContext());
            for (LittleTile toDestroy : te) {
                if (toDestroy.isChildOfStructure() || !tile.canBeCombined(toDestroy) || !toDestroy.canBeCombined(tile)) continue;
                this.replacedTiles.addTile(toDestroy);
                this.boxes.addBox(toDestroy);
                toBePlaced.addTile(toDestroy);
                LittlePreview preview = this.toReplace.copy();
                preview.box = toDestroy.box;
                previews.addWithoutCheckingPreview(preview);
                toRemove.add(toDestroy);
            }
            if (toRemove.isEmpty()) {
                return false;
            }
            LittleInventory inventory = new LittleInventory(player);
            try {
                inventory.startSimulation();
                LittleActionReplace.take(player, inventory, LittleActionReplace.getIngredients(toBePlaced));
                LittleActionReplace.give(player, inventory, LittleActionReplace.getIngredients(this.replacedTiles));
            }
            finally {
                inventory.stopSimulation();
            }
            te.updateTiles(x -> {
                for (LittleTile toDestroy : toRemove) {
                    toDestroy.destroy((TileList)x);
                }
            });
            Placement placement = new Placement(player, PlacementHelper.getAbsolutePreviews(world, previews, pos, PlacementMode.normal));
            placement.place();
            LittleActionReplace.giveOrDrop(player, inventory, placement.unplaceableTiles);
        } else {
            if (tile.isChildOfStructure()) {
                return false;
            }
            LittleInventory inventory = new LittleInventory(player);
            this.replacedTiles.addTile(tile);
            this.boxes.addBox(tile);
            LittlePreviews toBePlaced = new LittlePreviews(te.getContext());
            this.toReplace.box = tile.box;
            toBePlaced.addPreview(null, this.toReplace, te.getContext());
            try {
                inventory.startSimulation();
                LittleActionReplace.take(player, inventory, LittleActionReplace.getIngredients(toBePlaced));
                LittleActionReplace.give(player, inventory, LittleActionReplace.getIngredients(this.replacedTiles));
            }
            finally {
                inventory.stopSimulation();
            }
            te.updateTiles(x -> tile.destroy((TileList)x));
            LittlePreviews previews = new LittlePreviews(te.getContext());
            previews.addWithoutCheckingPreview(this.toReplace);
            Placement placement = new Placement(player, PlacementHelper.getAbsolutePreviews(world, previews, pos, PlacementMode.normal));
            placement.place();
            LittleActionReplace.giveOrDrop(player, inventory, placement.unplaceableTiles);
        }
        world.func_184133_a((EntityPlayer)null, pos, tile.getSound().func_185845_c(), SoundCategory.BLOCKS, (tile.getSound().func_185843_a() + 1.0f) / 2.0f, tile.getSound().func_185847_b() * 0.8f);
        return true;
    }

    @Override
    public boolean canBeReverted() {
        return true;
    }

    @Override
    public LittleAction revert() throws LittleActionException {
        return new LittleActionCombined(new LittleActionDestroyBoxes(this.boxes), new LittleActionPlaceAbsolute(this.replacedTiles, PlacementMode.normal));
    }

    @Override
    public LittleAction flip(EnumFacing.Axis axis, LittleAbsoluteBox absoluteBox) {
        LittleBoxes boxes = this.boxes.copy();
        boxes.flip(axis, absoluteBox);
        LittleAbsolutePreviews previews = new LittleAbsolutePreviews(boxes.pos, boxes.context);
        for (LittleBox box : boxes) {
            LittlePreview preview = this.toReplace.copy();
            preview.box = box;
            previews.addWithoutCheckingPreview(preview);
        }
        return new LittleActionCombined(new LittleActionDestroyBoxes(boxes), new LittleActionPlaceAbsolute(previews, PlacementMode.normal));
    }
}

