/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.action.block;

import com.creativemd.creativecore.common.utils.mc.InventoryUtils;
import com.creativemd.creativecore.common.utils.mc.WorldUtils;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionCombined;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.block.LittleActionBoxes;
import com.creativemd.littletiles.common.action.block.LittleActionDestroy;
import com.creativemd.littletiles.common.action.block.LittleActionPlaceAbsolute;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.math.box.LittleAbsoluteBox;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.box.LittleBoxes;
import com.creativemd.littletiles.common.tile.preview.LittleAbsolutePreviews;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tileentity.TileList;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.ingredient.LittleIngredients;
import com.creativemd.littletiles.common.util.ingredient.LittleInventory;
import com.creativemd.littletiles.common.util.place.PlacementMode;
import com.creativemd.littletiles.common.util.selection.selector.TileSelector;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class LittleActionDestroyBoxes
extends LittleActionBoxes {
    public List<LittleActionDestroy.StructurePreview> destroyedStructures;
    public LittleAbsolutePreviews previews;
    public boolean doneSomething;

    public LittleActionDestroyBoxes(LittleBoxes boxes) {
        super(boxes);
    }

    public LittleActionDestroyBoxes() {
    }

    private boolean containsStructure(LittleStructure structure) {
        for (LittleActionDestroy.StructurePreview structurePreview : this.destroyedStructures) {
            if (structurePreview.structure != structure) continue;
            return true;
        }
        return false;
    }

    public boolean shouldSkipTile(LittleTile tile) {
        return false;
    }

    public LittleIngredients action(EntityPlayer player, TileEntityLittleTiles te, List<LittleBox> boxes, boolean simulate, LittleGridContext context) {
        this.doneSomething = false;
        if (this.previews == null) {
            this.previews = new LittleAbsolutePreviews(te.func_174877_v(), context);
        }
        LittleIngredients ingredients = new LittleIngredients();
        Consumer<TileList> consumer = x -> {
            for (LittleTile tile : te) {
                if (this.shouldSkipTile(tile)) continue;
                LittleBox intersecting = null;
                boolean intersects = false;
                for (int j = 0; j < boxes.size(); ++j) {
                    if (!tile.intersectsWith((LittleBox)boxes.get(j))) continue;
                    intersects = true;
                    intersecting = (LittleBox)boxes.get(j);
                    break;
                }
                if (!intersects) continue;
                this.doneSomething = true;
                if (!tile.isChildOfStructure() && tile.canBeSplitted() && !tile.equalsBox(intersecting)) {
                    double volume = 0.0;
                    LittlePreview preview = tile.getPreviewTile();
                    ArrayList<LittleBox> cutout = new ArrayList<LittleBox>();
                    List<LittleBox> newBoxes = tile.cutOut(boxes, cutout);
                    if (newBoxes != null) {
                        if (!simulate) {
                            for (int i = 0; i < newBoxes.size(); ++i) {
                                LittleTile newTile = tile.copy();
                                newTile.box = newBoxes.get(i);
                                newTile.place((TileList)x);
                            }
                            tile.destroy((TileList)x);
                        }
                        for (int l = 0; l < cutout.size(); ++l) {
                            volume += ((LittleBox)cutout.get(l)).getPercentVolume(context);
                            if (simulate) continue;
                            LittlePreview preview2 = preview.copy();
                            preview2.box = ((LittleBox)cutout.get(l)).copy();
                            this.previews.addPreview(te.func_174877_v(), preview2, te.getContext());
                        }
                    }
                    if (!(volume > 0.0)) continue;
                    ingredients.add(LittleActionDestroyBoxes.getIngredients(preview, volume));
                    continue;
                }
                if (!tile.isChildOfStructure()) {
                    ingredients.add(LittleActionDestroyBoxes.getIngredients(tile));
                }
                if (simulate) continue;
                if (tile.isChildOfStructure()) {
                    LittleStructure structure;
                    if (!tile.isConnectedToStructure() || !(structure = tile.connection.getStructure(te.func_145831_w())).load() || this.containsStructure(structure)) continue;
                    this.destroyedStructures.add(new LittleActionDestroy.StructurePreview(structure));
                    ItemStack drop = structure.getStructureDrop();
                    if (LittleActionDestroyBoxes.needIngredients(player) && !player.field_70170_p.field_72995_K && !InventoryUtils.addItemStackToInventory((IInventory)player.field_71071_by, (ItemStack)drop)) {
                        WorldUtils.dropItem((World)player.field_70170_p, (ItemStack)drop, (BlockPos)tile.te.func_174877_v());
                    }
                    tile.destroy((TileList)x);
                    continue;
                }
                this.previews.addTile(tile);
                tile.destroy((TileList)x);
            }
        };
        if (simulate) {
            te.updateTilesSecretly(consumer);
        } else {
            te.updateTiles(consumer);
        }
        return ingredients;
    }

    @Override
    public void action(World world, EntityPlayer player, BlockPos pos, IBlockState state, List<LittleBox> boxes, LittleGridContext context) throws LittleActionException {
        TileEntityLittleTiles tileEntity = LittleActionDestroyBoxes.loadTe(player, world, pos, true);
        if (tileEntity instanceof TileEntityLittleTiles) {
            TileEntityLittleTiles te;
            if (!world.field_72995_K) {
                BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, tileEntity.func_174877_v(), tileEntity.getBlockTileState(), player);
                MinecraftForge.EVENT_BUS.post((Event)event);
                if (event.isCanceled()) {
                    LittleActionDestroyBoxes.sendBlockResetToClient(world, (EntityPlayerMP)player, tileEntity);
                    return;
                }
            }
            if (context != (te = tileEntity).getContext()) {
                if (context.size < te.getContext().size) {
                    for (LittleBox box : boxes) {
                        box.convertTo(context, te.getContext());
                    }
                    context = te.getContext();
                } else {
                    te.convertTo(context);
                }
            }
            if (LittleActionDestroyBoxes.checkAndGive(player, new LittleInventory(player), this.action(player, tileEntity, boxes, true, context))) {
                this.action(player, tileEntity, boxes, false, context);
            }
            tileEntity.combineTiles();
            if (!this.doneSomething) {
                tileEntity.convertBlockToVanilla();
            }
        }
    }

    @Override
    protected boolean action(EntityPlayer player) throws LittleActionException {
        this.destroyedStructures = new ArrayList<LittleActionDestroy.StructurePreview>();
        return super.action(player);
    }

    @Override
    public boolean canBeReverted() {
        return true;
    }

    @Override
    public LittleAction revert() {
        boolean additionalPreviews = this.previews != null && this.previews.size() > 0;
        LittleAction[] actions = new LittleAction[(additionalPreviews ? 1 : 0) + this.destroyedStructures.size()];
        if (additionalPreviews) {
            this.previews.convertToSmallest();
            actions[0] = new LittleActionPlaceAbsolute(this.previews, PlacementMode.fill, true);
        }
        for (int i = 0; i < this.destroyedStructures.size(); ++i) {
            actions[additionalPreviews ? 1 : 0 + i] = this.destroyedStructures.get(i).getPlaceAction();
        }
        return new LittleActionCombined(actions);
    }

    public static List<LittleTile> removeBox(TileEntityLittleTiles te, LittleGridContext context, LittleBox toCut, boolean update) {
        if (context != te.getContext()) {
            if (context.size > te.getContext().size) {
                te.convertTo(context);
            } else {
                toCut.convertTo(context, te.getContext());
                context = te.getContext();
            }
        }
        ArrayList<LittleTile> removed = new ArrayList<LittleTile>();
        Consumer<TileList> consumer = x -> {
            for (LittleTile tile : te) {
                if (!tile.intersectsWith(toCut) || tile.isChildOfStructure() || !tile.canBeSplitted()) continue;
                tile.destroy((TileList)x);
                if (!tile.equalsBox(toCut)) {
                    LittleTile copy;
                    double volume = 0.0;
                    LittlePreview preview = tile.getPreviewTile();
                    ArrayList<LittleBox> cutout = new ArrayList<LittleBox>();
                    ArrayList<LittleBox> boxes = new ArrayList<LittleBox>();
                    boxes.add(toCut);
                    List<LittleBox> newBoxes = tile.cutOut(boxes, cutout);
                    if (newBoxes == null) continue;
                    for (LittleBox box : newBoxes) {
                        copy = tile.copy();
                        copy.box = box;
                        copy.place((TileList)x);
                    }
                    for (LittleBox box : cutout) {
                        copy = tile.copy();
                        copy.box = box;
                        removed.add(copy);
                    }
                    continue;
                }
                removed.add(tile);
            }
        };
        if (update) {
            te.updateTiles(consumer);
        } else {
            te.updateTilesSecretly(consumer);
        }
        return removed;
    }

    public static List<LittleTile> removeBoxes(TileEntityLittleTiles te, LittleGridContext context, List<LittleBox> boxes) {
        if (context != te.getContext()) {
            if (context.size > te.getContext().size) {
                te.convertTo(context);
            } else {
                for (LittleBox box : boxes) {
                    box.convertTo(context, te.getContext());
                }
                context = te.getContext();
            }
        }
        ArrayList<LittleTile> removed = new ArrayList<LittleTile>();
        te.updateTiles(x -> {
            for (LittleTile tile : te) {
                LittleBox intersecting = null;
                boolean intersects = false;
                for (int j = 0; j < boxes.size(); ++j) {
                    if (!tile.intersectsWith((LittleBox)boxes.get(j))) continue;
                    intersects = true;
                    intersecting = (LittleBox)boxes.get(j);
                    break;
                }
                if (!intersects || tile.isChildOfStructure() || !tile.canBeSplitted()) continue;
                tile.destroy((TileList)x);
                if (!tile.equalsBox(intersecting)) {
                    LittleTile copy;
                    double volume = 0.0;
                    LittlePreview preview = tile.getPreviewTile();
                    ArrayList<LittleBox> cutout = new ArrayList<LittleBox>();
                    List<LittleBox> newBoxes = tile.cutOut(boxes, cutout);
                    if (newBoxes == null) continue;
                    for (LittleBox box : newBoxes) {
                        copy = tile.copy();
                        copy.box = box;
                        copy.place((TileList)x);
                    }
                    for (LittleBox box : cutout) {
                        copy = tile.copy();
                        copy.box = box;
                        removed.add(copy);
                    }
                    continue;
                }
                removed.add(tile);
            }
        });
        return removed;
    }

    @Override
    public LittleAction flip(EnumFacing.Axis axis, LittleAbsoluteBox box) {
        return this.assignFlip(new LittleActionDestroyBoxes(), axis, box);
    }

    public static class LittleActionDestroyBoxesFiltered
    extends LittleActionDestroyBoxes {
        public TileSelector selector;

        public LittleActionDestroyBoxesFiltered(LittleBoxes boxes, TileSelector selector) {
            super(boxes);
            this.selector = selector;
        }

        public LittleActionDestroyBoxesFiltered() {
        }

        @Override
        public void writeBytes(ByteBuf buf) {
            super.writeBytes(buf);
            LittleActionDestroyBoxesFiltered.writeSelector(this.selector, buf);
        }

        @Override
        public void readBytes(ByteBuf buf) {
            super.readBytes(buf);
            this.selector = LittleActionDestroyBoxesFiltered.readSelector(buf);
        }

        @Override
        public boolean shouldSkipTile(LittleTile tile) {
            return !this.selector.is(tile);
        }
    }
}

