/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.action.block;

import com.creativemd.creativecore.common.utils.mc.ColorUtils;
import com.creativemd.creativecore.common.utils.type.HashMapList;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.LittleTilesConfig;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionCombined;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.block.LittleActionBoxes;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.LittleTileColored;
import com.creativemd.littletiles.common.tile.math.box.LittleAbsoluteBox;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.box.LittleBoxes;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tileentity.TileList;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.ingredient.ColorIngredient;
import com.creativemd.littletiles.common.util.ingredient.LittleIngredients;
import com.creativemd.littletiles.common.util.ingredient.LittleInventory;
import com.creativemd.littletiles.common.util.selection.selector.TileSelector;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class LittleActionColorBoxes
extends LittleActionBoxes {
    public int color;
    public boolean toVanilla;
    public HashMapList<Integer, LittleBoxes> revertList;
    public boolean doneSomething;
    private double colorVolume;

    public LittleActionColorBoxes(LittleBoxes boxes, int color, boolean toVanilla) {
        super(boxes);
        this.color = color;
        this.toVanilla = toVanilla;
    }

    public LittleActionColorBoxes() {
    }

    @Override
    public void writeBytes(ByteBuf buf) {
        super.writeBytes(buf);
        buf.writeInt(this.color);
        buf.writeBoolean(this.toVanilla);
    }

    @Override
    public void readBytes(ByteBuf buf) {
        super.readBytes(buf);
        this.color = buf.readInt();
        this.toVanilla = buf.readBoolean();
    }

    public void addRevert(int color, BlockPos pos, LittleGridContext context, List<LittleBox> boxes) {
        LittleBoxes newBoxes = new LittleBoxes(pos, context);
        for (LittleBox box : boxes) {
            newBoxes.add(box.copy());
        }
        this.revertList.add((Object)color, (Object)newBoxes);
    }

    public boolean shouldSkipTile(LittleTile tile) {
        return false;
    }

    public ColorIngredient action(TileEntityLittleTiles te, List<LittleBox> boxes, ColorIngredient gained, boolean simulate, LittleGridContext context) {
        this.doneSomething = false;
        this.colorVolume = 0.0;
        Consumer<TileList> consumer = x -> {
            for (LittleTile tile : te) {
                if (this.shouldSkipTile(tile)) continue;
                LittleBox intersecting = null;
                boolean intersects = false;
                for (int j = 0; j < boxes.size(); ++j) {
                    if (!tile.intersectsWith((LittleBox)boxes.get(j))) continue;
                    intersects = true;
                    intersecting = (LittleBox)boxes.get(j);
                    break;
                }
                if (!intersects || tile.getClass() != LittleTile.class && !(tile instanceof LittleTileColored) || tile.isChildOfStructure() && (!tile.isConnectedToStructure() || !tile.connection.getStructure(te.func_145831_w()).load()) || !LittleTileColored.needsToBeRecolored(tile, this.color)) continue;
                this.doneSomething = true;
                if (tile.canBeSplitted() && !tile.equalsBox(intersecting)) {
                    LittleTile newTile;
                    int i;
                    if (simulate) {
                        double volume = 0.0;
                        ArrayList<LittleBox> cutout = new ArrayList<LittleBox>();
                        tile.cutOut(boxes, cutout);
                        for (LittleBox box2 : cutout) {
                            this.colorVolume += box2.getPercentVolume(context);
                            volume += box2.getPercentVolume(context);
                        }
                        gained.add(ColorIngredient.getColors(tile.getPreviewTile(), volume));
                        continue;
                    }
                    ArrayList<LittleBox> cutout = new ArrayList<LittleBox>();
                    List<LittleBox> newBoxes = tile.cutOut(boxes, cutout);
                    if (newBoxes == null) continue;
                    this.addRevert(LittleTileColored.getColor(tile), te.func_174877_v(), context, cutout);
                    LittleTile tempTile = tile.copy();
                    LittleTile changedTile = LittleTileColored.setColor(tempTile, this.color);
                    if (changedTile == null) {
                        changedTile = tempTile;
                    }
                    if (tile.isConnectedToStructure()) {
                        tile.connection.getStructure(te.func_145831_w()).remove(tile);
                    }
                    for (i = 0; i < newBoxes.size(); ++i) {
                        newTile = tile.copy();
                        newTile.box = newBoxes.get(i);
                        newTile.place((TileList)x);
                        if (!tile.isConnectedToStructure()) continue;
                        tile.connection.getStructure(te.func_145831_w()).add(newTile);
                    }
                    for (i = 0; i < cutout.size(); ++i) {
                        newTile = changedTile.copy();
                        newTile.box = (LittleBox)cutout.get(i);
                        newTile.place((TileList)x);
                        if (!tile.isConnectedToStructure()) continue;
                        tile.connection.getStructure(te.func_145831_w()).add(newTile);
                    }
                    if (tile.isConnectedToStructure()) {
                        if (tile.connection.isLink()) {
                            tile.connection.getStructure(te.func_145831_w()).updateStructure();
                        } else {
                            tile.connection.getStructureWithoutLoading().selectMainTile();
                        }
                    }
                    tile.connection = null;
                    tile.destroy((TileList)x);
                    continue;
                }
                if (simulate) {
                    this.colorVolume += tile.getPercentVolume();
                    gained.add(ColorIngredient.getColors(tile.getPreviewTile(), tile.getPercentVolume()));
                    continue;
                }
                ArrayList<LittleBox> oldBoxes = new ArrayList<LittleBox>();
                oldBoxes.add(tile.box);
                this.addRevert(LittleTileColored.getColor(tile), te.func_174877_v(), context, oldBoxes);
                LittleTile changedTile = LittleTileColored.setColor(tile, this.color);
                if (changedTile == null) continue;
                changedTile.place((TileList)x);
                if (tile.isChildOfStructure()) {
                    changedTile.connection = tile.connection.copy(changedTile);
                    LittleStructure structure = tile.connection.getStructure(te.func_145831_w());
                    structure.remove(tile);
                    structure.add(changedTile);
                    structure.updateStructure();
                    if (!tile.connection.isLink()) {
                        structure.setMainTile(changedTile);
                    }
                }
                tile.connection = null;
                tile.destroy((TileList)x);
            }
        };
        if (simulate) {
            te.updateTilesSecretly(consumer);
        } else {
            te.updateTiles(consumer);
        }
        ColorIngredient toDrain = ColorIngredient.getColors(this.color);
        toDrain.scale(this.colorVolume);
        return gained.sub(toDrain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void action(World world, EntityPlayer player, BlockPos pos, IBlockState state, List<LittleBox> boxes, LittleGridContext context) throws LittleActionException {
        if (ColorUtils.getAlpha((int)this.color) < LittleTiles.CONFIG.getMinimumTransparency(player)) {
            throw new LittleTilesConfig.NotAllowedToPlaceColorException();
        }
        TileEntityLittleTiles tileEntity = LittleActionColorBoxes.loadTe(player, world, pos, true);
        if (tileEntity instanceof TileEntityLittleTiles) {
            TileEntityLittleTiles te;
            if (!world.field_72995_K) {
                BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, tileEntity.func_174877_v(), tileEntity.getBlockTileState(), player);
                MinecraftForge.EVENT_BUS.post((Event)event);
                if (event.isCanceled()) {
                    LittleActionColorBoxes.sendBlockResetToClient(world, (EntityPlayerMP)player, tileEntity);
                    return;
                }
            }
            if (context != (te = tileEntity).getContext()) {
                if (context.size < te.getContext().size) {
                    for (LittleBox box : boxes) {
                        box.convertTo(context, te.getContext());
                    }
                    context = te.getContext();
                } else {
                    te.convertTo(context);
                }
            }
            ArrayList entries = new ArrayList();
            ColorIngredient gained = new ColorIngredient();
            ColorIngredient toDrain = this.action(te, boxes, gained, true, context);
            LittleIngredients gainedIngredients = new LittleIngredients(gained);
            LittleIngredients drainedIngredients = new LittleIngredients(toDrain);
            LittleInventory inventory = new LittleInventory(player);
            try {
                inventory.startSimulation();
                LittleActionColorBoxes.give(player, inventory, gainedIngredients);
                LittleActionColorBoxes.take(player, inventory, drainedIngredients);
            }
            finally {
                inventory.stopSimulation();
            }
            LittleActionColorBoxes.give(player, inventory, gainedIngredients);
            LittleActionColorBoxes.take(player, inventory, drainedIngredients);
            this.action(te, boxes, gained, false, context);
            te.combineTiles();
            if (this.toVanilla || !this.doneSomething) {
                te.convertBlockToVanilla();
            }
        }
    }

    @Override
    protected boolean action(EntityPlayer player) throws LittleActionException {
        this.revertList = new HashMapList();
        return super.action(player);
    }

    @Override
    public boolean canBeReverted() {
        return true;
    }

    @Override
    public LittleAction revert() {
        ArrayList<LittleActionColorBoxes> actions = new ArrayList<LittleActionColorBoxes>();
        for (Map.Entry entry : this.revertList.entrySet()) {
            for (LittleBoxes boxes : (ArrayList)entry.getValue()) {
                boxes.convertToSmallest();
                actions.add(new LittleActionColorBoxes(boxes, (Integer)entry.getKey(), true));
            }
        }
        return new LittleActionCombined(actions.toArray(new LittleAction[0]));
    }

    @Override
    public LittleAction flip(EnumFacing.Axis axis, LittleAbsoluteBox box) {
        LittleActionColorBoxes action = new LittleActionColorBoxes();
        action.color = this.color;
        action.toVanilla = this.toVanilla;
        return this.assignFlip(action, axis, box);
    }

    public static class LittleActionColorBoxesFiltered
    extends LittleActionColorBoxes {
        public TileSelector selector;

        public LittleActionColorBoxesFiltered(LittleBoxes boxes, int color, boolean toVanilla, TileSelector selector) {
            super(boxes, color, toVanilla);
            this.selector = selector;
        }

        public LittleActionColorBoxesFiltered() {
        }

        @Override
        public void writeBytes(ByteBuf buf) {
            super.writeBytes(buf);
            LittleActionColorBoxesFiltered.writeSelector(this.selector, buf);
        }

        @Override
        public void readBytes(ByteBuf buf) {
            super.readBytes(buf);
            this.selector = LittleActionColorBoxesFiltered.readSelector(buf);
        }

        @Override
        public boolean shouldSkipTile(LittleTile tile) {
            return !this.selector.is(tile);
        }

        @Override
        public LittleAction flip(EnumFacing.Axis axis, LittleAbsoluteBox box) {
            LittleActionColorBoxesFiltered action = new LittleActionColorBoxesFiltered();
            action.selector = this.selector;
            action.color = this.color;
            action.toVanilla = this.toVanilla;
            return this.assignFlip(action, axis, box);
        }
    }
}

