/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.world;

import com.creativemd.creativecore.common.utils.mc.TickUtils;
import com.creativemd.creativecore.common.world.CreativeWorld;
import com.creativemd.littletiles.client.event.HoldLeftClick;
import com.creativemd.littletiles.client.event.InputEventHandler;
import com.creativemd.littletiles.client.event.LeftClick;
import com.creativemd.littletiles.client.event.WheelClick;
import com.creativemd.littletiles.client.render.entity.RenderAnimation;
import com.creativemd.littletiles.client.render.overlay.PreviewRenderer;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.world.LittleAnimationHandler;
import com.creativemd.littletiles.common.world.WorldAnimationHandler;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCommandBlock;
import net.minecraft.block.BlockStructure;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.crash.CrashReport;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ReportedException;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class LittleAnimationHandlerClient
extends LittleAnimationHandler {
    private static Minecraft mc = Minecraft.func_71410_x();
    public static RenderAnimation render = new RenderAnimation(mc.func_175598_ae());
    private static final Method syncCurrentPlayItemMethod = ReflectionHelper.findMethod(PlayerControllerMP.class, (String)"syncCurrentPlayItem", (String)"func_78750_j", (Class[])new Class[0]);
    private static final Field blockHitDelayField = ReflectionHelper.findField(PlayerControllerMP.class, (String[])new String[]{"blockHitDelay", "field_78781_i"});
    private static final Field leftClickCounterField = ReflectionHelper.findField(Minecraft.class, (String[])new String[]{"leftClickCounter", "field_71429_W"});
    public boolean isHittingBlock = false;
    private float curBlockDamageMP;
    public int stepSoundTickCounter;
    public World currentDestroyWorld;
    public BlockPos currentDestroyPos = new BlockPos(-1, -1, -1);
    public ItemStack currentItemHittingBlock = ItemStack.field_190927_a;
    private EntityPlayer lastPlayerRayTraceResult;
    private RayTraceResult lastRayTraceResult;
    private CreativeWorld lastWorldRayTraceResult;

    public LittleAnimationHandlerClient(World world) {
        super(world);
    }

    public static void renderTick() {
        float partialTicks = TickUtils.getPartialTickTime();
        Entity renderViewEntity = mc.func_175606_aa();
        if (renderViewEntity == null || WorldAnimationHandler.client == null || WorldAnimationHandler.client.openDoors.isEmpty()) {
            return;
        }
        double camX = renderViewEntity.field_70142_S + (renderViewEntity.field_70165_t - renderViewEntity.field_70142_S) * (double)partialTicks;
        double camY = renderViewEntity.field_70137_T + (renderViewEntity.field_70163_u - renderViewEntity.field_70137_T) * (double)partialTicks;
        double camZ = renderViewEntity.field_70136_U + (renderViewEntity.field_70161_v - renderViewEntity.field_70136_U) * (double)partialTicks;
        TileEntityRendererDispatcher.field_147554_b = camX;
        TileEntityRendererDispatcher.field_147555_c = camY;
        TileEntityRendererDispatcher.field_147552_d = camZ;
        Frustum camera = new Frustum();
        camera.func_78547_a(camX, camY, camZ);
        for (EntityAnimation door : WorldAnimationHandler.client.openDoors) {
            if (!render.shouldRender(door, (ICamera)camera, camX, camY, camZ) || door.field_70128_L) continue;
            if (door.field_70173_aa == 0) {
                door.field_70142_S = door.field_70165_t;
                door.field_70137_T = door.field_70163_u;
                door.field_70136_U = door.field_70161_v;
            }
            double d0 = door.field_70142_S + (door.field_70165_t - door.field_70142_S) * (double)partialTicks;
            double d1 = door.field_70137_T + (door.field_70163_u - door.field_70137_T) * (double)partialTicks;
            double d2 = door.field_70136_U + (door.field_70161_v - door.field_70136_U) * (double)partialTicks;
            float f = door.field_70126_B + (door.field_70177_z - door.field_70126_B) * partialTicks;
            int i = door.func_70070_b();
            if (door.func_70027_ad()) {
                i = 0xF000F0;
            }
            int j = i % 65536;
            int k = i / 65536;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            try {
                render.doRender(door, d0 - camX, d1 - camY, d2 - camZ, f, partialTicks);
            }
            catch (Throwable throwable1) {
                throw new ReportedException(CrashReport.func_85055_a((Throwable)throwable1, (String)"Rendering entity in world"));
            }
        }
    }

    public void rightClick(PlayerInteractEvent event) {
        if (event instanceof PlayerInteractEvent.RightClickBlock || event instanceof PlayerInteractEvent.RightClickEmpty || event instanceof PlayerInteractEvent.RightClickItem || event instanceof PlayerInteractEvent.EntityInteractSpecific) {
            Entity selectedEntity;
            RayTraceResult target = LittleAnimationHandlerClient.mc.field_71476_x != null && LittleAnimationHandlerClient.mc.field_71476_x.field_72313_a == RayTraceResult.Type.BLOCK ? LittleAnimationHandlerClient.mc.field_71476_x : null;
            EntityPlayer player = event.getEntityPlayer();
            float partialTicks = TickUtils.getPartialTickTime();
            Vec3d pos = player.func_174824_e(partialTicks);
            double d0 = target != null ? pos.func_72438_d(target.field_72307_f) : (player.field_71075_bZ.field_75098_d ? 5.0 : 4.5);
            Vec3d look = player.func_70676_i(partialTicks);
            look = pos.func_72441_c(look.field_72450_a * d0, look.field_72448_b * d0, look.field_72449_c * d0);
            AxisAlignedBB box = new AxisAlignedBB(pos, target != null ? target.field_72307_f : look);
            World world = player.field_70170_p;
            EntityAnimation pointedEntity = null;
            RayTraceResult result = target;
            double distance = result != null ? pos.func_72438_d(result.field_72307_f) : 0.0;
            for (EntityAnimation animation : this.findAnimations(box)) {
                RayTraceResult tempResult = LittleAnimationHandlerClient.getTarget(animation.fakeWorld, animation.origin.transformPointToFakeWorld(pos), animation.origin.transformPointToFakeWorld(look), pos, look);
                if (tempResult == null || tempResult.field_72313_a != RayTraceResult.Type.BLOCK) continue;
                double tempDistance = pos.func_72438_d(animation.origin.transformPointToWorld(tempResult.field_72307_f));
                if (result != null && !(tempDistance < distance)) continue;
                result = tempResult;
                distance = tempDistance;
                pointedEntity = animation;
            }
            Entity entity = selectedEntity = LittleAnimationHandlerClient.mc.field_71476_x != null ? LittleAnimationHandlerClient.mc.field_71476_x.field_72308_g : null;
            if (event instanceof PlayerInteractEvent.EntityInteractSpecific) {
                selectedEntity = ((PlayerInteractEvent.EntityInteractSpecific)event).getTarget();
            } else if (event instanceof PlayerInteractEvent.EntityInteract) {
                selectedEntity = ((PlayerInteractEvent.EntityInteract)event).getTarget();
            }
            if (pointedEntity == null && selectedEntity instanceof EntityAnimation) {
                pointedEntity = (EntityAnimation)selectedEntity;
            }
            if (pointedEntity != null && pointedEntity.onRightClick(player, pos, look) && event instanceof PlayerInteractEvent.RightClickBlock) {
                event.setCanceled(true);
            }
        }
    }

    public void mouseWheel(WheelClick event) {
        int slot;
        RayTraceResult target = this.getRayTraceResult(event.player, TickUtils.getPartialTickTime(), null);
        if (target == null) {
            return;
        }
        EntityPlayer player = event.player;
        CreativeWorld world = this.lastWorldRayTraceResult;
        if (InputEventHandler.onPickBlock(target, player, (World)world)) {
            return;
        }
        IBlockState state = world.func_180495_p(target.func_178782_a());
        if (state.func_177230_c().isAir(state, (IBlockAccess)world, target.func_178782_a())) {
            return;
        }
        ItemStack stack = state.func_177230_c().getPickBlock(state, target, (World)world, target.func_178782_a(), player);
        if (stack.func_190926_b()) {
            return;
        }
        if (event.player.func_184812_l_()) {
            player.field_71071_by.func_184434_a(stack);
            LittleAnimationHandlerClient.mc.field_71442_b.func_78761_a(player.func_184586_b(EnumHand.MAIN_HAND), 36 + player.field_71071_by.field_70461_c);
            event.setCanceled(true);
        }
        if ((slot = player.field_71071_by.func_184429_b(stack)) != -1) {
            if (InventoryPlayer.func_184435_e((int)slot)) {
                player.field_71071_by.field_70461_c = slot;
            } else {
                LittleAnimationHandlerClient.mc.field_71442_b.func_187100_a(slot);
            }
            event.setCanceled(true);
        }
    }

    public boolean isHittingPos(World world, BlockPos pos) {
        boolean flag;
        ItemStack itemstack = LittleAnimationHandlerClient.mc.field_71439_g.func_184614_ca();
        boolean bl = flag = this.currentItemHittingBlock.func_190926_b() && itemstack.func_190926_b();
        if (!this.currentItemHittingBlock.func_190926_b() && !itemstack.func_190926_b()) {
            flag = !ForgeHooksClient.shouldCauseBlockBreakReset((ItemStack)this.currentItemHittingBlock, (ItemStack)itemstack);
        }
        return flag && this.isHittingBlock && this.currentDestroyPos.equals((Object)pos) && this.currentDestroyWorld == world;
    }

    public void resetBlockRemoving() {
        if (this.isHittingBlock) {
            this.isHittingBlock = false;
            this.curBlockDamageMP = 0.0f;
            this.sendBlockBreakProgress(LittleAnimationHandlerClient.mc.field_71439_g.func_145782_y(), this.currentDestroyWorld, this.currentDestroyPos, -1);
            LittleAnimationHandlerClient.mc.field_71439_g.func_184821_cY();
        }
    }

    public boolean clickBlockCreative(World world, EntityPlayer player, BlockPos pos, EnumFacing facing) {
        if (!world.func_175719_a(player, pos, facing)) {
            return this.onPlayerDestroyBlock(player, world, pos);
        }
        return true;
    }

    public void sendBlockBreakProgress(int breakerId, World world, BlockPos pos, int progress) {
    }

    public void addBlockHitEffects(World world, BlockPos pos, RayTraceResult target) {
        IBlockState state = world.func_180495_p(pos);
        if (state != null && !state.func_177230_c().addHitEffects(state, world, target, LittleAnimationHandlerClient.mc.field_71452_i)) {
            LittleAnimationHandlerClient.mc.field_71452_i.func_180532_a(world instanceof CreativeWorld ? ((CreativeWorld)world).transformToRealWorld(pos) : pos, target.field_178784_b);
        }
    }

    public void holdClick(HoldLeftClick event) {
        RayTraceResult result = this.getRayTraceResult(event.player, TickUtils.getPartialTickTime(), null);
        if (result == null || !event.leftClick) {
            if (this.isHittingBlock) {
                this.resetBlockRemoving();
            }
            return;
        }
        CreativeWorld world = this.lastWorldRayTraceResult;
        EntityPlayer player = event.player;
        BlockPos pos = result.func_178782_a();
        try {
            if (leftClickCounterField.getInt(mc) <= 0 && !player.func_184587_cr() && this.onPlayerDamageBlock((World)world, player, pos, result.field_178784_b, event)) {
                this.addBlockHitEffects((World)world, pos, result);
                player.func_184609_a(EnumHand.MAIN_HAND);
                event.setLeftClickResult(false);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onPlayerDamageBlock(World world, EntityPlayer player, BlockPos pos, EnumFacing facing, HoldLeftClick event) {
        try {
            syncCurrentPlayItemMethod.invoke((Object)LittleAnimationHandlerClient.mc.field_71442_b, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
        try {
            if (blockHitDelayField.getInt(LittleAnimationHandlerClient.mc.field_71442_b) > 0) {
                blockHitDelayField.setInt(LittleAnimationHandlerClient.mc.field_71442_b, blockHitDelayField.getInt(LittleAnimationHandlerClient.mc.field_71442_b) - 1);
                event.setLeftClickResult(false);
                return false;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        if (LittleAnimationHandlerClient.mc.field_71442_b.func_178889_l().func_77145_d()) {
            if (LittleAnimationHandlerClient.mc.field_71441_e.func_175723_af().func_177746_a(world instanceof CreativeWorld ? ((CreativeWorld)world).transformToRealWorld(pos) : pos)) {
                try {
                    blockHitDelayField.setInt(LittleAnimationHandlerClient.mc.field_71442_b, 5);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
                if (!this.clickBlockCreative(world, player, pos, facing)) return false;
                return true;
            }
        }
        if (this.isHittingPos(world, pos)) {
            IBlockState iblockstate = world.func_180495_p(pos);
            Block block = iblockstate.func_177230_c();
            if (iblockstate.func_185904_a() == Material.field_151579_a) {
                return false;
            }
            this.curBlockDamageMP += iblockstate.func_185903_a(player, world, pos);
            if (this.stepSoundTickCounter % 4 == 0) {
                SoundType soundtype = block.getSoundType(iblockstate, world, pos, (Entity)LittleAnimationHandlerClient.mc.field_71439_g);
                mc.func_147118_V().func_147682_a((ISound)new PositionedSoundRecord(soundtype.func_185846_f(), SoundCategory.NEUTRAL, (soundtype.func_185843_a() + 1.0f) / 8.0f, soundtype.func_185847_b() * 0.5f, world instanceof CreativeWorld ? ((CreativeWorld)world).transformToRealWorld(pos) : pos));
            }
            ++this.stepSoundTickCounter;
            if (this.curBlockDamageMP >= 1.0f) {
                this.isHittingBlock = false;
                this.onPlayerDestroyBlock(player, world, pos);
                this.curBlockDamageMP = 0.0f;
                this.stepSoundTickCounter = 0;
            }
            this.sendBlockBreakProgress(LittleAnimationHandlerClient.mc.field_71439_g.func_145782_y(), world, pos, (int)(this.curBlockDamageMP * 10.0f) - 1);
            return true;
        }
        if (!this.clickBlock(world, pos, facing)) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean clickBlock(World world, BlockPos loc, EnumFacing face) {
        IBlockState iblockstate;
        boolean flag;
        if (LittleAnimationHandlerClient.mc.field_71442_b.func_178889_l().func_82752_c()) {
            if (LittleAnimationHandlerClient.mc.field_71442_b.func_178889_l() == GameType.SPECTATOR) {
                return false;
            }
            if (!LittleAnimationHandlerClient.mc.field_71439_g.func_175142_cm()) {
                ItemStack itemstack = LittleAnimationHandlerClient.mc.field_71439_g.func_184614_ca();
                if (itemstack.func_190926_b()) {
                    return false;
                }
                if (!itemstack.func_179544_c(LittleAnimationHandlerClient.mc.field_71441_e.func_180495_p(loc).func_177230_c())) {
                    return false;
                }
            }
        }
        if (!LittleAnimationHandlerClient.mc.field_71441_e.func_175723_af().func_177746_a(world instanceof CreativeWorld ? ((CreativeWorld)world).transformToRealWorld(loc) : loc)) {
            return false;
        }
        if (LittleAnimationHandlerClient.mc.field_71442_b.func_178889_l().func_77145_d()) {
            this.clickBlockCreative(world, (EntityPlayer)LittleAnimationHandlerClient.mc.field_71439_g, loc, face);
            try {
                blockHitDelayField.setInt(LittleAnimationHandlerClient.mc.field_71442_b, 5);
                return true;
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
                return true;
            }
        }
        if (this.isHittingBlock) {
            if (this.isHittingPos(world, loc)) return true;
        }
        boolean bl = flag = (iblockstate = LittleAnimationHandlerClient.mc.field_71441_e.func_180495_p(loc)).func_185904_a() != Material.field_151579_a;
        if (flag && this.curBlockDamageMP == 0.0f) {
            iblockstate.func_177230_c().func_180649_a((World)LittleAnimationHandlerClient.mc.field_71441_e, loc, (EntityPlayer)LittleAnimationHandlerClient.mc.field_71439_g);
        }
        if (flag) {
            if (iblockstate.func_185903_a((EntityPlayer)LittleAnimationHandlerClient.mc.field_71439_g, LittleAnimationHandlerClient.mc.field_71439_g.field_70170_p, loc) >= 1.0f) {
                this.onPlayerDestroyBlock((EntityPlayer)LittleAnimationHandlerClient.mc.field_71439_g, world, loc);
                return true;
            }
        }
        this.isHittingBlock = true;
        this.currentDestroyPos = loc;
        this.currentDestroyWorld = world;
        this.currentItemHittingBlock = LittleAnimationHandlerClient.mc.field_71439_g.func_184614_ca();
        this.curBlockDamageMP = 0.0f;
        this.stepSoundTickCounter = 0;
        this.sendBlockBreakProgress(LittleAnimationHandlerClient.mc.field_71439_g.func_145782_y(), this.currentDestroyWorld, this.currentDestroyPos, (int)(this.curBlockDamageMP * 10.0f) - 1);
        return true;
    }

    public void leftClick(LeftClick event) {
        RayTraceResult result = this.getRayTraceResult(event.player, TickUtils.getPartialTickTime(), null);
        if (result == null) {
            return;
        }
        if (this.clickBlock((World)this.lastWorldRayTraceResult, result.func_178782_a(), result.field_178784_b)) {
            event.setCanceled(true);
        }
    }

    public boolean onPlayerDestroyBlock(EntityPlayer player, World world, BlockPos pos) {
        boolean destroyed;
        ItemStack stack;
        if (LittleAnimationHandlerClient.mc.field_71442_b.func_178889_l().func_82752_c()) {
            if (LittleAnimationHandlerClient.mc.field_71442_b.func_178889_l() == GameType.SPECTATOR) {
                return false;
            }
            if (!LittleAnimationHandlerClient.mc.field_71439_g.func_175142_cm()) {
                ItemStack itemstack = LittleAnimationHandlerClient.mc.field_71439_g.func_184614_ca();
                if (itemstack.func_190926_b()) {
                    return false;
                }
                if (!itemstack.func_179544_c(world.func_180495_p(pos).func_177230_c())) {
                    return false;
                }
            }
        }
        if (!(stack = LittleAnimationHandlerClient.mc.field_71439_g.func_184614_ca()).func_190926_b() && stack.func_77973_b().onBlockStartBreak(stack, pos, (EntityPlayer)LittleAnimationHandlerClient.mc.field_71439_g)) {
            return false;
        }
        if (LittleAnimationHandlerClient.mc.field_71442_b.func_178889_l().func_77145_d() && !stack.func_190926_b() && !stack.func_77973_b().canDestroyBlockInCreative(world, pos, stack, (EntityPlayer)LittleAnimationHandlerClient.mc.field_71439_g)) {
            return false;
        }
        IBlockState iblockstate = world.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if ((block instanceof BlockCommandBlock || block instanceof BlockStructure) && !player.func_189808_dh()) {
            return false;
        }
        if (iblockstate.func_185904_a() == Material.field_151579_a) {
            return false;
        }
        world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)iblockstate));
        this.currentDestroyPos = new BlockPos(this.currentDestroyPos.func_177958_n(), -1, this.currentDestroyPos.func_177952_p());
        if (!LittleAnimationHandlerClient.mc.field_71442_b.func_178889_l().func_77145_d()) {
            ItemStack itemstack1 = player.func_184614_ca();
            ItemStack copyBeforeUse = itemstack1.func_77946_l();
            if (!itemstack1.func_190926_b()) {
                itemstack1.func_179548_a(world, iblockstate, pos, player);
                if (itemstack1.func_190926_b()) {
                    ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)copyBeforeUse, (EnumHand)EnumHand.MAIN_HAND);
                    player.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                }
            }
        }
        if (destroyed = block.removedByPlayer(iblockstate, world, pos, player, false)) {
            block.func_176206_d(world, pos, iblockstate);
            try {
                blockHitDelayField.setInt(LittleAnimationHandlerClient.mc.field_71442_b, 5);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        return destroyed;
    }

    public void tickClient(TickEvent.ClientTickEvent event) {
        if (!(event.phase != TickEvent.Phase.END || mc.func_71356_B() && mc.func_147113_T())) {
            for (EntityAnimation door : this.openDoors) {
                if (door.field_70170_p instanceof CreativeWorld) continue;
                door.onUpdateForReal();
            }
            this.openDoors.removeIf(x -> {
                if (x.field_70128_L) {
                    x.markRemoved();
                    return true;
                }
                return false;
            });
        }
    }

    public RayTraceResult getRayTraceResult(EntityPlayer player, float partialTicks, @Nullable RayTraceResult target) {
        if (this.lastPlayerRayTraceResult == player) {
            return this.lastRayTraceResult;
        }
        Vec3d pos = player.func_174824_e(partialTicks);
        double d0 = target != null ? pos.func_72438_d(target.field_72307_f) : (player.field_71075_bZ.field_75098_d ? 5.0 : 4.5);
        Vec3d look = player.func_70676_i(partialTicks);
        look = pos.func_72441_c(look.field_72450_a * d0, look.field_72448_b * d0, look.field_72449_c * d0);
        AxisAlignedBB box = new AxisAlignedBB(pos, target != null ? target.field_72307_f : look);
        World world = player.field_70170_p;
        RayTraceResult result = target;
        double distance = result != null ? pos.func_72438_d(result.field_72307_f) : 0.0;
        for (EntityAnimation animation : this.findAnimations(box)) {
            RayTraceResult tempResult = LittleAnimationHandlerClient.getTarget(animation.fakeWorld, animation.origin.transformPointToFakeWorld(pos), animation.origin.transformPointToFakeWorld(look), pos, look);
            if (tempResult == null || tempResult.field_72313_a != RayTraceResult.Type.BLOCK) continue;
            double tempDistance = pos.func_72438_d(animation.origin.transformPointToWorld(tempResult.field_72307_f));
            if (result != null && !(tempDistance < distance)) continue;
            result = tempResult;
            distance = tempDistance;
        }
        this.lastPlayerRayTraceResult = player;
        if (result == target) {
            result = null;
        }
        this.lastRayTraceResult = result;
        this.lastWorldRayTraceResult = result != null ? (CreativeWorld)result.hitInfo : null;
        return result;
    }

    public void renderLast(RenderWorldLastEvent event) {
        if (LittleAnimationHandlerClient.mc.field_71474_y.field_74319_N) {
            return;
        }
        EntityPlayerSP player = LittleAnimationHandlerClient.mc.field_71439_g;
        float partialTicks = event.getPartialTicks();
        this.lastPlayerRayTraceResult = null;
        this.lastRayTraceResult = null;
        this.lastWorldRayTraceResult = null;
        RayTraceResult result = this.getRayTraceResult((EntityPlayer)player, event.getPartialTicks(), LittleAnimationHandlerClient.mc.field_71476_x != null && LittleAnimationHandlerClient.mc.field_71476_x.field_72313_a == RayTraceResult.Type.BLOCK ? LittleAnimationHandlerClient.mc.field_71476_x : null);
        if (result == null) {
            return;
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_187441_d((float)2.0f);
        GlStateManager.func_179098_w();
        LittleAnimationHandlerClient.mc.field_71446_o.func_110577_a(PreviewRenderer.WHITE_TEXTURE);
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179091_B();
        BlockPos blockpos = result.func_178782_a();
        IBlockState iblockstate = this.lastWorldRayTraceResult.func_180495_p(blockpos);
        if (iblockstate.func_185904_a() != Material.field_151579_a && this.lastWorldRayTraceResult.func_175723_af().func_177746_a(blockpos)) {
            EntityAnimation entity = (EntityAnimation)this.lastWorldRayTraceResult.parent;
            GlStateManager.func_179094_E();
            entity.origin.setupRendering((Entity)entity, partialTicks);
            RenderGlobal.func_189697_a((AxisAlignedBB)iblockstate.func_185918_c((World)this.lastWorldRayTraceResult, blockpos).func_186662_g((double)0.002f), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public void drawBlockDamageTexture(Tessellator tessellatorIn, BufferBuilder bufferBuilderIn, Entity entityIn, float partialTicks) {
    }

    public void drawHighlight(DrawBlockHighlightEvent event) {
        if (this.getRayTraceResult(this.lastPlayerRayTraceResult, event.getPartialTicks(), event.getTarget()) != null) {
            event.setCanceled(true);
        }
    }

    public static RayTraceResult getTarget(CreativeWorld world, Vec3d pos, Vec3d look, Vec3d originalPos, Vec3d originalLook) {
        RayTraceResult tempResult = world.func_72933_a(pos, look);
        if (tempResult == null || tempResult.field_72313_a != RayTraceResult.Type.BLOCK) {
            return null;
        }
        tempResult.hitInfo = world;
        return tempResult;
    }
}

