/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.tooltip;

import com.creativemd.creativecore.common.gui.GuiRenderHelper;
import com.creativemd.creativecore.common.utils.mc.ColorUtils;
import com.creativemd.littletiles.client.gui.controls.GuiActionDisplay;
import com.creativemd.littletiles.common.util.tooltip.ActionMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;

public class CompiledActionMessage {
    public int height;
    public int width;
    public final List<ActionLine> lines = new ArrayList<ActionLine>();
    public final long timestamp;

    public CompiledActionMessage(ActionMessage message) {
        this(message.text, message.objects);
    }

    public CompiledActionMessage(String text, Object ... objects) {
        ActionLine line;
        int i;
        ArrayList<Object> lineObjects = new ArrayList<Object>();
        int tempWidth = 0;
        int first = 0;
        block0: for (i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '\n') {
                if (first == i) {
                    ++first;
                    continue;
                }
                lineObjects.add(text.substring(first, i));
                line = new ActionLine(new ArrayList<Object>(lineObjects));
                tempWidth = Math.max(tempWidth, line.width);
                this.lines.add(line);
                lineObjects.clear();
                first = i + 1;
                continue;
            }
            if (text.charAt(i) != '{') continue;
            for (int j = i + 1; j < text.length(); ++j) {
                if (Character.isDigit(text.charAt(j))) continue;
                if (text.charAt(j) != '}') continue block0;
                if (first != i) {
                    lineObjects.add(text.substring(first, i));
                }
                lineObjects.add(objects[Integer.parseInt(text.substring(i + 1, j))]);
                first = j + 1;
                i = j;
                continue block0;
            }
        }
        if (first != i) {
            lineObjects.add(text.substring(first, i));
        }
        if (!lineObjects.isEmpty()) {
            line = new ActionLine(new ArrayList<Object>(lineObjects));
            tempWidth = Math.max(tempWidth, line.width);
            this.lines.add(line);
        }
        this.width = tempWidth;
        this.height = (GuiActionDisplay.font.field_78288_b + 3) * this.lines.size();
        this.timestamp = System.currentTimeMillis();
    }

    public void render(GuiRenderHelper helper, float alpha) {
        GlStateManager.func_179094_E();
        int color = ColorUtils.RGBAToInt((int)255, (int)255, (int)255, (int)((int)(alpha * 255.0f)));
        for (int i = 0; i < this.lines.size(); ++i) {
            ActionLine line = this.lines.get(i);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(-line.width / 2), (float)0.0f, (float)0.0f);
            for (int j = 0; j < line.objects.size(); ++j) {
                Object obj = line.objects.get(j);
                if (obj.getClass() == String.class) {
                    helper.font.func_78276_b((String)obj, 0, 0, color);
                    GlStateManager.func_179109_b((float)helper.font.func_78256_a((String)obj), (float)0.0f, (float)0.0f);
                    continue;
                }
                ActionMessage.ActionMessageObjectType type = ActionMessage.getType(obj);
                type.render(obj, helper, color, alpha);
                GlStateManager.func_179109_b((float)type.width(obj, helper), (float)0.0f, (float)0.0f);
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179109_b((float)0.0f, (float)(GuiActionDisplay.font.field_78288_b + 3), (float)0.0f);
        }
        GlStateManager.func_179121_F();
    }

    public class ActionLine {
        public final List<Object> objects;
        public final int width;

        public ActionLine(List<Object> objects) {
            this.objects = objects;
            int lineWidth = 0;
            for (int i = 0; i < objects.size(); ++i) {
                Object obj = objects.get(i);
                if (obj.getClass() == String.class) {
                    lineWidth += GuiRenderHelper.instance.font.func_78256_a((String)obj);
                    continue;
                }
                lineWidth += ActionMessage.getType(obj).width(obj, GuiRenderHelper.instance);
            }
            this.width = lineWidth;
        }
    }
}

