/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.render.overlay;

import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.mc.ColorUtils;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.LittleTilesClient;
import com.creativemd.littletiles.client.render.tile.LittleRenderingCube;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.api.ILittleTile;
import com.creativemd.littletiles.common.event.LittleEventHandler;
import com.creativemd.littletiles.common.tile.place.PlacePreview;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.place.MarkMode;
import com.creativemd.littletiles.common.util.place.PlacementHelper;
import com.creativemd.littletiles.common.util.place.PlacementMode;
import com.creativemd.littletiles.common.util.place.PlacementPosition;
import com.creativemd.littletiles.common.util.place.PlacementPreview;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class PreviewRenderer {
    public static final ResourceLocation WHITE_TEXTURE = new ResourceLocation("littletiles", "textures/preview.png");
    public static Minecraft mc = Minecraft.func_71410_x();
    public static MarkMode marked = null;

    public static boolean isCentered(EntityPlayer player, ILittleTile iTile) {
        if (iTile.snapToGridByDefault()) {
            return LittleAction.isUsingSecondMode(player) && marked == null;
        }
        return LittleTiles.CONFIG.building.invertStickToGrid == LittleAction.isUsingSecondMode(player) || marked != null;
    }

    public static boolean isFixed(EntityPlayer player, ILittleTile iTile) {
        if (iTile.snapToGridByDefault()) {
            return !LittleAction.isUsingSecondMode(player) && marked == null;
        }
        return LittleTiles.CONFIG.building.invertStickToGrid != LittleAction.isUsingSecondMode(player) && marked == null;
    }

    public static void handleUndoAndRedo(EntityPlayer player) {
        while (LittleTilesClient.undo.func_151468_f()) {
            try {
                if (!LittleAction.canUseUndoOrRedo(player)) continue;
                LittleAction.undo();
            }
            catch (LittleActionException e) {
                LittleAction.handleExceptionClient(e);
            }
        }
        while (LittleTilesClient.redo.func_151468_f()) {
            try {
                if (!LittleAction.canUseUndoOrRedo(player)) continue;
                LittleAction.redo();
            }
            catch (LittleActionException e) {
                LittleAction.handleExceptionClient(e);
            }
        }
    }

    @SubscribeEvent
    public void tick(RenderWorldLastEvent event) {
        if (PreviewRenderer.mc.field_71439_g != null && PreviewRenderer.mc.field_71415_G && !PreviewRenderer.mc.field_71474_y.field_74319_N) {
            WorldClient world = PreviewRenderer.mc.field_71441_e;
            EntityPlayerSP player = PreviewRenderer.mc.field_71439_g;
            ItemStack stack = PreviewRenderer.mc.field_71439_g.func_184614_ca();
            if (!LittleAction.canPlace((EntityPlayer)player)) {
                return;
            }
            PreviewRenderer.handleUndoAndRedo((EntityPlayer)player);
            if (PlacementHelper.isLittleBlock(stack) && (marked != null || PreviewRenderer.mc.field_71476_x != null && PreviewRenderer.mc.field_71476_x.field_72313_a == RayTraceResult.Type.BLOCK && PreviewRenderer.mc.field_71476_x.field_178784_b != null)) {
                if (marked != null) {
                    marked.renderWorld(event.getPartialTicks());
                }
                ILittleTile iTile = PlacementHelper.getLittleInterface(stack);
                PlacementPosition position = marked != null ? PreviewRenderer.marked.position.copy() : PlacementHelper.getPosition((World)world, PreviewRenderer.mc.field_71476_x, iTile.getPositionContext(stack), iTile, stack);
                this.processRotateKeys(stack, position.getContext());
                iTile.tickPreview((EntityPlayer)player, stack, position, PreviewRenderer.mc.field_71476_x);
                PlacementMode mode = iTile.getPlacementMode(stack);
                if (mode.getPreviewMode() == PlacementMode.PreviewMode.PREVIEWS) {
                    GlStateManager.func_179147_l();
                    GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                    GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                    GlStateManager.func_179098_w();
                    PreviewRenderer.mc.field_71446_o.func_110577_a(WHITE_TEXTURE);
                    GlStateManager.func_179132_a((boolean)false);
                    boolean allowLowResolution = marked != null ? marked.allowLowResolution() : true;
                    PlacementPreview result = PlacementHelper.getPreviews((World)world, stack, position, PreviewRenderer.isCentered((EntityPlayer)player, iTile), PreviewRenderer.isFixed((EntityPlayer)player, iTile), allowLowResolution, marked != null, mode);
                    if (result != null) {
                        this.processMarkKey((EntityPlayer)player, iTile, stack, result);
                        double x = (double)position.getPos().func_177958_n() - TileEntityRendererDispatcher.field_147554_b;
                        double y = (double)position.getPos().func_177956_o() - TileEntityRendererDispatcher.field_147555_c;
                        double z = (double)position.getPos().func_177952_p() - TileEntityRendererDispatcher.field_147552_d;
                        List<PlacePreview> placePreviews = result.getPreviews();
                        for (int i = 0; i < placePreviews.size(); ++i) {
                            PlacePreview preview = placePreviews.get(i);
                            List<LittleRenderingCube> cubes = preview.getPreviews(result.context);
                            for (LittleRenderingCube cube : cubes) {
                                GlStateManager.func_179094_E();
                                cube.renderCubePreview(x, y, z, iTile);
                                GlStateManager.func_179121_F();
                            }
                        }
                        if (position.positingCubes != null) {
                            for (LittleRenderingCube cube : position.positingCubes) {
                                GlStateManager.func_179094_E();
                                cube.renderCubePreview(x, y, z, iTile);
                                GlStateManager.func_179121_F();
                            }
                        }
                    }
                    GlStateManager.func_179132_a((boolean)true);
                    GlStateManager.func_179098_w();
                    GlStateManager.func_179084_k();
                }
            } else {
                marked = null;
            }
        }
    }

    public void processMarkKey(EntityPlayer player, ILittleTile iTile, ItemStack stack, PlacementPreview preview) {
        while (LittleTilesClient.mark.func_151468_f()) {
            if (marked == null) {
                marked = iTile.onMark(player, stack);
            }
            if (marked == null || !marked.processPosition(player, PlacementHelper.getPosition(player.field_70170_p, PreviewRenderer.mc.field_71476_x, iTile.getPositionContext(stack), iTile, stack), preview)) continue;
            marked = null;
        }
    }

    public void processRotateKeys(ItemStack stack, LittleGridContext context) {
        boolean repeated;
        while (LittleTilesClient.flip.func_151468_f()) {
            LittleEventHandler.processFlipKey((EntityPlayer)PreviewRenderer.mc.field_71439_g, stack);
        }
        boolean bl = repeated = marked != null;
        while (LittleTilesClient.up.isPressed(repeated)) {
            if (marked != null) {
                marked.move(context, LittleAction.isUsingSecondMode((EntityPlayer)PreviewRenderer.mc.field_71439_g) ? EnumFacing.UP : EnumFacing.EAST);
                continue;
            }
            LittleEventHandler.processRotateKey((EntityPlayer)PreviewRenderer.mc.field_71439_g, Rotation.Z_CLOCKWISE, stack);
        }
        while (LittleTilesClient.down.isPressed(repeated)) {
            if (marked != null) {
                marked.move(context, LittleAction.isUsingSecondMode((EntityPlayer)PreviewRenderer.mc.field_71439_g) ? EnumFacing.DOWN : EnumFacing.WEST);
                continue;
            }
            LittleEventHandler.processRotateKey((EntityPlayer)PreviewRenderer.mc.field_71439_g, Rotation.Z_COUNTER_CLOCKWISE, stack);
        }
        while (LittleTilesClient.right.isPressed(repeated)) {
            if (marked != null) {
                marked.move(context, EnumFacing.SOUTH);
                continue;
            }
            LittleEventHandler.processRotateKey((EntityPlayer)PreviewRenderer.mc.field_71439_g, Rotation.Y_COUNTER_CLOCKWISE, stack);
        }
        while (LittleTilesClient.left.isPressed(repeated)) {
            if (marked != null) {
                marked.move(context, EnumFacing.NORTH);
                continue;
            }
            LittleEventHandler.processRotateKey((EntityPlayer)PreviewRenderer.mc.field_71439_g, Rotation.Y_CLOCKWISE, stack);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void drawHighlight(DrawBlockHighlightEvent event) {
        EntityPlayer player = event.getPlayer();
        World world = player.field_70170_p;
        ItemStack stack = player.func_184614_ca();
        if (!LittleAction.canPlace(player)) {
            return;
        }
        if ((event.getTarget().field_72313_a == RayTraceResult.Type.BLOCK || marked != null) && PlacementHelper.isLittleBlock(stack)) {
            ILittleTile iTile;
            PlacementMode mode;
            if (marked != null) {
                marked.renderBlockHighlight(player, event.getPartialTicks());
            }
            if ((mode = (iTile = PlacementHelper.getLittleInterface(stack)).getPlacementMode(stack)).getPreviewMode() == PlacementMode.PreviewMode.LINES) {
                BlockPos pos = event.getTarget().func_178782_a();
                IBlockState state = world.func_180495_p(pos);
                PlacementPosition position = marked != null ? PreviewRenderer.marked.position.copy() : PlacementHelper.getPosition(world, PreviewRenderer.mc.field_71476_x, iTile.getPositionContext(stack), iTile, stack);
                boolean allowLowResolution = marked != null ? marked.allowLowResolution() : true;
                PlacementPreview result = PlacementHelper.getPreviews(world, stack, position, PreviewRenderer.isCentered(player, iTile), PreviewRenderer.isFixed(player, iTile), allowLowResolution, marked != null, mode);
                if (result != null) {
                    this.processMarkKey(player, iTile, stack, result);
                    double d0 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.getPartialTicks();
                    double d1 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.getPartialTicks();
                    double d2 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.getPartialTicks();
                    GlStateManager.func_179147_l();
                    GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                    GlStateManager.func_187441_d((float)2.0f);
                    GlStateManager.func_179098_w();
                    PreviewRenderer.mc.field_71446_o.func_110577_a(WHITE_TEXTURE);
                    GlStateManager.func_179132_a((boolean)false);
                    double x = position.getPos().func_177958_n();
                    double y = position.getPos().func_177956_o();
                    double z = position.getPos().func_177952_p();
                    d0 -= x;
                    d1 -= y;
                    d2 -= z;
                    List<PlacePreview> placePreviews = result.getPreviews();
                    for (int i = 0; i < placePreviews.size(); ++i) {
                        PlacePreview preview = placePreviews.get(i);
                        List<LittleRenderingCube> cubes = preview.getPreviews(result.context);
                        for (LittleRenderingCube cube : cubes) {
                            float red;
                            float green;
                            float blue;
                            Vec3d color = ColorUtils.IntToVec((int)cube.color);
                            if (color.field_72450_a == 1.0 && color.field_72448_b == 1.0 && color.field_72449_c == 1.0) {
                                blue = 0.0f;
                                green = 0.0f;
                                red = 0.0f;
                            } else {
                                red = (float)color.field_72450_a;
                                green = (float)color.field_72448_b;
                                blue = (float)color.field_72449_c;
                            }
                            cube.renderCubeLines(-d0, -d1, -d2, red, green, blue, 0.4f);
                        }
                    }
                    if (position.positingCubes != null) {
                        for (LittleRenderingCube cube : position.positingCubes) {
                            float red;
                            float green;
                            float blue;
                            Vec3d color = ColorUtils.IntToVec((int)cube.color);
                            if (color.field_72450_a == 1.0 && color.field_72448_b == 1.0 && color.field_72449_c == 1.0) {
                                blue = 0.0f;
                                green = 0.0f;
                                red = 0.0f;
                            } else {
                                red = (float)color.field_72450_a;
                                green = (float)color.field_72448_b;
                                blue = (float)color.field_72449_c;
                            }
                            cube.renderCubeLines(-d0, -d1, -d2, red, green, blue, 0.4f);
                        }
                    }
                    GlStateManager.func_179132_a((boolean)true);
                    GlStateManager.func_179098_w();
                    GlStateManager.func_179084_k();
                    event.setCanceled(true);
                }
            }
        }
    }
}

