/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.render.cache;

import com.creativemd.creativecore.client.mods.optifine.OptifineHelper;
import com.creativemd.creativecore.client.rendering.RenderCubeObject;
import com.creativemd.creativecore.client.rendering.model.CreativeBakedModel;
import com.creativemd.creativecore.client.rendering.model.CreativeModelPipeline;
import com.creativemd.creativecore.common.utils.type.SingletonList;
import com.creativemd.creativecore.common.world.IBlockAccessFake;
import com.creativemd.creativecore.common.world.IOrientatedWorld;
import com.creativemd.creativecore.common.world.SubWorld;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.api.IFakeRenderingBlock;
import com.creativemd.littletiles.client.render.cache.BlockLayerRenderBuffer;
import com.creativemd.littletiles.client.render.cache.RenderCubeLayerCache;
import com.creativemd.littletiles.client.render.entity.LittleRenderChunk;
import com.creativemd.littletiles.client.render.overlay.LittleTilesProfilerOverlay;
import com.creativemd.littletiles.client.render.tile.LittleRenderingCube;
import com.creativemd.littletiles.client.render.world.LittleChunkDispatcher;
import com.creativemd.littletiles.client.render.world.RenderUtils;
import com.creativemd.littletiles.common.block.BlockTile;
import com.creativemd.littletiles.common.event.LittleEventHandler;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.chunk.ChunkCompileTaskGenerator;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.optifine.shaders.SVertexBuilder;
import org.apache.commons.lang3.ArrayUtils;

@SideOnly(value=Side.CLIENT)
public class RenderingThread
extends Thread {
    private static final String[] fakeWorldMods = new String[]{"chisel"};
    public static List<RenderingThread> threads;
    private static int threadIndex;
    public static HashMap<Object, AtomicInteger> chunks;
    public static Minecraft mc;
    public ConcurrentLinkedQueue<RenderingData> updateCoords = new ConcurrentLinkedQueue();
    final int index;
    private final SingletonList<BakedQuad> bakedQuadWrapper = new SingletonList(null);
    private final IBlockAccessFake fakeAccess = new IBlockAccessFake();
    public boolean active = true;
    private static final Field compileTaskField;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized RenderingThread getNextThread() {
        List<RenderingThread> list = threads;
        synchronized (list) {
            RenderingThread thread = threads.get(threadIndex);
            if (thread == null) {
                thread = new RenderingThread(threadIndex);
                threads.set(threadIndex, thread);
            }
            if (++threadIndex >= threads.size()) {
                threadIndex = 0;
            }
            return thread;
        }
    }

    public static void initThreads(int count) {
        if (count <= 0) {
            throw new IllegalArgumentException("count has to be at least equal or greater than one");
        }
        if (threads != null) {
            for (RenderingThread thread : threads) {
                if (thread == null) continue;
                thread.interrupt();
            }
            for (RenderingThread thread : threads) {
                while (thread != null && thread.updateCoords.size() > 0) {
                    thread.updateCoords.poll().te.resetRenderingState();
                }
            }
        }
        threadIndex = 0;
        threads = new ArrayList<RenderingThread>();
        for (int i = 0; i < count; ++i) {
            threads.add(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCoordToUpdate(TileEntityLittleTiles te) {
        Object chunk;
        RenderingThread renderer = RenderingThread.getNextThread();
        if (te.func_145831_w() instanceof IOrientatedWorld) {
            chunk = RenderUtils.getRenderChunk((IOrientatedWorld)te.func_145831_w(), te.func_174877_v());
        } else {
            chunk = te.lastRenderedChunk;
            if (chunk == null) {
                chunk = te.lastRenderedChunk = RenderUtils.getRenderChunk(RenderUtils.getViewFrustum(), te.func_174877_v());
            }
        }
        if (chunk == null) {
            System.out.println("Invalid tileentity with no rendering chunk! pos: " + te.func_174877_v() + ", world: " + te.func_145831_w());
            return;
        }
        if (te.isEmpty()) {
            RenderingThread.setRendered(te, chunk, te.func_145831_w() instanceof IOrientatedWorld, te.buffer != null && te.buffer.isEmpty() ? te.buffer : new BlockLayerRenderBuffer(), false);
            return;
        }
        HashMap<Object, AtomicInteger> hashMap = chunks;
        synchronized (hashMap) {
            AtomicInteger count = chunks.get(chunk);
            if (count == null) {
                count = new AtomicInteger(0);
                chunks.put(chunk, count);
            }
            count.getAndIncrement();
        }
        renderer.updateCoords.add(new RenderingData(te, chunk));
    }

    public RenderingThread(int index) {
        this.index = index;
        this.start();
    }

    public int getThreadIndex() {
        return this.index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (this.active) {
                WorldClient world = RenderingThread.mc.field_71441_e;
                if (world != null && !this.updateCoords.isEmpty()) {
                    block48: {
                        RenderingData data = this.updateCoords.poll();
                        try {
                            List<LittleRenderingCube> cubes;
                            if (data.te.func_145837_r()) {
                                throw new InvalidTileEntityException(data.te.func_174877_v() + "");
                            }
                            AtomicBoolean atomicBoolean = data.te.inRenderingQueue;
                            synchronized (atomicBoolean) {
                                data.te.buildingCache = true;
                            }
                            BlockPos pos = data.te.func_174877_v();
                            RenderCubeLayerCache cubeCache = data.te.getCubeCache();
                            if (data.te.func_145831_w() == null || !data.te.hasLoaded()) {
                                throw new RenderingException("Tileentity is not loaded yet");
                            }
                            for (BlockRenderLayer layer : BlockRenderLayer.values()) {
                                cubeCache.setCubesByLayer(BlockTile.getRenderingCubes(data.state, (TileEntity)data.te, null, layer), layer);
                                cubes = cubeCache.getCubesByLayer(layer);
                                for (int j = 0; j < cubes.size(); ++j) {
                                    RenderCubeObject cube = cubes.get(j);
                                    if (!cube.doesNeedQuadUpdate) continue;
                                    if (ArrayUtils.contains((Object[])fakeWorldMods, (Object)cube.block.getRegistryName().func_110624_b())) {
                                        this.fakeAccess.set((IBlockAccess)data.te.func_145831_w(), pos, cube.getBlockState());
                                        world = this.fakeAccess;
                                    } else {
                                        world = data.te.func_145831_w();
                                    }
                                    IBlockState modelState = cube.getBlockState().func_185899_b((IBlockAccess)world, pos);
                                    IBakedModel blockModel = OptifineHelper.getRenderModel((IBakedModel)mc.func_175602_ab().func_184389_a(modelState), (IBlockAccess)world, (IBlockState)modelState, (BlockPos)pos);
                                    modelState = cube.getModelState(modelState, (IBlockAccess)world, pos);
                                    BlockPos offset = cube.getOffset();
                                    for (int h = 0; h < EnumFacing.field_82609_l.length; ++h) {
                                        EnumFacing facing = EnumFacing.field_82609_l[h];
                                        if (cube.shouldSideBeRendered(facing)) {
                                            if (cube.getQuad(facing) != null) continue;
                                            cube.setQuad(facing, CreativeBakedModel.getBakedQuad((IBlockAccess)world, (RenderCubeObject)cube, (BlockPos)pos, (BlockPos)offset, (IBlockState)modelState, (IBakedModel)blockModel, (BlockRenderLayer)layer, (EnumFacing)facing, (long)MathHelper.func_180186_a((Vec3i)pos), (boolean)false));
                                            continue;
                                        }
                                        cube.setQuad(facing, null);
                                    }
                                    cube.doesNeedQuadUpdate = false;
                                }
                            }
                            cubeCache.sortCache();
                            this.fakeAccess.set(null, null, null);
                            if (data.te.func_145837_r()) {
                                throw new InvalidTileEntityException(data.te.func_174877_v() + "");
                            }
                            world = RenderingThread.mc.field_71441_e;
                            BlockLayerRenderBuffer layerBuffer = new BlockLayerRenderBuffer();
                            if (!layerBuffer.isDrawing()) {
                                data.te.renderIndex = LittleChunkDispatcher.currentRenderIndex;
                                try {
                                    layerBuffer.setDrawing();
                                    World renderWorld = data.te.func_145831_w();
                                    if (renderWorld instanceof SubWorld && !((SubWorld)renderWorld).shouldRender) {
                                        renderWorld = ((SubWorld)renderWorld).getRealWorld();
                                    }
                                    for (int i = 0; i < BlockRenderLayer.values().length; ++i) {
                                        BlockRenderLayer layer;
                                        layer = BlockRenderLayer.values()[i];
                                        ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
                                        cubes = cubeCache.getCubesByLayer(layer);
                                        BufferBuilder buffer = null;
                                        if (cubes != null && cubes.size() > 0) {
                                            buffer = layerBuffer.createVertexBuffer(cubes);
                                        }
                                        if (buffer == null) continue;
                                        buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
                                        if (FMLClientHandler.instance().hasOptifine() && OptifineHelper.isRenderRegions() && !data.subWorld) {
                                            int bits = 8;
                                            RenderChunk chunk = (RenderChunk)data.chunk;
                                            int dx = chunk.func_178568_j().func_177958_n() >> bits << bits;
                                            int dy = chunk.func_178568_j().func_177956_o() >> bits << bits;
                                            int dz = chunk.func_178568_j().func_177952_p() >> bits << bits;
                                            dx = OptifineHelper.getRenderChunkRegionX((RenderChunk)chunk);
                                            dz = OptifineHelper.getRenderChunkRegionZ((RenderChunk)chunk);
                                            buffer.func_178969_c((double)(-dx), (double)(-dy), (double)(-dz));
                                        } else {
                                            int chunkX = MathHelper.func_76137_a((int)pos.func_177958_n(), (int)16);
                                            int chunkY = MathHelper.func_76137_a((int)pos.func_177956_o(), (int)16);
                                            int chunkZ = MathHelper.func_76137_a((int)pos.func_177952_p(), (int)16);
                                            buffer.func_178969_c((double)(-chunkX * 16), (double)(-chunkY * 16), (double)(-chunkZ * 16));
                                        }
                                        boolean smooth = Minecraft.func_71379_u() && data.state.getLightValue((IBlockAccess)renderWorld, pos) == 0;
                                        BitSet bitset = null;
                                        float[] afloat = null;
                                        Object ambientFace = null;
                                        if (FMLClientHandler.instance().hasOptifine()) {
                                            ambientFace = OptifineHelper.getEnv((BufferBuilder)buffer, (IBlockAccess)renderWorld, (IBlockState)data.state, (BlockPos)pos);
                                        } else if (smooth) {
                                            bitset = new BitSet(3);
                                            afloat = new float[EnumFacing.field_82609_l.length * 2];
                                            ambientFace = CreativeModelPipeline.createAmbientOcclusionFace();
                                        }
                                        for (int j = 0; j < cubes.size(); ++j) {
                                            RenderCubeObject cube = cubes.get(j);
                                            IBlockState state = cube.getBlockState();
                                            if (FMLClientHandler.instance().hasOptifine() && OptifineHelper.isShaders()) {
                                                if (state.func_177230_c() instanceof IFakeRenderingBlock) {
                                                    state = ((IFakeRenderingBlock)state.func_177230_c()).getFakeState(state);
                                                }
                                                SVertexBuilder.pushEntity((IBlockState)state, (BlockPos)pos, (IBlockAccess)data.te.func_145831_w(), (BufferBuilder)buffer);
                                            }
                                            for (int h = 0; h < EnumFacing.field_82609_l.length; ++h) {
                                                EnumFacing facing = EnumFacing.field_82609_l[h];
                                                Object quadObject = cube.getQuad(facing);
                                                SingletonList<BakedQuad> quads = null;
                                                if (quadObject instanceof List) {
                                                    quads = (SingletonList<BakedQuad>)quadObject;
                                                } else if (quadObject instanceof BakedQuad) {
                                                    this.bakedQuadWrapper.setElement((Object)((BakedQuad)quadObject));
                                                    quads = this.bakedQuadWrapper;
                                                }
                                                if (quads == null || quads.isEmpty()) continue;
                                                if (smooth) {
                                                    CreativeModelPipeline.renderBlockFaceSmooth((IBlockAccess)renderWorld, (IBlockState)state, (BlockPos)pos, (BufferBuilder)buffer, (BlockRenderLayer)layer, quads, (float[])afloat, (EnumFacing)facing, (BitSet)bitset, (Object)ambientFace, (RenderCubeObject)cube);
                                                    continue;
                                                }
                                                CreativeModelPipeline.renderBlockFaceFlat((IBlockAccess)renderWorld, (IBlockState)state, (BlockPos)pos, (BufferBuilder)buffer, (BlockRenderLayer)layer, quads, (EnumFacing)facing, (BitSet)bitset, (RenderCubeObject)cube, (Object)ambientFace);
                                            }
                                            this.bakedQuadWrapper.setElement(null);
                                            if (FMLClientHandler.instance().hasOptifine() && OptifineHelper.isShaders()) {
                                                SVertexBuilder.popEntity((BufferBuilder)buffer);
                                            }
                                            if (LittleTiles.CONFIG.rendering.useQuadCache) continue;
                                            cube.deleteQuadCache();
                                        }
                                        if (FMLClientHandler.instance().hasOptifine() && OptifineHelper.isShaders()) {
                                            SVertexBuilder.calcNormalChunkLayer((BufferBuilder)buffer);
                                        }
                                        buffer.func_178977_d();
                                        layerBuffer.setBufferByLayer(buffer, layer);
                                    }
                                    ForgeHooksClient.setRenderLayer(null);
                                    layerBuffer.setFinishedDrawing();
                                    if (!LittleTiles.CONFIG.rendering.useCubeCache) {
                                        cubeCache.clearCache();
                                    }
                                    if (!RenderingThread.setRendered(data.te, data.chunk, data.subWorld, layerBuffer, true)) {
                                        this.updateCoords.add(data);
                                    }
                                    break block48;
                                }
                                catch (BlockLayerRenderBuffer.RenderOverlapException e) {
                                    this.updateCoords.add(data);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    this.updateCoords.add(data);
                                    if (layerBuffer != null) {
                                        layerBuffer.setFinishedDrawing();
                                    }
                                    break block48;
                                }
                            }
                            this.updateCoords.add(data);
                        }
                        catch (InvalidTileEntityException e) {
                            RenderingThread.setRendered(data.te, data.chunk, data.subWorld, new BlockLayerRenderBuffer(), true);
                        }
                        catch (Exception e) {
                            this.updateCoords.add(data);
                        }
                        catch (OutOfMemoryError error) {
                            this.updateCoords.add(data);
                            error.printStackTrace();
                        }
                    }
                    Object var2_3 = null;
                } else if (!(world != null || this.updateCoords.isEmpty() && chunks.isEmpty())) {
                    this.updateCoords.clear();
                    chunks.clear();
                }
                if (this.updateCoords.isEmpty()) {
                    RenderingThread.sleep(1L);
                }
                if (!Thread.currentThread().isInterrupted()) continue;
                throw new InterruptedException();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setRendered(TileEntityLittleTiles te, Object chunk, boolean subWorld, BlockLayerRenderBuffer buffer, boolean inQueue) {
        AtomicBoolean atomicBoolean = te.inRenderingQueue;
        synchronized (atomicBoolean) {
            te.buffer = buffer;
            te.buildingCache = false;
            if (!(inQueue || te.func_145837_r() || !te.rebuildRenderingCache && te.renderIndex == LittleChunkDispatcher.currentRenderIndex)) {
                te.rebuildRenderingCache = false;
                te.getCubeCache().clearCache();
                return false;
            }
            te.hasNeighbourChanged = false;
            te.hasLightChanged = false;
            te.lastRenderedChunk = null;
            te.inRenderingQueue.set(false);
        }
        boolean complete = false;
        HashMap<Object, AtomicInteger> hashMap = chunks;
        synchronized (hashMap) {
            AtomicInteger count = chunks.get(chunk);
            if (inQueue && count != null) {
                count.getAndDecrement();
            }
            if (count == null || count.intValue() <= 0) {
                chunks.remove(chunk);
                complete = true;
            }
            boolean finished = true;
            for (RenderingThread thread : threads) {
                if (thread == null || thread.updateCoords.isEmpty()) continue;
                finished = false;
                break;
            }
            if (finished) {
                chunks.clear();
            }
        }
        if (subWorld) {
            ((LittleRenderChunk)chunk).addRenderData(te);
        }
        if (complete) {
            if (subWorld) {
                ++LittleTilesProfilerOverlay.ltChunksUpdates;
                ((LittleRenderChunk)chunk).markCompleted();
            } else {
                ++LittleTilesProfilerOverlay.vanillaChunksUpdates;
                RenderingThread.markRenderUpdate((RenderChunk)chunk);
            }
        }
        return true;
    }

    public static void markRenderUpdate(RenderChunk chunk) {
        try {
            chunk.func_178579_c().lock();
            ChunkCompileTaskGenerator compileTask = (ChunkCompileTaskGenerator)compileTaskField.get(chunk);
            boolean updated = false;
            if (chunk.func_178569_m() || compileTask != null && compileTask.func_178538_g() == ChunkCompileTaskGenerator.Type.REBUILD_CHUNK && compileTask.func_178546_a() != ChunkCompileTaskGenerator.Status.DONE) {
                LittleEventHandler.queueChunkUpdate(chunk);
            } else {
                chunk.func_178575_a(false);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        finally {
            chunk.func_178579_c().unlock();
        }
    }

    static {
        chunks = new HashMap();
        mc = Minecraft.func_71410_x();
        RenderingThread.initThreads(LittleTiles.CONFIG.rendering.renderingThreadCount);
        compileTaskField = ReflectionHelper.findField(RenderChunk.class, (String[])new String[]{"compileTask", "field_178599_i"});
    }

    private static class RenderingData {
        public TileEntityLittleTiles te;
        public IBlockState state;
        public Object chunk;
        public boolean subWorld;

        public RenderingData(TileEntityLittleTiles te, Object chunk) {
            this.te = te;
            this.state = te.getBlockTileState();
            this.chunk = chunk;
            this.subWorld = !(chunk instanceof RenderChunk);
        }
    }

    public static class RenderingException
    extends Exception {
        public RenderingException(String arg0) {
            super(arg0);
        }
    }

    public static class InvalidTileEntityException
    extends Exception {
        public InvalidTileEntityException(String arg0) {
            super(arg0);
        }
    }
}

