/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.crafttweaker;

import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.api.energy.ThermoelectricHandler;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.CraftTweakerHelper;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.immersiveengineering.Thermoelectric")
public class Thermoelectric {
    @ZenMethod
    public static void addTemperatureSource(IIngredient source, int temperature) {
        try {
            CraftTweakerAPI.apply((IAction)new Add(CraftTweakerHelper.toIEIngredientStack(source), temperature));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @ZenMethod
    public static void removeTemperatureSource(IIngredient source) {
        try {
            CraftTweakerAPI.apply((IAction)new Remove(CraftTweakerHelper.toIEIngredientStack(source)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class Remove
    implements IAction {
        private final IngredientStack ingredientStack;

        public Remove(IngredientStack ingredientStack) {
            this.ingredientStack = ingredientStack;
        }

        public void apply() {
            if (ThermoelectricHandler.temperatureMap.containsKey(this.ingredientStack)) {
                ThermoelectricHandler.temperatureMap.remove(this.ingredientStack);
            }
        }

        public String describe() {
            return "Removing Thermoelectric temperature value for " + (this.ingredientStack.oreName != null ? this.ingredientStack.oreName : this.ingredientStack.getExampleStack().func_82833_r());
        }
    }

    private static class Add
    implements IAction {
        private final IngredientStack ingredientStack;
        private final int temperature;

        public Add(IngredientStack ingredientStack, int temperature) {
            this.ingredientStack = ingredientStack;
            this.temperature = temperature;
        }

        public void apply() {
            ThermoelectricHandler.registerSource(this.ingredientStack, this.temperature);
        }

        public String describe() {
            return "Adding Thermoelectric temperature value for " + (this.ingredientStack.oreName != null ? this.ingredientStack.oreName : this.ingredientStack.getExampleStack().func_82833_r());
        }
    }
}

