/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.CapabilitySkyhookData;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.tool.ITool;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.items.ItemUpgradeableTool;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.SkylineHelper;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemSkyhook
extends ItemUpgradeableTool
implements ITool {
    private static final String LIMIT_SPEED = "limitSpeed";

    public ItemSkyhook() {
        super("skyhook", 1, "SKYHOOK", new String[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        if (ItemSkyhook.shouldLimitSpeed(stack)) {
            list.add(I18n.func_135052_a((String)"desc.immersiveengineering.flavour.skyhook.speedLimit", (Object[])new Object[0]));
        } else {
            list.add(I18n.func_135052_a((String)"desc.immersiveengineering.flavour.skyhook.noLimit", (Object[])new Object[0]));
        }
        list.add(I18n.func_135052_a((String)"desc.immersiveengineering.flavour.skyhook", (Object[])new Object[0]));
    }

    public static boolean shouldLimitSpeed(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, LIMIT_SPEED);
    }

    public static void setLimitSpeed(ItemStack stack, boolean doLimit) {
        ItemNBTHelper.setBoolean(stack, LIMIT_SPEED, doLimit);
    }

    public static boolean toggleSpeedLimit(ItemStack stack) {
        NBTTagCompound nbt;
        boolean wasActive = (nbt = ItemNBTHelper.getTag(stack)).func_74767_n(LIMIT_SPEED);
        nbt.func_74757_a(LIMIT_SPEED, !wasActive);
        return !wasActive;
    }

    @Override
    public void func_77663_a(ItemStack stack, World world, Entity ent, int slot, boolean inHand) {
        super.func_77663_a(stack, world, ent, slot, inHand);
        if (this.getUpgrades(stack).func_74767_n("fallBoost")) {
            float dmg = (float)Math.ceil(ent.field_70143_R / 5.0f);
            ItemNBTHelper.setFloat(stack, "fallDamageBoost", dmg);
        }
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_184811_cZ().func_185141_a((Item)this)) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (player.func_70093_af()) {
            boolean limitSpeed = ItemSkyhook.toggleSpeedLimit(stack);
            if (limitSpeed) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.immersiveengineering.info.skyhookLimited", new Object[0]), true);
            } else {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.immersiveengineering.info.skyhookUnlimited", new Object[0]), true);
            }
        } else {
            CapabilitySkyhookData.SkyhookUserData data = (CapabilitySkyhookData.SkyhookUserData)player.getCapability(CapabilitySkyhookData.SKYHOOK_USER_DATA, EnumFacing.UP);
            assert (data != null);
            if (data.hook != null && !world.field_72995_K) {
                data.dismount();
                IELogger.logger.info("Player left voluntarily");
            } else {
                data.startHolding();
                player.func_184598_c(hand);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        super.onUsingTick(stack, player, count);
        CapabilitySkyhookData.SkyhookUserData data = (CapabilitySkyhookData.SkyhookUserData)player.getCapability(CapabilitySkyhookData.SKYHOOK_USER_DATA, EnumFacing.UP);
        assert (data != null);
        if (data.getStatus() != CapabilitySkyhookData.SkyhookStatus.HOLDING_CONNECTING) {
            return;
        }
        World world = player.field_70170_p;
        TileEntity connector = null;
        ImmersiveNetHandler.Connection line = null;
        ImmersiveNetHandler.Connection con = ApiUtils.getConnectionMovedThrough(world, player);
        if (con != null) {
            connector = world.func_175625_s(con.start);
            line = con;
        }
        if (line != null && connector != null) {
            SkylineHelper.spawnHook(player, connector, line, player.func_184600_cs(), ItemSkyhook.shouldLimitSpeed(stack));
        }
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase player, int timeLeft) {
        super.func_77615_a(stack, worldIn, player, timeLeft);
        if (!worldIn.field_72995_K) {
            ((CapabilitySkyhookData.SkyhookUserData)Objects.requireNonNull(player.getCapability(CapabilitySkyhookData.SKYHOOK_USER_DATA, EnumFacing.UP))).release();
        }
    }

    public float getSkylineSpeed(ItemStack stack) {
        return 3.0f + this.getUpgrades(stack).func_74760_g("speed");
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    @Override
    public boolean canModify(ItemStack stack) {
        return true;
    }

    @Override
    public Slot[] getWorkbenchSlots(Container container, ItemStack stack) {
        IItemHandler inv = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        return new Slot[]{new IESlot.Upgrades(container, inv, 0, 102, 42, "SKYHOOK", stack, true), new IESlot.Upgrades(container, inv, 1, 102, 22, "SKYHOOK", stack, true)};
    }

    @Override
    public int getSlotCount(ItemStack stack) {
        return 2;
    }

    @Override
    public boolean isTool(ItemStack item) {
        return true;
    }
}

