/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.CapabilitySkyhookData;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.util.SkylineHelper;
import blusunrize.immersiveengineering.common.util.network.MessageSkyhookSync;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntitySkylineHook
extends Entity {
    public static final double GRAVITY = 10.0;
    private static final double MAX_SPEED = 2.5;
    private static final double LIMIT_SPEED = 0.25;
    public static final double MOVE_SPEED_HOR = 0.25;
    public static final double MOVE_SPEED_VERT = 0.1;
    private ImmersiveNetHandler.Connection connection;
    public double linePos;
    public double horizontalSpeed;
    private double angle;
    public double friction = 0.99;
    public EnumHand hand;
    private boolean limitSpeed;
    private final Set<BlockPos> ignoreCollisions = new HashSet<BlockPos>();

    public EntitySkylineHook(World world) {
        super(world);
        this.func_70105_a(0.125f, 0.125f);
    }

    public EntitySkylineHook(World world, ImmersiveNetHandler.Connection connection, double linePos, EnumHand hand, double horSpeed, boolean limitSpeed) {
        this(world);
        this.hand = hand;
        this.limitSpeed = limitSpeed;
        this.setConnectionAndPos(connection, linePos, horSpeed);
        float f1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70179_y, this.field_70159_w) * 180.0 / Math.PI) + 90.0f;
        this.field_70125_A = (float)(Math.atan2(f1, this.field_70181_x) * 180.0 / Math.PI) - 90.0f;
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
    }

    public void setConnectionAndPos(ImmersiveNetHandler.Connection c, double linePos, double speed) {
        this.linePos = linePos;
        this.horizontalSpeed = speed;
        this.connection = c;
        Vec3d pos = this.connection.getVecAt(this.linePos).func_178787_e(new Vec3d((Vec3i)this.connection.start));
        this.func_70012_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, this.field_70177_z, this.field_70125_A);
        this.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        if (!this.connection.vertical) {
            this.angle = Math.atan2(this.connection.across.field_72449_c, this.connection.across.field_72450_a);
        }
        this.ignoreCollisions.clear();
        IImmersiveConnectable iicStart = ApiUtils.toIIC(c.start, this.field_70170_p, false);
        IImmersiveConnectable iicEnd = ApiUtils.toIIC(c.end, this.field_70170_p, false);
        if (iicStart != null && iicEnd != null) {
            this.ignoreCollisions.addAll(iicStart.getIgnored(iicEnd));
            this.ignoreCollisions.addAll(iicEnd.getIgnored(iicStart));
        }
    }

    protected void func_70088_a() {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double p_70112_1_) {
        double d1 = this.func_174813_aQ().func_72320_b() * 4.0;
        return p_70112_1_ < (d1 *= 64.0) * d1;
    }

    public void func_70071_h_() {
        double inLineDirection;
        if (this.field_70173_aa == 1 && this.field_70170_p.field_72995_K) {
            ImmersiveEngineering.proxy.startSkyhookSound(this);
        }
        EntityPlayer player = null;
        List list = this.func_184188_bt();
        if (!list.isEmpty() && list.get(0) instanceof EntityPlayer) {
            player = (EntityPlayer)list.get(0);
        }
        if (this.connection == null || player == null || this.hand != null && player.func_184586_b(this.hand).func_77973_b() != IEContent.itemSkyhook) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
            return;
        }
        if (this.field_70173_aa % 5 == 0 && !this.field_70170_p.field_72995_K) {
            this.sendUpdatePacketTo(player);
        }
        boolean moved = false;
        double horSpeedToUse = this.horizontalSpeed;
        if (this.connection.vertical) {
            inLineDirection = (double)(-player.field_191988_bg) * Math.sin(Math.toRadians(player.field_70125_A)) * Math.signum(this.connection.across.field_72448_b);
        } else {
            float forward = player.field_191988_bg;
            double strafing = player.field_70702_br;
            double playerAngle = Math.toRadians(player.field_70177_z) + 1.5707963267948966;
            double angleToLine = playerAngle - this.angle;
            inLineDirection = Math.cos(angleToLine) * (double)forward + Math.sin(angleToLine) * strafing;
        }
        if (inLineDirection != 0.0) {
            double slope = this.connection.getSlopeAt(this.linePos);
            double slopeInDirection = Math.signum(inLineDirection) * slope;
            double speed = 0.1;
            double slopeFactor = 1.0;
            if (!this.connection.vertical) {
                double lambda = Math.atan(slopeInDirection) / 1.5707963267948966;
                speed = lambda * 0.1 + (1.0 - lambda) * 0.25;
                slopeFactor = 1.0 / Math.sqrt(1.0 + slope * slope);
            }
            if (slopeInDirection > -0.1) {
                this.horizontalSpeed = (3.0 * this.horizontalSpeed + inLineDirection * speed * slopeFactor) / 4.0;
                moved = true;
            }
        }
        BlockPos switchingAtPos = null;
        if (!moved) {
            double deltaVHor;
            if (this.connection.vertical) {
                deltaVHor = -10.0 * Math.signum(this.connection.across.field_72448_b);
            } else {
                double param = (this.linePos * this.connection.horizontalLength - this.connection.catOffsetX) / this.connection.catA;
                double pos = Math.exp(param);
                double neg = 1.0 / pos;
                double cosh = (pos + neg) / 2.0;
                double sinh = (pos - neg) / 2.0;
                double vSquared = this.horizontalSpeed * this.horizontalSpeed * cosh * cosh * 20.0 * 20.0;
                deltaVHor = -sinh / (cosh * cosh) * (10.0 + vSquared / (this.connection.catA * cosh));
            }
            this.horizontalSpeed += deltaVHor / 400.0;
        }
        if (this.limitSpeed) {
            double max;
            double totSpeed = this.getSpeed();
            double d = max = this.limitSpeed ? 0.25 : 2.5;
            if (totSpeed > max) {
                this.horizontalSpeed *= max / totSpeed;
            }
        }
        if (this.horizontalSpeed > 0.0) {
            double distToEnd = this.connection.horizontalLength * (1.0 - this.linePos);
            if (this.horizontalSpeed > distToEnd) {
                switchingAtPos = this.connection.end;
                horSpeedToUse = distToEnd;
            }
        } else {
            double distToStart = -this.connection.horizontalLength * this.linePos;
            if (this.horizontalSpeed < distToStart) {
                switchingAtPos = this.connection.start;
                horSpeedToUse = distToStart;
            }
        }
        this.horizontalSpeed *= this.friction;
        this.linePos += horSpeedToUse / this.connection.horizontalLength;
        Vec3d pos = this.connection.getVecAt(this.linePos);
        double posXTemp = pos.field_72450_a + (double)this.connection.start.func_177958_n();
        double posYTemp = pos.field_72448_b + (double)this.connection.start.func_177956_o();
        double posZTemp = pos.field_72449_c + (double)this.connection.start.func_177952_p();
        this.field_70159_w = posXTemp - this.field_70165_t;
        this.field_70179_y = posZTemp - this.field_70161_v;
        this.field_70181_x = posYTemp - this.field_70163_u;
        if (!this.isValidPosition(posXTemp, posYTemp, posZTemp, (EntityLivingBase)player)) {
            this.func_70106_y();
            return;
        }
        this.field_70165_t = posXTemp;
        this.field_70163_u = posYTemp;
        this.field_70161_v = posZTemp;
        super.func_70071_h_();
        float f1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70179_y, this.field_70159_w) * 180.0 / Math.PI) + 90.0f;
        this.field_70125_A = (float)(Math.atan2(f1, this.field_70181_x) * 180.0 / Math.PI) - 90.0f;
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        if (this.func_70090_H()) {
            for (int j = 0; j < 4; ++j) {
                float f3 = 0.25f;
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * (double)f3, this.field_70163_u - this.field_70181_x * (double)f3, this.field_70161_v - this.field_70179_y * (double)f3, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
            }
        }
        double dx = this.field_70165_t - this.field_70169_q;
        double dy = this.field_70163_u - this.field_70167_r;
        double dz = this.field_70161_v - this.field_70166_s;
        int distTrvl = Math.round(MathHelper.func_76133_a((double)(dx * dx + dy * dy + dz * dz)) * 100.0f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        if (switchingAtPos != null) {
            this.switchConnection(switchingAtPos, player, horSpeedToUse);
        }
    }

    private void sendUpdatePacketTo(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            ImmersiveEngineering.packetHandler.sendTo((IMessage)new MessageSkyhookSync(this), (EntityPlayerMP)player);
        }
    }

    public void switchConnection(BlockPos posForSwitch, EntityPlayer player, double lastHorSpeed) {
        Optional<Object> line = Optional.empty();
        Set<ImmersiveNetHandler.Connection> possible = ImmersiveNetHandler.INSTANCE.getConnections(this.field_70170_p, posForSwitch);
        if (possible != null) {
            Vec3d look = player.func_70040_Z();
            line = possible.stream().filter(c -> !c.hasSameConnectors(this.connection)).filter(c -> c.getSubVertices(this.field_70170_p)[0].func_72438_d(this.func_174791_d().func_178786_a((double)c.start.func_177958_n(), (double)c.start.func_177956_o(), (double)c.start.func_177952_p())) < 0.6).max(Comparator.comparingDouble(c -> {
                c.getSubVertices(this.field_70170_p);
                return c.across.func_72432_b().func_72430_b(look);
            }));
        }
        if (line.isPresent()) {
            ImmersiveNetHandler.Connection newCon = (ImmersiveNetHandler.Connection)line.get();
            newCon.getSubVertices(this.field_70170_p);
            double oldSpeedPerHor = EntitySkylineHook.getSpeedPerHor(this.connection, posForSwitch.equals((Object)this.connection.start) ? 0.0 : 1.0);
            double newSpeedPerHor = EntitySkylineHook.getSpeedPerHor(newCon, 0.0);
            double horConversionFactor = oldSpeedPerHor / newSpeedPerHor;
            this.setConnectionAndPos(newCon, Math.abs(this.horizontalSpeed - lastHorSpeed) * horConversionFactor, Math.abs(this.horizontalSpeed) * horConversionFactor);
            this.sendUpdatePacketTo(player);
        } else {
            this.func_70106_y();
        }
    }

    private static double getSpeedPerHor(ImmersiveNetHandler.Connection connection, double pos) {
        if (connection.vertical) {
            return 1.0;
        }
        double slope = connection.getSlopeAt(pos);
        return Math.sqrt(slope * slope + 1.0);
    }

    public boolean isValidPosition(double x, double y, double z, @Nonnull EntityLivingBase player) {
        double tolerance = this.connection.vertical ? 5.0 : 10.0;
        double radius = player.field_70130_N / 2.0f;
        double height = player.field_70131_O;
        double yOffset = this.func_70042_X() + player.func_70033_W();
        AxisAlignedBB playerBB = new AxisAlignedBB(x - radius, y + yOffset, z - radius, x + radius, y + yOffset + height, z + radius);
        double playerHeight = playerBB.field_72337_e - playerBB.field_72338_b;
        AxisAlignedBB feet = new AxisAlignedBB(playerBB.field_72340_a, playerBB.field_72338_b, playerBB.field_72339_c, playerBB.field_72336_d, playerBB.field_72338_b + 0.05 * playerHeight, playerBB.field_72334_f);
        List<AxisAlignedBB> boxes = SkylineHelper.getCollisionBoxes((Entity)player, playerBB, this.field_70170_p, this.ignoreCollisions);
        double totalCollisionVolume = 0.0;
        double totalCollisionArea = 0.0;
        double playerVolume = this.getVolume(playerBB);
        double playerArea = playerVolume / playerHeight;
        for (AxisAlignedBB box : boxes) {
            AxisAlignedBB intersection = box.func_191500_a(playerBB);
            if ((totalCollisionVolume += this.getVolume(intersection)) * tolerance > playerVolume) {
                return false;
            }
            if (this.connection.vertical || !box.func_72326_a(feet)) continue;
            AxisAlignedBB feetIntersect = box.func_191500_a(feet);
            if (!((totalCollisionArea += (feetIntersect.field_72336_d - feetIntersect.field_72340_a) * (feetIntersect.field_72334_f - feetIntersect.field_72339_c)) > 0.5 * playerArea)) continue;
            return false;
        }
        return true;
    }

    private double getVolume(AxisAlignedBB box) {
        return (box.field_72336_d - box.field_72340_a) * (box.field_72337_e - box.field_72338_b) * (box.field_72334_f - box.field_72339_c);
    }

    @Nullable
    public Entity func_184179_bs() {
        List list = this.func_184188_bt();
        return list.isEmpty() ? null : (Entity)list.get(0);
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public boolean func_82150_aj() {
        return true;
    }

    public boolean func_90999_ad() {
        return false;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public double func_70042_X() {
        return -2.0;
    }

    protected void func_70014_b(NBTTagCompound nbt) {
    }

    protected void func_70037_a(NBTTagCompound nbt) {
    }

    public float func_70111_Y() {
        return 0.0f;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        this.func_70106_y();
        return true;
    }

    public boolean func_184186_bw() {
        return false;
    }

    private void handleDismount(Entity passenger) {
        ItemStack held;
        passenger.func_70634_a(this.field_70165_t, this.field_70163_u + this.func_70042_X() + passenger.func_70033_W(), this.field_70161_v);
        passenger.field_70159_w = this.field_70159_w;
        passenger.field_70181_x = this.field_70181_x;
        passenger.field_70179_y = this.field_70179_y;
        if (this.field_70181_x < 0.0) {
            passenger.field_70143_R = SkylineHelper.fallDistanceFromSpeed(this.field_70181_x);
            passenger.field_70122_E = false;
        }
        if (passenger.hasCapability(CapabilitySkyhookData.SKYHOOK_USER_DATA, EnumFacing.UP)) {
            ((CapabilitySkyhookData.SkyhookUserData)Objects.requireNonNull(passenger.getCapability(CapabilitySkyhookData.SKYHOOK_USER_DATA, EnumFacing.UP))).release();
        }
        if (this.hand != null && passenger instanceof EntityPlayer && (held = ((EntityPlayer)passenger).func_184586_b(this.hand)).func_77973_b() == IEContent.itemSkyhook) {
            ((EntityPlayer)passenger).func_184811_cZ().func_185145_a((Item)IEContent.itemSkyhook, 10);
        }
    }

    protected void func_184225_p(Entity passenger) {
        super.func_184225_p(passenger);
        if (!this.field_70170_p.field_72995_K) {
            ApiUtils.addFutureServerTask(this.field_70170_p, () -> this.handleDismount(passenger));
        } else {
            ApiUtils.callFromOtherThread(arg_0 -> ((Minecraft)Minecraft.func_71410_x()).func_152344_a(arg_0), () -> this.handleDismount(passenger));
        }
    }

    public void func_70080_a(double x, double y, double z, float yaw, float pitch) {
    }

    public ImmersiveNetHandler.Connection getConnection() {
        return this.connection;
    }

    public double getSpeed() {
        if (this.connection == null) {
            return 0.0;
        }
        if (this.connection.vertical) {
            return Math.abs(this.horizontalSpeed);
        }
        double slope = this.connection.getSlopeAt(this.linePos);
        return Math.abs(this.horizontalSpeed) * Math.sqrt(1.0 + slope * slope);
    }
}

