/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import javax.annotation.Nonnull;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RecipeJerrycan
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    public boolean func_77569_a(@Nonnull InventoryCrafting inv, World world) {
        ItemStack jerrycan = ItemStack.field_190927_a;
        ItemStack container = ItemStack.field_190927_a;
        int[] slots = this.getRelevantSlots(inv);
        if (slots[0] >= 0) {
            jerrycan = inv.func_70301_a(slots[0]);
        }
        if (slots[1] >= 0) {
            container = inv.func_70301_a(slots[1]);
        }
        if (!jerrycan.func_190926_b() && !container.func_190926_b()) {
            IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)container);
            FluidStack fs = handler.drain(Integer.MAX_VALUE, false);
            return fs == null || fs.amount < handler.getTankProperties()[0].getCapacity() && fs.isFluidEqual(FluidUtil.getFluidContained((ItemStack)jerrycan));
        }
        return false;
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull InventoryCrafting inv) {
        ItemStack jerrycan = ItemStack.field_190927_a;
        ItemStack container = ItemStack.field_190927_a;
        FluidStack fs = null;
        int[] slots = this.getRelevantSlots(inv);
        if (slots[0] >= 0) {
            jerrycan = inv.func_70301_a(slots[0]);
            fs = FluidUtil.getFluidContained((ItemStack)jerrycan);
        }
        if (slots[1] >= 0) {
            container = inv.func_70301_a(slots[1]);
        }
        if (fs != null && !container.func_190926_b()) {
            ItemStack newContainer = Utils.copyStackWithAmount(container, 1);
            IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)newContainer);
            int accepted = handler.fill(fs, false);
            if (accepted > 0) {
                handler.fill(fs, true);
                newContainer = handler.getContainer();
                ItemNBTHelper.setInt(jerrycan, "jerrycanDrain", accepted);
            }
            return newContainer;
        }
        return ItemStack.field_190927_a;
    }

    private int[] getRelevantSlots(InventoryCrafting inv) {
        int[] ret = new int[]{-1, -1};
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stackInSlot = inv.func_70301_a(i);
            if (stackInSlot.func_190926_b()) continue;
            if (ret[0] < 0 && IEContent.itemJerrycan.equals(stackInSlot.func_77973_b()) && FluidUtil.getFluidContained((ItemStack)stackInSlot) != null) {
                ret[0] = i;
                continue;
            }
            if (ret[1] < 0 && FluidUtil.getFluidHandler((ItemStack)stackInSlot) != null) {
                ret[1] = i;
                continue;
            }
            ret[1] = -1;
            ret[0] = -1;
            return ret;
        }
        return ret;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= 2 && height >= 2;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        NonNullList remaining = ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)inv);
        int[] inputs = this.getRelevantSlots(inv);
        if (inputs[1] >= 0) {
            remaining.set(inputs[1], (Object)ItemStack.field_190927_a);
        }
        return remaining;
    }
}

