/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.tool;

import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ExternalHeaterHandler {
    public static int defaultFurnaceEnergyCost;
    public static int defaultFurnaceSpeedupCost;
    public static HashMap<Class<? extends TileEntity>, HeatableAdapter> adapterMap;

    public static void registerHeatableAdapter(Class<? extends TileEntity> c, HeatableAdapter adapter) {
        adapterMap.put(c, adapter);
    }

    public static HeatableAdapter getHeatableAdapter(Class<? extends TileEntity> c) {
        HeatableAdapter adapter = adapterMap.get(c);
        if (adapter == null && c != TileEntity.class && c.getSuperclass() != TileEntity.class) {
            adapter = ExternalHeaterHandler.getHeatableAdapter(c.getSuperclass());
            adapterMap.put(c, adapter);
        }
        return adapter;
    }

    static {
        adapterMap = new HashMap();
    }

    public static class DefaultFurnaceAdapter
    extends HeatableAdapter<TileEntityFurnace> {
        boolean canCook(TileEntityFurnace tileEntity) {
            ItemStack input = tileEntity.func_70301_a(0);
            if (input.func_190926_b()) {
                return false;
            }
            ItemStack output = FurnaceRecipes.func_77602_a().func_151395_a(input);
            if (output.func_190926_b()) {
                return false;
            }
            ItemStack existingOutput = tileEntity.func_70301_a(2);
            if (existingOutput.func_190926_b()) {
                return true;
            }
            if (!existingOutput.func_77969_a(output)) {
                return false;
            }
            int stackSize = existingOutput.func_190916_E() + output.func_190916_E();
            return stackSize <= tileEntity.func_70297_j_() && stackSize <= output.func_77976_d();
        }

        @Override
        public int doHeatTick(TileEntityFurnace tileEntity, int energyAvailable, boolean redstone) {
            int energyConsumed = 0;
            boolean canCook = this.canCook(tileEntity);
            if (canCook || redstone) {
                int energyToUse;
                int heatEnergyRatio;
                int heatAttempt;
                int energyToUse2;
                int heat;
                boolean burning = tileEntity.func_145950_i();
                int burnTime = tileEntity.func_174887_a_(0);
                if (burnTime < 200 && (heat = (energyToUse2 = Math.min(energyAvailable, (heatAttempt = 4) * (heatEnergyRatio = Math.max(1, defaultFurnaceEnergyCost)))) / heatEnergyRatio) > 0) {
                    tileEntity.func_174885_b(0, burnTime + heat);
                    energyConsumed += heat * heatEnergyRatio;
                    if (!burning) {
                        this.updateFurnace((TileEntity)tileEntity, tileEntity.func_174887_a_(0) > 0);
                    }
                }
                if (canCook && tileEntity.func_174887_a_(0) >= 200 && tileEntity.func_174887_a_(2) < 199 && energyAvailable - energyConsumed > (energyToUse = defaultFurnaceSpeedupCost)) {
                    energyConsumed += energyToUse;
                    tileEntity.func_174885_b(2, tileEntity.func_174887_a_(2) + 1);
                }
            }
            return energyConsumed;
        }

        public void updateFurnace(TileEntity tileEntity, boolean active) {
            Block containing = tileEntity.func_145838_q();
            if (containing == Blocks.field_150460_al) {
                BlockFurnace.func_176446_a((boolean)active, (World)tileEntity.func_145831_w(), (BlockPos)tileEntity.func_174877_v());
            }
            NBTTagCompound nbt = new NBTTagCompound();
            tileEntity.func_189515_b(nbt);
            nbt.func_74757_a("active", active);
            nbt.func_74757_a("Active", active);
            tileEntity.func_145839_a(nbt);
            IBlockState state = tileEntity.func_145831_w().func_180495_p(tileEntity.func_174877_v());
            tileEntity.func_145831_w().func_184138_a(tileEntity.func_174877_v(), state, state, 3);
        }
    }

    public static abstract class HeatableAdapter<E extends TileEntity> {
        public abstract int doHeatTick(E var1, int var2, boolean var3);
    }

    public static interface IExternalHeatable {
        public int doHeatTick(int var1, boolean var2);
    }
}

