/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.wct.sync.packets;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.helpers.IContainerCraftingPacket;
import appeng.items.storage.ItemViewCell;
import appeng.util.Platform;
import appeng.util.helpers.ItemHandlerUtil;
import appeng.util.inv.AdaptorItemHandler;
import appeng.util.inv.WrapperInvItemHandler;
import appeng.util.item.AEItemStack;
import appeng.util.prioritylist.IPartitionList;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import p455w0rd.ae2wtlib.api.ICustomWirelessTerminalItem;
import p455w0rd.ae2wtlib.api.WTApi;
import p455w0rd.ae2wtlib.api.WTGuiObject;
import p455w0rd.ae2wtlib.api.networking.INetworkInfo;
import p455w0rd.wct.container.ContainerWCT;
import p455w0rd.wct.sync.WCTPacket;

public class PacketJEIRecipe
extends WCTPacket {
    private ItemStack[][] recipe;

    public PacketJEIRecipe(ByteBuf stream) throws IOException {
        ByteArrayInputStream bytes = this.getPacketByteArray(stream);
        bytes.skip(stream.readerIndex());
        NBTTagCompound comp = CompressedStreamTools.func_74796_a((InputStream)bytes);
        if (comp != null) {
            this.recipe = new ItemStack[9][];
            for (int x = 0; x < this.recipe.length; ++x) {
                NBTTagList list = comp.func_150295_c("#" + x, 10);
                if (list.func_74745_c() <= 0) continue;
                this.recipe[x] = new ItemStack[list.func_74745_c()];
                for (int y = 0; y < list.func_74745_c(); ++y) {
                    this.recipe[x][y] = new ItemStack(list.func_150305_b(y));
                }
            }
        }
    }

    public PacketJEIRecipe(NBTTagCompound recipe) throws IOException {
        ByteBuf data = Unpooled.buffer();
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(bytes);
        data.writeInt(this.getPacketID());
        CompressedStreamTools.func_74799_a((NBTTagCompound)recipe, (OutputStream)outputStream);
        data.writeBytes(bytes.toByteArray());
        this.configureWrite(data);
    }

    private WTGuiObject<IAEItemStack> getGuiObject(ItemStack it, EntityPlayer player, World w, int x, int y, int z) {
        ICustomWirelessTerminalItem wh;
        if (it != null && (wh = (ICustomWirelessTerminalItem)AEApi.instance().registries().wireless().getWirelessTerminalHandler(it)) != null) {
            return WTApi.instance().getGUIObject(wh, it, player);
        }
        return null;
    }

    @Override
    public void serverPacketData(INetworkInfo manager, WCTPacket packet, EntityPlayer player) {
        EntityPlayerMP pmp = (EntityPlayerMP)player;
        Container con = pmp.field_71070_bA;
        if (con instanceof IContainerCraftingPacket && con instanceof ContainerWCT) {
            IContainerCraftingPacket cct = (IContainerCraftingPacket)con;
            IGridNode node = cct.getNetworkNode();
            if (node == null) {
                ItemStack wct = ((ContainerWCT)con).getWirelessTerminal();
                if (wct.func_190926_b() || !(wct.func_77973_b() instanceof ICustomWirelessTerminalItem)) {
                    return;
                }
                WTGuiObject<IAEItemStack> obj = this.getGuiObject(wct, player, player.func_130014_f_(), (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
                if (obj != null) {
                    node = obj.getActionableNode(((ICustomWirelessTerminalItem)wct.func_77973_b()).hasInfiniteRange(wct));
                }
            }
            if (node != null) {
                IGrid grid = node.getGrid();
                if (grid == null) {
                    return;
                }
                IStorageGrid inv = (IStorageGrid)grid.getCache(IStorageGrid.class);
                IEnergyGrid energy = (IEnergyGrid)grid.getCache(IEnergyGrid.class);
                ISecurityGrid security = (ISecurityGrid)grid.getCache(ISecurityGrid.class);
                ICraftingGrid crafting = (ICraftingGrid)grid.getCache(ICraftingGrid.class);
                IItemHandler craftMatrix = cct.getInventoryByName("crafting");
                IItemHandler playerInventory = cct.getInventoryByName("player");
                if (inv != null && this.recipe != null && security != null) {
                    IMEMonitor storage = inv.getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
                    IPartitionList filter = ItemViewCell.createFilter((ItemStack[])cct.getViewCells());
                    for (int x = 0; x < craftMatrix.getSlots(); ++x) {
                        Object out;
                        ItemStack newItem;
                        ItemStack currentItem = craftMatrix.getStackInSlot(x);
                        if (!currentItem.func_190926_b() && (newItem = this.canUseInSlot(x, currentItem)) != currentItem && security.hasPermission(player, SecurityPermissions.INJECT)) {
                            AEItemStack in = AEItemStack.fromItemStack((ItemStack)currentItem);
                            out = cct.useRealItems() ? (IAEItemStack)Platform.poweredInsert((IEnergySource)energy, (IMEInventory)storage, (IAEStack)in, (IActionSource)cct.getActionSource()) : null;
                            currentItem = out != null ? out.createItemStack() : ItemStack.field_190927_a;
                        }
                        if (currentItem.func_190926_b() && this.recipe[x] != null) {
                            for (int y = 0; y < this.recipe[x].length && currentItem.func_190926_b(); ++y) {
                                AEItemStack request = AEItemStack.fromItemStack((ItemStack)this.recipe[x][y]);
                                if (request == null) continue;
                                if ((filter == null || filter.isListed((IAEStack)request)) && security.hasPermission(player, SecurityPermissions.EXTRACT)) {
                                    request.setStackSize(1L);
                                    out = cct.useRealItems() ? (IAEItemStack)Platform.poweredExtraction((IEnergySource)energy, (IMEInventory)storage, (IAEStack)request, (IActionSource)cct.getActionSource()) : (!crafting.getCraftingFor((IAEItemStack)request, null, 0, null).isEmpty() ? request : (IAEItemStack)storage.extractItems((IAEStack)request, Actionable.SIMULATE, cct.getActionSource()));
                                    if (out != null) {
                                        currentItem = out.createItemStack();
                                    }
                                }
                                if (!currentItem.func_190926_b()) continue;
                                AdaptorItemHandler ad = new AdaptorItemHandler(playerInventory);
                                currentItem = cct.useRealItems() ? ad.removeItems(1, this.recipe[x][y], null) : ad.simulateRemove(1, this.recipe[x][y], null);
                            }
                        }
                        ItemHandlerUtil.setStackInSlot((IItemHandler)craftMatrix, (int)x, (ItemStack)currentItem);
                    }
                    con.func_75130_a((IInventory)new WrapperInvItemHandler(craftMatrix));
                }
            }
        }
    }

    @Nonnull
    private ItemStack canUseInSlot(int slot, ItemStack is) {
        if (this.recipe[slot] != null) {
            for (ItemStack option : this.recipe[slot]) {
                if (!is.func_77969_a(option)) continue;
                return is;
            }
        }
        return ItemStack.field_190927_a;
    }
}

