/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.wct.items;

import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.util.IConfigManager;
import appeng.util.Platform;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import p455w0rd.ae2wtlib.api.ICustomWirelessTerminalItem;
import p455w0rd.ae2wtlib.api.item.ItemWT;
import p455w0rd.wct.api.IWirelessCraftingTerminalItem;
import p455w0rd.wct.api.WCTApi;
import p455w0rd.wct.init.ModKeybindings;
import p455w0rd.wct.items.ItemMagnet;

public class ItemWCT
extends ItemWT
implements IWirelessCraftingTerminalItem {
    public ItemWCT() {
        this(new ResourceLocation("wct", "wct"));
    }

    protected ItemWCT(ResourceLocation registryName) {
        super(registryName);
    }

    public IConfigManager getConfigManager(ItemStack target) {
        IConfigManager out = super.getConfigManager(target);
        out.registerSetting(Settings.SORT_BY, (Enum)SortOrder.NAME);
        out.registerSetting(Settings.VIEW_MODE, (Enum)ViewItems.ALL);
        out.registerSetting(Settings.SORT_DIRECTION, (Enum)SortDir.ASCENDING);
        out.readFromNBT(Platform.openNbtData((ItemStack)target).func_74737_b());
        return out;
    }

    public void openGui(EntityPlayer player, boolean isBauble, int playerSlot) {
        WCTApi.instance().openWCTGui(player, isBauble, playerSlot);
    }

    @SideOnly(value=Side.CLIENT)
    public void addCheckedInformation(ItemStack is, World world, List<String> list, ITooltipFlag advancedTooltips) {
        if (this.hasValidGuiObject(is)) {
            super.addCheckedInformation(is, world, list, advancedTooltips);
            this.addTooltipMagnetInfo(is, list);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void addTooltipMagnetInfo(ItemStack wirelessTerminal, List<String> tooltip) {
        boolean isMagnetInstalled = ItemMagnet.isMagnetInstalled(wirelessTerminal);
        String magnetStatus = (isMagnetInstalled ? TextFormatting.GREEN + "" : TextFormatting.RED + "" + I18n.func_135052_a((String)"tooltip.not.desc", (Object[])new Object[0])) + " " + I18n.func_135052_a((String)"tooltip.installed.desc", (Object[])new Object[0]);
        if (isMagnetInstalled) {
            String magnetActive = TextFormatting.GREEN + I18n.func_135052_a((String)"tooltip.active.desc", (Object[])new Object[0]);
            String magnetInactive = TextFormatting.GRAY + I18n.func_135052_a((String)"tooltip.inactive.desc", (Object[])new Object[0]);
            ItemMagnet.MagnetFunctionMode magnetMode = ItemMagnet.getMagnetFunctionMode(ItemMagnet.getMagnetFromWCT(wirelessTerminal));
            boolean isActive = magnetMode.ordinal() != 0;
            tooltip.add(I18n.func_135052_a((String)"item.wct:magnet_card.name", (Object[])new Object[0]) + ": " + magnetStatus + TextFormatting.GRAY + " / " + (isActive ? magnetActive : magnetInactive));
            if (isActive && GuiScreen.func_146272_n()) {
                String magnetModeMsg = magnetMode.getMessage().split("-")[1];
                tooltip.add(" - " + TextFormatting.ITALIC + magnetModeMsg);
                tooltip.add("");
            }
            if (GuiScreen.func_146272_n()) {
                tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"tooltip.magnet_mode_keybind.desc", (Object[])new Object[0]) + ": " + TextFormatting.RESET + ModKeybindings.cycleMagnetMode.getDisplayName());
                tooltip.add("");
            }
        } else {
            tooltip.add(I18n.func_135052_a((String)"item.wct:magnet_card.name", (Object[])new Object[0]) + ": " + magnetStatus);
        }
    }

    public void func_77663_a(ItemStack wirelessTerminal, World w, Entity e, int i, boolean f) {
        super.func_77663_a(wirelessTerminal, w, e, i, f);
        if (!(wirelessTerminal.func_77973_b() instanceof ICustomWirelessTerminalItem)) {
            return;
        }
        ItemMagnet.isMagnetInstalled(wirelessTerminal);
    }

    public ResourceLocation getMenuIcon() {
        return new ResourceLocation("wct", "textures/items/wct.png");
    }

    public int getColor() {
        return -4709603;
    }
}

