/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.screenmodules;

import java.util.List;
import mcjty.lib.crafting.INBTPreservingIngredient;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.BlockTools;
import mcjty.lib.varia.Logging;
import mcjty.rftools.api.screens.IModuleGuiBuilder;
import mcjty.rftools.api.screens.IModuleProvider;
import mcjty.rftools.blocks.screens.ScreenConfiguration;
import mcjty.rftools.blocks.screens.modules.StorageControlScreenModule;
import mcjty.rftools.blocks.screens.modulesclient.StorageControlClientScreenModule;
import mcjty.rftools.blocks.storagemonitor.StorageScannerTileEntity;
import mcjty.rftools.items.GenericRFToolsItem;
import mcjty.rftools.varia.RFToolsTools;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class StorageControlModuleItem
extends GenericRFToolsItem
implements IModuleProvider,
INBTPreservingIngredient {
    public StorageControlModuleItem() {
        super("storage_control_module");
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, World player, List<String> list, ITooltipFlag advanced) {
        super.func_77624_a(itemStack, player, list, advanced);
        list.add(TextFormatting.GREEN + "Uses " + ScreenConfiguration.STORAGE_CONTROL_RFPERTICK.get() + " RF/tick");
        boolean hasTarget = false;
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            hasTarget = StorageControlModuleItem.addModuleInformation(list, itemStack);
        }
        if (!hasTarget) {
            list.add(TextFormatting.YELLOW + "Sneak right-click on a storage scanner to set the");
            list.add(TextFormatting.YELLOW + "target for this storage module");
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(TextFormatting.WHITE + "This screen module allows you to monitor 9 different");
            list.add(TextFormatting.WHITE + "items through a storage scanner.");
            list.add(TextFormatting.WHITE + "This module can also be combined with a tablet");
            list.add(TextFormatting.WHITE + "for remote access to a storage scanner controlled");
            list.add(TextFormatting.WHITE + "system");
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    public static boolean addModuleInformation(List<String> list, ItemStack stack) {
        if (!stack.func_77942_o()) {
            return false;
        }
        list.add(TextFormatting.YELLOW + "Label: " + stack.func_77978_p().func_74779_i("text"));
        if (RFToolsTools.hasModuleTarget(stack)) {
            BlockPos pos = RFToolsTools.getPositionFromModule(stack);
            String monitorname = stack.func_77978_p().func_74779_i("monitorname");
            list.add(TextFormatting.YELLOW + "Monitoring: " + monitorname + " (at " + BlockPosTools.toString((BlockPos)pos) + ")");
            return true;
        }
        return false;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof StorageScannerTileEntity) {
            IBlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            String name = "<invalid>";
            if (block != null && !block.isAir(state, (IBlockAccess)world, pos)) {
                name = BlockTools.getReadableName((World)world, (BlockPos)pos);
            }
            RFToolsTools.setPositionInModule(stack, world.field_73011_w.getDimension(), pos, name);
            if (world.field_72995_K) {
                Logging.message((EntityPlayer)player, (String)("Storage module is set to block '" + name + "'"));
            }
        } else {
            RFToolsTools.clearPositionInModule(stack);
            if (world.field_72995_K) {
                Logging.message((EntityPlayer)player, (String)"Storage module is cleared");
            }
        }
        return EnumActionResult.SUCCESS;
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }

    public Class<StorageControlScreenModule> getServerScreenModule() {
        return StorageControlScreenModule.class;
    }

    public Class<StorageControlClientScreenModule> getClientScreenModule() {
        return StorageControlClientScreenModule.class;
    }

    @Override
    public String getName() {
        return "Stor";
    }

    @Override
    public void createGui(IModuleGuiBuilder guiBuilder) {
        guiBuilder.ghostStack("stack0").ghostStack("stack1").ghostStack("stack2").nl().ghostStack("stack3").ghostStack("stack4").ghostStack("stack5").nl().ghostStack("stack6").ghostStack("stack7").ghostStack("stack8").nl().toggle("starred", "Starred", "If enabled only count items", "in 'starred' inventories", "(mark inventories in storage scanner)").toggle("oredict", "Ore Dict", "If enabled use ore dictionary", "to match items").nl().block("monitor").nl();
    }
}

