/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens.network;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.function.Supplier;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.thirteen.Context;
import mcjty.lib.varia.Logging;
import mcjty.rftools.blocks.screens.ScreenBlock;
import mcjty.rftools.blocks.screens.ScreenTileEntity;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketModuleUpdate
implements IMessage {
    private BlockPos pos;
    private int slotIndex;
    private NBTTagCompound tagCompound;

    public void fromBytes(ByteBuf buf) {
        this.pos = NetworkTools.readPos((ByteBuf)buf);
        this.slotIndex = buf.readInt();
        PacketBuffer buffer = new PacketBuffer(buf);
        try {
            this.tagCompound = buffer.func_150793_b();
        }
        catch (IOException e) {
            Logging.logError((String)"Error updating module", (Throwable)e);
        }
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.pos);
        buf.writeInt(this.slotIndex);
        PacketBuffer buffer = new PacketBuffer(buf);
        buffer.func_150786_a(this.tagCompound);
    }

    public PacketModuleUpdate() {
    }

    public PacketModuleUpdate(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketModuleUpdate(BlockPos pos, int slotIndex, NBTTagCompound tagCompound) {
        this.pos = pos;
        this.slotIndex = slotIndex;
        this.tagCompound = tagCompound;
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            EntityPlayerMP player = ctx.getSender();
            World world = player.func_130014_f_();
            Block block = world.func_180495_p(this.pos).func_177230_c();
            double dist = player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e() + 3.0;
            if (player.func_70092_e((double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5) >= dist * dist) {
                return;
            }
            if (!(block instanceof ScreenBlock)) {
                Logging.logError((String)"PacketModuleUpdate: Block is not a ScreenBlock!");
                return;
            }
            TileEntity te = world.func_175625_s(this.pos);
            if (((ScreenBlock)block).checkAccess(world, (EntityPlayer)player, te)) {
                return;
            }
            if (!(te instanceof ScreenTileEntity)) {
                Logging.logError((String)"PacketModuleUpdate: TileEntity is not a SimpleScreenTileEntity!");
                return;
            }
            ((ScreenTileEntity)te).updateModuleData(this.slotIndex, this.tagCompound);
        });
        ctx.setPacketHandled(true);
    }
}

