/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.math;

import com.feed_the_beast.ftblib.FTBLib;
import com.feed_the_beast.ftblib.FTBLibConfig;
import com.feed_the_beast.ftblib.lib.math.BlockDimPos;
import com.feed_the_beast.ftblib.lib.util.ServerUtils;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ITeleporter;

public class TeleporterDimPos
implements ITeleporter {
    public final double posX;
    public final double posY;
    public final double posZ;
    public final int dim;

    public static TeleporterDimPos of(double x, double y, double z, int dim) {
        return new TeleporterDimPos(x, y, z, dim);
    }

    public static TeleporterDimPos of(Entity entity) {
        return new TeleporterDimPos(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_71093_bK);
    }

    public static TeleporterDimPos of(BlockPos pos, int dim) {
        return new TeleporterDimPos((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5, dim);
    }

    private TeleporterDimPos(double x, double y, double z, int d) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.dim = d;
    }

    public BlockDimPos block() {
        return new BlockDimPos(this.posX, this.posY, this.posZ, this.dim);
    }

    public void placeEntity(World world, Entity entity, float yaw) {
        entity.field_70179_y = 0.0;
        entity.field_70181_x = 0.0;
        entity.field_70159_w = 0.0;
        entity.field_70143_R = 0.0f;
        if (entity instanceof EntityPlayerMP && ((EntityPlayerMP)entity).field_71135_a != null) {
            ((EntityPlayerMP)entity).field_71135_a.func_147364_a(this.posX, this.posY, this.posZ, yaw, entity.field_70125_A);
        } else {
            entity.func_70012_b(this.posX, this.posY, this.posZ, yaw, entity.field_70125_A);
        }
    }

    @Nullable
    public Entity teleport(@Nullable Entity entity) {
        if (entity == null || entity.field_70170_p.field_72995_K) {
            return entity;
        }
        if (FTBLibConfig.debugging.log_teleport) {
            FTBLib.LOGGER.info("Teleporting '" + entity.func_70005_c_() + "' to [" + this.posX + ',' + this.posY + ',' + this.posZ + "] in " + ServerUtils.getDimensionName(this.dim).func_150260_c());
        }
        if (this.dim != entity.field_71093_bK) {
            return entity.changeDimension(this.dim, (ITeleporter)this);
        }
        this.placeEntity(entity.field_70170_p, entity, entity.field_70177_z);
        return entity;
    }
}

