/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.io;

import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.math.BlockDimPos;
import com.feed_the_beast.ftblib.lib.util.BlockUtils;
import com.feed_the_beast.ftblib.lib.util.CommonUtils;
import com.feed_the_beast.ftblib.lib.util.JsonUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.handler.codec.EncoderException;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import java.io.DataInput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;

public class DataIn {
    public static final Deserializer<String> STRING = DataIn::readString;
    public static final Deserializer<Integer> INT = DataIn::readInt;
    public static final Deserializer<Boolean> BOOLEAN = DataIn::readBoolean;
    public static final Deserializer<UUID> UUID = DataIn::readUUID;
    public static final Deserializer<BlockPos> BLOCK_POS = DataIn::readPos;
    public static final Deserializer<BlockDimPos> BLOCK_DIM_POS = DataIn::readDimPos;
    public static final Deserializer<JsonElement> JSON = DataIn::readJson;
    public static final Deserializer<ITextComponent> TEXT_COMPONENT = DataIn::readTextComponent;
    public static final Deserializer<ResourceLocation> RESOURCE_LOCATION = DataIn::readResourceLocation;
    public static final Deserializer<ItemStack> ITEM_STACK = DataIn::readItemStack;
    public static final Deserializer<ChunkPos> CHUNK_POS = data -> {
        int x = data.readVarInt();
        int z = data.readVarInt();
        return new ChunkPos(x, z);
    };
    private final ByteBuf byteBuf;

    public DataIn(ByteBuf io) {
        this.byteBuf = io;
    }

    public int getPosition() {
        return this.byteBuf.readerIndex();
    }

    public boolean readBoolean() {
        return this.byteBuf.readBoolean();
    }

    public byte readByte() {
        return this.byteBuf.readByte();
    }

    public void readBytes(byte[] bytes, int off, int len) {
        this.byteBuf.readBytes(bytes, off, len);
    }

    public void readBytes(byte[] bytes) {
        this.readBytes(bytes, 0, bytes.length);
    }

    public short readUnsignedByte() {
        return this.byteBuf.readUnsignedByte();
    }

    public short readShort() {
        return this.byteBuf.readShort();
    }

    public int readUnsignedShort() {
        return this.byteBuf.readUnsignedShort();
    }

    public int readInt() {
        return this.byteBuf.readInt();
    }

    public long readLong() {
        return this.byteBuf.readLong();
    }

    public float readFloat() {
        return this.byteBuf.readFloat();
    }

    public double readDouble() {
        return this.byteBuf.readDouble();
    }

    public String readString() {
        int s = this.readVarInt();
        if (s == 0) {
            return "";
        }
        byte[] bytes = new byte[s];
        this.readBytes(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public <T> Collection<T> readCollection(@Nullable Collection<T> collection, Deserializer<T> deserializer) {
        int num;
        if (collection != null) {
            collection.clear();
        }
        if ((num = this.readVarInt()) == 0) {
            return collection == null ? Collections.emptyList() : collection;
        }
        int size = Math.abs(num);
        if (collection == null) {
            boolean list;
            boolean bl = list = num > 0;
            if (size == 1) {
                return list ? Collections.singletonList(deserializer.read(this)) : Collections.singleton(deserializer.read(this));
            }
            Collection<Object> collection2 = collection = list ? new ArrayList(size) : new HashSet(size);
        }
        while (--size >= 0) {
            collection.add(deserializer.read(this));
        }
        return collection;
    }

    public <T> Collection<T> readCollection(Deserializer<T> deserializer) {
        return this.readCollection(null, deserializer);
    }

    public <K, V> Map<K, V> readMap(@Nullable Map<K, V> map, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        int num;
        if (map != null) {
            map.clear();
        }
        if ((num = this.readVarInt()) == 0) {
            return map == null ? Collections.emptyMap() : map;
        }
        int size = Math.abs(num);
        if (map == null) {
            boolean linked;
            boolean bl = linked = num < 0;
            if (keyDeserializer == INT) {
                map = (Map)CommonUtils.cast(linked ? new Int2ObjectLinkedOpenHashMap(size) : new Int2ObjectOpenHashMap(size));
            } else {
                Map map2 = map = linked ? new LinkedHashMap(size) : new HashMap(size);
            }
        }
        while (--size >= 0) {
            K key = keyDeserializer.read(this);
            V value = valueDeserializer.read(this);
            map.put(key, value);
        }
        return map;
    }

    public <K, V> Map<K, V> readMap(Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        return this.readMap(null, keyDeserializer, valueDeserializer);
    }

    public ItemStack readItemStack() {
        int id = this.readVarInt();
        if (id == 0) {
            return ItemStack.field_190927_a;
        }
        Item item = Item.func_150899_d((int)id);
        if (item == null || item == Items.field_190931_a) {
            return ItemStack.field_190927_a;
        }
        int size = this.readVarInt();
        int meta = this.readVarInt();
        ItemStack stack = new ItemStack(item, size, meta);
        stack.func_77973_b().readNBTShareTag(stack, this.readNBT());
        return stack;
    }

    @Nullable
    public NBTTagCompound readNBT() {
        int i = this.byteBuf.readerIndex();
        byte b0 = this.byteBuf.readByte();
        if (b0 == 0) {
            return null;
        }
        this.byteBuf.readerIndex(i);
        try {
            return CompressedStreamTools.func_152456_a((DataInput)new ByteBufInputStream(this.byteBuf), (NBTSizeTracker)NBTSizeTracker.field_152451_a);
        }
        catch (IOException ex) {
            throw new EncoderException((Throwable)ex);
        }
    }

    @Nullable
    public NBTBase readNBTBase() {
        switch (this.readByte()) {
            case 0: {
                return null;
            }
            case 1: {
                return new NBTTagByte(this.readByte());
            }
            case 2: {
                return new NBTTagShort(this.readShort());
            }
            case 3: {
                return new NBTTagInt(this.readInt());
            }
            case 4: {
                return new NBTTagLong(this.readLong());
            }
            case 5: {
                return new NBTTagFloat(this.readFloat());
            }
            case 6: {
                return new NBTTagDouble(this.readDouble());
            }
            case 8: {
                return new NBTTagString(this.readString());
            }
            case 10: {
                return this.readNBT();
            }
        }
        return this.readNBT().func_74781_a("_");
    }

    public BlockPos readPos() {
        int x = this.readVarInt();
        int y = this.readVarInt();
        int z = this.readVarInt();
        return new BlockPos(x, y, z);
    }

    public BlockDimPos readDimPos() {
        int d = this.readVarInt();
        int x = this.readVarInt();
        int y = this.readVarInt();
        int z = this.readVarInt();
        return new BlockDimPos(x, y, z, d);
    }

    public UUID readUUID() {
        long msb = this.readLong();
        long lsb = this.readLong();
        return new UUID(msb, lsb);
    }

    public ResourceLocation readResourceLocation() {
        return new ResourceLocation(this.readString());
    }

    public JsonElement readJson() {
        switch (this.readUnsignedByte()) {
            case 0: {
                return JsonNull.INSTANCE;
            }
            case 1: {
                JsonObject json = new JsonObject();
                for (Map.Entry<String, JsonElement> entry : this.readMap(STRING, JSON).entrySet()) {
                    json.add(entry.getKey(), entry.getValue());
                }
                return json;
            }
            case 2: {
                JsonArray json = new JsonArray();
                for (JsonElement json1 : this.readCollection(JSON)) {
                    json.add(json1);
                }
                return json;
            }
            case 3: {
                String s = this.readString();
                return s.isEmpty() ? JsonUtils.JSON_EMPTY_STRING : new JsonPrimitive(s);
            }
            case 4: {
                return JsonUtils.JSON_ZERO;
            }
            case 5: {
                return JsonUtils.JSON_TRUE;
            }
            case 6: {
                return JsonUtils.JSON_FALSE;
            }
            case 7: {
                return new JsonPrimitive((Number)this.readVarLong());
            }
            case 8: {
                return new JsonPrimitive((Number)Float.valueOf(this.readFloat()));
            }
            case 9: {
                return new JsonPrimitive((Number)this.readDouble());
            }
            case 10: {
                return JsonUtils.JSON_EMPTY_STRING;
            }
        }
        return JsonNull.INSTANCE;
    }

    @Nullable
    public ITextComponent readTextComponent() {
        return JsonUtils.deserializeTextComponent(this.readJson());
    }

    public IBlockState readBlockState() {
        int id = this.readInt();
        return id == 0 ? BlockUtils.AIR_STATE : Block.func_176220_d((int)id);
    }

    public Icon readIcon() {
        return Icon.getIcon(this.readJson());
    }

    public IntList readIntList() {
        int size = this.readVarInt();
        if (size == 0) {
            return IntLists.EMPTY_LIST;
        }
        if (size == 1) {
            return IntLists.singleton((int)this.readInt());
        }
        IntArrayList list = new IntArrayList();
        for (int i = 0; i < size; ++i) {
            list.add(this.readInt());
        }
        return list;
    }

    public int readVarInt() {
        byte b = this.readByte();
        switch (b) {
            case 121: {
                return this.readByte();
            }
            case 122: {
                return this.readShort();
            }
            case 123: {
                return this.readInt();
            }
        }
        return b;
    }

    public long readVarLong() {
        byte b = this.readByte();
        switch (b) {
            case 121: {
                return this.readByte();
            }
            case 122: {
                return this.readShort();
            }
            case 123: {
                return this.readInt();
            }
            case 124: {
                return this.readLong();
            }
        }
        return b;
    }

    @FunctionalInterface
    public static interface Deserializer<T> {
        public T read(DataIn var1);
    }
}

