/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.icon;

import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.icon.ImageIcon;
import com.feed_the_beast.ftblib.lib.io.DataReader;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.IImageBuffer;
import net.minecraft.client.renderer.ImageBufferDownload;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PlayerHeadIcon
extends ImageIcon {
    public final UUID uuid;

    public PlayerHeadIcon(@Nullable UUID id) {
        super(id == null ? DefaultPlayerSkin.func_177335_a() : new ResourceLocation("skins/" + StringUtils.fromUUID(id)));
        this.uuid = id;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void bindTexture() {
        TextureManager manager = Minecraft.func_71410_x().func_110434_K();
        Object img = manager.func_110581_b(this.texture);
        if (img == null) {
            img = new ThreadLoadSkin(this);
            manager.func_110579_a(this.texture, img);
        }
        GlStateManager.func_179144_i((int)img.func_110552_b());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(int x, int y, int w, int h) {
        this.bindTexture();
        GuiHelper.drawTexturedRect(x, y, w, h, this.color, 0.125, 0.125, 0.25, 0.25);
        GuiHelper.drawTexturedRect(x, y, w, h, this.color, 0.625, 0.125, 0.75, 0.25);
    }

    @Override
    public String toString() {
        return "player:" + this.uuid;
    }

    private static class ThreadLoadSkin
    extends SimpleTexture {
        private final PlayerHeadIcon icon;
        private final IImageBuffer imageBuffer;
        private BufferedImage bufferedImage;
        private Thread imageThread;
        private boolean textureUploaded;

        public ThreadLoadSkin(PlayerHeadIcon i) {
            super(DefaultPlayerSkin.func_177334_a((UUID)i.uuid));
            this.icon = i;
            this.imageBuffer = new ImageBufferDownload();
        }

        public int func_110552_b() {
            if (!this.textureUploaded && this.bufferedImage != null) {
                this.func_147631_c();
                TextureUtil.func_110987_a((int)super.func_110552_b(), (BufferedImage)this.bufferedImage);
                this.textureUploaded = true;
            }
            return super.func_110552_b();
        }

        public void func_110551_a(IResourceManager resourceManager) throws IOException {
            if (this.bufferedImage == null) {
                super.func_110551_a(resourceManager);
            }
            if (this.imageThread == null) {
                this.imageThread = new Thread("Skin Downloader for " + this.icon.uuid){

                    @Override
                    public void run() {
                        String imageUrl = "";
                        try {
                            JsonObject json = DataReader.get(new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + StringUtils.fromUUID(((ThreadLoadSkin)this).icon.uuid)), "application/json; charset=utf-8", Minecraft.func_71410_x().func_110437_J()).json().getAsJsonObject();
                            for (JsonElement element : json.get("properties").getAsJsonArray()) {
                                String base64;
                                JsonObject json1;
                                if (!element.isJsonObject() || !element.getAsJsonObject().get("name").getAsString().equals("textures") || !(json1 = DataReader.get(base64 = new String(Base64.getDecoder().decode(element.getAsJsonObject().get("value").getAsString()), StandardCharsets.UTF_8)).json().getAsJsonObject().get("textures").getAsJsonObject()).has("SKIN")) continue;
                                imageUrl = json1.get("SKIN").getAsJsonObject().get("url").getAsString();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (imageUrl.isEmpty()) {
                            return;
                        }
                        try {
                            bufferedImage = imageBuffer.func_78432_a(DataReader.get(new URL(imageUrl), "image/png", Minecraft.func_71410_x().func_110437_J()).image());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                };
                this.imageThread.setDaemon(true);
                this.imageThread.start();
            }
        }
    }
}

