/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.icon;

import com.feed_the_beast.ftblib.client.FTBLibClientEventHandler;
import com.feed_the_beast.ftblib.lib.client.IPixelBuffer;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.icon.ImageCallback;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.WritableImage;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraftforge.fml.common.Loader;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class IconRenderer {
    private static final Collection<IconCallbackPair> QUEUE = new LinkedList<IconCallbackPair>();
    private static javafx.scene.image.Image nullImage = null;
    private static Map<Icon, javafx.scene.image.Image> imageCache = new HashMap<Icon, javafx.scene.image.Image>();

    public static void clearCache() {
        imageCache = new HashMap<Icon, javafx.scene.image.Image>();
    }

    public static javafx.scene.image.Image getNullImage() {
        if (nullImage == null) {
            nullImage = Loader.isModLoaded((String)"itemfilters") ? new javafx.scene.image.Image(IconRenderer.class.getResourceAsStream("/assets/itemfilters/textures/items/missing.png")) : new javafx.scene.image.Image(IconRenderer.class.getResourceAsStream("/assets/ftblib/textures/icons/cancel.png"));
        }
        return nullImage;
    }

    public static boolean load(@Nullable Icon icon, ImageCallback callback) {
        if (icon == null) {
            callback.imageLoaded(false, null);
            return true;
        }
        if (icon.isEmpty()) {
            callback.imageLoaded(false, IconRenderer.getNullImage());
            return true;
        }
        javafx.scene.image.Image image = imageCache.get(icon);
        if (image != null) {
            callback.imageLoaded(false, image);
            return true;
        }
        if (icon.hasPixelBuffer()) {
            IPixelBuffer buffer = icon.createPixelBuffer();
            if (buffer == null) {
                image = IconRenderer.getNullImage();
            } else {
                int w = buffer.getWidth();
                int h = buffer.getHeight();
                image = new WritableImage(w, h);
                ((WritableImage)image).getPixelWriter().setPixels(0, 0, w, h, (PixelFormat)PixelFormat.getIntArgbInstance(), buffer.getPixels(), 0, w);
            }
            imageCache.put(icon, image);
            callback.imageLoaded(false, image);
            return true;
        }
        imageCache.put(icon, IconRenderer.getNullImage());
        callback.imageLoaded(false, IconRenderer.getNullImage());
        IconCallbackPair pair = new IconCallbackPair();
        pair.icon = icon;
        pair.callback = callback;
        Minecraft.func_71410_x().func_152344_a((Runnable)pair);
        return false;
    }

    public static void render() {
        if (QUEUE.isEmpty()) {
            return;
        }
        IconCallbackPair[] queued = QUEUE.toArray(new IconCallbackPair[0]);
        QUEUE.clear();
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution res = new ScaledResolution(mc);
        int size = Math.min(Math.min(mc.field_71440_d, mc.field_71443_c), 64);
        mc.field_71460_t.func_78478_c();
        RenderHelper.func_74520_c();
        float scale = (float)size / (16.0f * (float)res.func_78325_e());
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)(-(scale * 100.0f)));
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        float oldZLevel = mc.func_175599_af().field_77023_b;
        mc.func_175599_af().field_77023_b = -50.0f;
        GlStateManager.func_179091_B();
        GlStateManager.func_179142_g();
        GlStateManager.func_179126_j();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)770, (int)1);
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179118_c();
        int[] pixels = new int[size * size];
        AffineTransform at = new AffineTransform();
        at.concatenate(AffineTransform.getScaleInstance(1.0, -1.0));
        at.concatenate(AffineTransform.getTranslateInstance(0.0, -size));
        BufferedImage img = new BufferedImage(size, size, 2);
        for (IconCallbackPair pair : queued) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179082_a((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179086_m((int)16640);
            pair.icon.drawStatic(0, 0, 16, 16);
            GlStateManager.func_179121_F();
            try {
                ByteBuffer buf = BufferUtils.createByteBuffer((int)(size * size * 4));
                GL11.glReadBuffer((int)1029);
                GlStateManager.func_187434_L();
                GL11.glReadPixels((int)0, (int)(Minecraft.func_71410_x().field_71440_d - size), (int)size, (int)size, (int)32993, (int)5121, (ByteBuffer)buf);
                buf.asIntBuffer().get(pixels);
                img.setRGB(0, 0, size, size, pixels, 0, size);
                BufferedImage flipped = new BufferedImage(size, size, 2);
                Graphics2D g = flipped.createGraphics();
                g.transform(at);
                g.drawImage((Image)img, 0, 0, null);
                g.dispose();
                pixels = flipped.getRGB(0, 0, size, size, pixels, 0, size);
                WritableImage image = new WritableImage(size, size);
                image.getPixelWriter().setPixels(0, 0, size, size, (PixelFormat)PixelFormat.getIntArgbInstance(), pixels, 0, size);
                imageCache.put(pair.icon, (javafx.scene.image.Image)image);
                pair.callback.imageLoaded(true, (javafx.scene.image.Image)image);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        GlStateManager.func_179140_f();
        GlStateManager.func_179119_h();
        GlStateManager.func_179097_i();
        GlStateManager.func_179084_k();
        Minecraft.func_71410_x().func_175599_af().field_77023_b = oldZLevel;
    }

    private static class IconCallbackPair
    implements Runnable {
        private Icon icon;
        private ImageCallback callback;

        private IconCallbackPair() {
        }

        @Override
        public void run() {
            QUEUE.add(this);
            FTBLibClientEventHandler.shouldRenderIcons = true;
        }
    }
}

