/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.gui;

import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.ScrollBar;

public class PanelScrollBar
extends ScrollBar {
    public final Panel panel;

    public PanelScrollBar(Panel parent, ScrollBar.Plane plane, Panel p) {
        super(parent, plane, 0);
        this.panel = p;
        this.panel.attachedScrollbar = this;
    }

    public PanelScrollBar(Panel parent, Panel panel) {
        this(parent, ScrollBar.Plane.VERTICAL, panel);
    }

    @Override
    public void setMinValue(int min) {
    }

    @Override
    public int getMinValue() {
        return 0;
    }

    @Override
    public void setMaxValue(int max) {
        super.setMaxValue(max - (this.plane.isVertical ? this.panel.height : this.panel.width));
    }

    @Override
    public void setScrollStep(int s) {
        this.panel.setScrollStep(s);
    }

    @Override
    public int getScrollStep() {
        return this.panel.getScrollStep();
    }

    @Override
    public int getScrollBarSize() {
        int max = this.getMaxValue();
        if (max <= 0) {
            return 0;
        }
        int size = this.plane.isVertical ? (int)((double)this.panel.height / (double)(max + this.panel.height) * (double)this.height) : (int)((double)this.panel.width / (double)(max + this.panel.width) * (double)this.width);
        return size < 10 ? 10 : size;
    }

    @Override
    public void onMoved() {
        int value;
        int n = value = this.getMaxValue() <= 0 ? 0 : this.getValue();
        if (this.plane.isVertical) {
            this.panel.setScrollY(value);
        } else {
            this.panel.setScrollX(value);
        }
    }

    @Override
    public boolean canMouseScroll() {
        return super.canMouseScroll() || this.panel.isMouseOver();
    }
}

