/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib;

import com.feed_the_beast.ftblib.FTBLib;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftblib.lib.util.misc.NameMap;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.function.BiFunction;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public enum EnumTeamStatus implements IStringSerializable
{
    ENEMY(-10, "enemy", TextFormatting.RED, true),
    NONE(0, "none", TextFormatting.WHITE, true),
    INVITED(10, "invited", TextFormatting.DARK_AQUA, true),
    ALLY(30, "ally", TextFormatting.DARK_GREEN, true),
    MEMBER(50, "member", TextFormatting.BLUE, false),
    MOD(80, "mod", TextFormatting.BLUE, true),
    OWNER(100, "owner", TextFormatting.GOLD, false);

    public static final EnumTeamStatus[] VALUES;
    public static final BiFunction<ICommandSender, EnumTeamStatus, ITextComponent> NAME_GETTER;
    public static final NameMap<EnumTeamStatus> NAME_MAP;
    public static final NameMap<EnumTeamStatus> NAME_MAP_PERMS;
    public static final Collection<EnumTeamStatus> VALID_VALUES;
    private final String name;
    private final int status;
    private final TextFormatting color;
    private final String langKey;
    private final boolean canBeSet;

    private EnumTeamStatus(int s, String n2, TextFormatting c, boolean cs) {
        this.name = n2;
        this.status = s;
        this.color = c;
        this.langKey = "ftblib.lang.team_status." + this.name;
        this.canBeSet = cs;
    }

    public String func_176610_l() {
        return this.name;
    }

    public int getStatus() {
        return this.status;
    }

    public TextFormatting getColor() {
        return this.color;
    }

    public String getLangKey() {
        return this.langKey;
    }

    public boolean canBeSet() {
        return this.canBeSet;
    }

    public boolean isNone() {
        return this == NONE;
    }

    public boolean isEqualOrGreaterThan(EnumTeamStatus s) {
        return this.status >= s.status;
    }

    public String toString() {
        return this.func_176610_l();
    }

    static {
        VALUES = EnumTeamStatus.values();
        NAME_GETTER = (sender, value) -> StringUtils.color(FTBLib.lang(sender, value.getLangKey(), new Object[0]), value.getColor());
        NAME_MAP = NameMap.createWithName(NONE, NAME_GETTER, VALUES);
        NAME_MAP_PERMS = NameMap.createWithName(ALLY, NAME_GETTER, NONE, ALLY, MEMBER);
        VALID_VALUES = new LinkedHashSet<EnumTeamStatus>();
        for (EnumTeamStatus s : VALUES) {
            if (!s.canBeSet) continue;
            VALID_VALUES.add(s);
        }
    }
}

