/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.effects;

import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityMagicEffect;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class EntityAxeAttack
extends EntityMagicEffect {
    private static final DataParameter<Boolean> VERTICAL = EntityDataManager.func_187226_a(EntityAxeAttack.class, (DataSerializer)DataSerializers.field_187198_h);
    public static int SWING_DURATION_HOR = 24;
    public static int SWING_DURATION_VER = 30;
    private float quakeAngle = 0.0f;
    private AxisAlignedBB quakeBB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);

    public EntityAxeAttack(World world) {
        super(world);
    }

    public EntityAxeAttack(World world, EntityLivingBase caster, boolean vertical) {
        this(world);
        if (!world.field_72995_K) {
            this.setCasterID(caster.func_145782_y());
        }
        this.setVertical(vertical);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(VERTICAL, (Object)false);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.caster != null && this.caster.field_70128_L) {
            this.func_70106_y();
        }
        if (this.caster != null) {
            this.func_70080_a(this.caster.field_70165_t, this.caster.field_70163_u, this.caster.field_70161_v, this.caster.field_70177_z, this.caster.field_70125_A);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa == 7) {
            this.func_184185_a(MMSounds.ENTITY_FROSTMAW_WHOOSH, 1.0f, 0.8f);
        }
        if (!this.field_70170_p.field_72995_K && this.caster != null) {
            if (!this.getVertical() && this.field_70173_aa == SWING_DURATION_HOR / 2 - 1) {
                this.dealDamage(7.0f * ConfigHandler.TOOLS_AND_ABILITIES.axeAttackMultiplier, 4.5f, 160.0f, 1.2f);
            } else if (this.getVertical() && this.field_70173_aa == SWING_DURATION_VER / 2 - 1) {
                this.dealDamage(9.0f * ConfigHandler.TOOLS_AND_ABILITIES.axeAttackMultiplier, 4.5f, 40.0f, 0.8f);
                this.quakeAngle = this.field_70177_z;
                this.quakeBB = this.func_174813_aQ();
                this.func_184185_a(SoundEvents.field_187689_f, 0.3f, 0.5f);
                this.func_184185_a(SoundEvents.field_187539_bB, 2.0f, 0.9f + this.field_70146_Z.nextFloat() * 0.1f);
            }
        }
        if (this.getVertical() && this.caster != null && this.field_70173_aa >= SWING_DURATION_VER / 2) {
            int maxDistance = 16;
            double perpFacing = (double)this.quakeAngle * (Math.PI / 180);
            double facingAngle = perpFacing + 1.5707963267948966;
            int hitY = MathHelper.func_76128_c((double)(this.quakeBB.field_72338_b - 0.5));
            int distance = this.field_70173_aa - 15;
            double spread = 1.099557410031076;
            int arcLen = MathHelper.func_76143_f((double)((double)distance * spread));
            double minY = this.quakeBB.field_72338_b;
            double maxY = this.quakeBB.field_72337_e;
            for (int i = 0; i < arcLen; ++i) {
                double theta = ((double)i / ((double)arcLen - 1.0) - 0.5) * spread + facingAngle;
                double vx = Math.cos(theta);
                double vz = Math.sin(theta);
                double px = this.field_70165_t + vx * (double)distance;
                double pz = this.field_70161_v + vz * (double)distance;
                float factor = 1.0f - (float)distance / (float)maxDistance;
                AxisAlignedBB selection = new AxisAlignedBB(px - 1.5, minY, pz - 1.5, px + 1.5, maxY, pz + 1.5);
                List hit = this.field_70170_p.func_72872_a(Entity.class, selection);
                for (Entity entity : hit) {
                    if (entity == this || entity instanceof EntityFallingBlock || entity == this.caster) continue;
                    if (entity instanceof EntityLivingBase) {
                        if (this.caster instanceof EntityPlayer) {
                            entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)this.caster)), (factor * 5.0f + 1.0f) * ConfigHandler.TOOLS_AND_ABILITIES.axeAttackMultiplier);
                        } else {
                            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.caster), (factor * 5.0f + 1.0f) * ConfigHandler.TOOLS_AND_ABILITIES.axeAttackMultiplier);
                        }
                    }
                    double magnitude = -0.2;
                    entity.field_70159_w += vx * (double)(1.0f - factor) * magnitude;
                    if (entity.field_70122_E) {
                        entity.field_70181_x += 0.15;
                    }
                    entity.field_70179_y += vz * (double)(1.0f - factor) * magnitude;
                    if (!(entity instanceof EntityPlayerMP)) continue;
                    ((EntityPlayerMP)entity).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(entity));
                }
                if (this.field_70170_p.field_73012_v.nextBoolean()) {
                    IBlockState block;
                    int hitX = MathHelper.func_76128_c((double)px);
                    int hitZ = MathHelper.func_76128_c((double)pz);
                    BlockPos pos = new BlockPos(hitX, hitY, hitZ);
                    BlockPos abovePos = new BlockPos((Vec3i)pos).func_177984_a();
                    BlockPos belowPos = new BlockPos((Vec3i)pos).func_177977_b();
                    if (this.field_70170_p.func_175623_d(abovePos) && !this.field_70170_p.func_175623_d(belowPos) && (block = this.field_70170_p.func_180495_p(pos)).func_185904_a() != Material.field_151579_a && block.func_185898_k() && block != Blocks.field_150357_h && !block.func_177230_c().hasTileEntity(block)) {
                        EntityFallingBlock fallingBlock = new EntityFallingBlock(this.field_70170_p, (double)hitX + 0.5, (double)hitY + 0.5, (double)hitZ + 0.5, block);
                        fallingBlock.field_70159_w = 0.0;
                        fallingBlock.field_70181_x = 0.1;
                        fallingBlock.field_70179_y = 0.0;
                        fallingBlock.field_145812_b = 2;
                        this.field_70170_p.func_72838_d((Entity)fallingBlock);
                        this.field_70170_p.func_175698_g(pos);
                        int amount = 6 + this.field_70170_p.field_73012_v.nextInt(10);
                        int stateId = Block.func_176210_f((IBlockState)block);
                        while (amount-- > 0) {
                            double cx = px + (double)(this.field_70170_p.field_73012_v.nextFloat() * 2.0f) - 1.0;
                            double cy = this.func_174813_aQ().field_72338_b + 0.1 + (double)this.field_70170_p.field_73012_v.nextFloat() * 0.3;
                            double d = pz + (double)(this.field_70170_p.field_73012_v.nextFloat() * 2.0f) - 1.0;
                        }
                    }
                }
                if (!this.field_70170_p.field_73012_v.nextBoolean()) continue;
                int amount = this.field_70170_p.field_73012_v.nextInt(5);
                while (amount-- > 0) {
                    double velX = vx * 0.075;
                    double velY = (double)factor * 0.3 + 0.025;
                    double d = vz * 0.075;
                }
            }
        }
        if (this.field_70173_aa > SWING_DURATION_HOR) {
            this.func_70106_y();
        }
    }

    private void dealDamage(float damage, float range, float arc, float knockback) {
        boolean hit = false;
        List<EntityLivingBase> entitiesHit = this.getEntityLivingBaseNearby(range, 2.0, range, range);
        for (EntityLivingBase entityHit : entitiesHit) {
            float entityHitAngle = (float)((Math.atan2(entityHit.field_70161_v - this.field_70161_v, entityHit.field_70165_t - this.field_70165_t) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.field_70177_z % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.field_70161_v - this.field_70161_v) * (entityHit.field_70161_v - this.field_70161_v) + (entityHit.field_70165_t - this.field_70165_t) * (entityHit.field_70165_t - this.field_70165_t));
            if (!(entityHit != this.caster && entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f)) continue;
            if (this.caster instanceof EntityPlayer) {
                ((EntityPlayer)this.caster).func_71059_n((Entity)entityHit);
            } else {
                entityHit.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.caster), damage);
            }
            entityHit.field_70159_w *= (double)knockback;
            entityHit.field_70179_y *= (double)knockback;
            hit = true;
        }
        if (hit) {
            this.func_184185_a(SoundEvents.field_187689_f, 0.3f, 0.5f);
        }
    }

    @Override
    protected void func_70037_a(NBTTagCompound compound) {
    }

    @Override
    protected void func_70014_b(NBTTagCompound compound) {
    }

    public void setVertical(boolean vertical) {
        this.func_184212_Q().func_187227_b(VERTICAL, (Object)vertical);
    }

    public boolean getVertical() {
        return (Boolean)this.func_184212_Q().func_187225_a(VERTICAL);
    }

    private List<EntityLivingBase> getEntityLivingBaseNearby(double distanceX, double distanceY, double distanceZ, double radius) {
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(distanceX, distanceY, distanceZ));
        ArrayList nearEntities = list.stream().filter(entityNeighbor -> entityNeighbor instanceof EntityLivingBase && (double)this.func_70032_d((Entity)entityNeighbor) <= radius).map(entityNeighbor -> (EntityLivingBase)entityNeighbor).collect(Collectors.toCollection(ArrayList::new));
        return nearEntities;
    }

    public EntityLivingBase getCaster() {
        return this.caster;
    }
}

