/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.block;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Random;
import java.util.stream.Collector;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockGrottol
extends BlockHorizontal {
    public static final PropertyEnum<Variant> VARIANT = PropertyEnum.func_177709_a((String)"variant", Variant.class);
    private static final AxisAlignedBB BOUNDS = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.9375, 0.9375);

    public BlockGrottol() {
        super(Material.field_151576_e, MapColor.field_151648_G);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.NORTH).func_177226_a(VARIANT, (Comparable)((Object)Variant.DIAMOND)));
        this.func_149713_g(0);
        this.field_149783_u = true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDS;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing facing) {
        return BlockFaceShape.UNDEFINED;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public Item func_180660_a(IBlockState state, Random rng, int fortune) {
        return Items.field_190931_a;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) && BlockGrottol.hasSupport(worldIn, pos);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (BlockGrottol.hasSupport(world, pos)) {
            world.func_175698_g(pos);
        }
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public int func_176201_c(IBlockState state) {
        return ((Variant)((Object)state.func_177229_b(VARIANT))).getIndex() << 2 & 0xC | ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176736_b() & 3;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Variant.valueOf((meta & 0xC) >> 2))).func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.func_176731_b((int)(meta & 3)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_185512_D, VARIANT});
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)field_185512_D, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    private static boolean hasSupport(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).func_185904_a().func_76220_a();
    }

    public static enum Variant implements IStringSerializable
    {
        DIAMOND(0, "diamond"),
        BLACK_PINK(1, "black_pink");

        private static final Int2ObjectMap<Variant> LOOKUP;
        private final int index;
        private final String name;

        private Variant(int index, String name) {
            this.index = index;
            this.name = name;
        }

        public final int getIndex() {
            return this.index;
        }

        public final String func_176610_l() {
            return this.name;
        }

        public static Variant valueOf(int index) {
            return (Variant)((Object)LOOKUP.get(index));
        }

        static {
            LOOKUP = Stream.of(Variant.values()).collect(Collector.of(Int2ObjectOpenHashMap::new, (map, variant) -> {
                Variant cfr_ignored_0 = (Variant)((Object)((Object)map.put(variant.getIndex(), (Object)variant)));
            }, (left, right) -> {
                throw new IllegalStateException();
            }, map -> {
                map.defaultReturnValue((Object)DIAMOND);
                return Int2ObjectMaps.unmodifiable((Int2ObjectMap)map);
            }, new Collector.Characteristics[0]));
        }
    }
}

