/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.particles.util;

import com.bobmowzie.mowziesmobs.client.particle.MMParticle;
import com.bobmowzie.mowziesmobs.client.particle.ParticleFactory;
import com.bobmowzie.mowziesmobs.client.particle.ParticleTextureStitcher;
import com.bobmowzie.mowziesmobs.client.particles.util.MowzieParticleBase;
import com.bobmowzie.mowziesmobs.client.particles.util.ParticleComponent;
import com.bobmowzie.mowziesmobs.client.particles.util.RibbonComponent;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ParticleRibbon
extends MowzieParticleBase {
    public Vec3d[] positions;
    public Vec3d[] prevPositions;

    protected ParticleRibbon(World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double motionX, double motionY, double motionZ, double yaw, double pitch, double roll, double scale, double r, double g, double b, double a, double drag, double duration, boolean faceCamera, boolean emissive, int length, ParticleComponent[] components) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn, motionX, motionY, motionZ, yaw, pitch, roll, scale, r, g, b, a, drag, duration, faceCamera, emissive, 0.0f, components);
        this.positions = new Vec3d[length];
        this.prevPositions = new Vec3d[length];
        Vec3d pos = new Vec3d(this.getPosX(), this.getPosY(), this.getPosZ());
        this.positions[0] = new Vec3d(this.getPosX(), this.getPosY(), this.getPosZ());
        this.prevPositions[0] = this.getPrevPos();
    }

    @Override
    public void func_189213_a() {
        super.func_189213_a();
        for (int i = this.positions.length - 1; i > 0; --i) {
            this.positions[i] = this.positions[i - 1];
            this.prevPositions[i] = this.prevPositions[i - 1];
        }
        this.positions[0] = new Vec3d(this.getPosX(), this.getPosY(), this.getPosZ());
        this.prevPositions[0] = this.getPrevPos();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void func_180434_a(BufferBuilder buffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        void var29_40;
        this.field_82339_as = this.prevAlpha + (this.alpha - this.prevAlpha) * partialTicks;
        if ((double)this.field_82339_as < 0.01) {
            this.field_82339_as = 0.01f;
        }
        this.field_70552_h = this.prevRed + (this.red - this.prevRed) * partialTicks;
        this.field_70553_i = this.prevGreen + (this.green - this.prevGreen) * partialTicks;
        this.field_70551_j = this.prevBlue + (this.blue - this.prevBlue) * partialTicks;
        this.field_70544_f = this.prevScale + (this.scale - this.prevScale) * partialTicks;
        for (ParticleComponent component : this.components) {
            component.preRender(this, partialTicks);
        }
        float f = (float)this.field_94054_b / 16.0f;
        float f1 = f + 0.0624375f;
        float f2 = (float)this.field_94055_c / 16.0f;
        float f3 = f2 + 0.0624375f;
        if (this.field_187119_C != null) {
            f = this.field_187119_C.func_94209_e();
            f1 = this.field_187119_C.func_94212_f();
            f2 = this.field_187119_C.func_94206_g();
            f3 = this.field_187119_C.func_94210_h();
        }
        int i = this.func_189214_a(partialTicks);
        int j = i >> 16 & 0xFFFF;
        int k = i & 0xFFFF;
        float r = this.field_70552_h;
        float g = this.field_70553_i;
        float b = this.field_70551_j;
        float a = this.field_82339_as;
        float scale = this.field_70544_f;
        float prevR = r;
        float prevG = g;
        float prevB = b;
        float prevA = a;
        float prevScale = scale;
        for (ParticleComponent particleComponent : this.components) {
            if (!(particleComponent instanceof RibbonComponent.PropertyOverLength)) continue;
            RibbonComponent.PropertyOverLength pOverLength = (RibbonComponent.PropertyOverLength)particleComponent;
            float value = pOverLength.evaluate(0.0f);
            if (pOverLength.getProperty() == RibbonComponent.PropertyOverLength.EnumRibbonProperty.SCALE) {
                prevScale *= value;
                continue;
            }
            if (pOverLength.getProperty() == RibbonComponent.PropertyOverLength.EnumRibbonProperty.RED) {
                prevR *= value;
                continue;
            }
            if (pOverLength.getProperty() == RibbonComponent.PropertyOverLength.EnumRibbonProperty.GREEN) {
                prevG *= value;
                continue;
            }
            if (pOverLength.getProperty() == RibbonComponent.PropertyOverLength.EnumRibbonProperty.BLUE) {
                prevB *= value;
                continue;
            }
            if (pOverLength.getProperty() != RibbonComponent.PropertyOverLength.EnumRibbonProperty.ALPHA) continue;
            prevA *= value;
        }
        Vec3d offsetDir = new Vec3d(0.0, 0.0, 0.0);
        for (int index = 0; index < this.positions.length - 1; ++index) {
            if (this.positions[index] == null || this.positions[index + 1] == null) continue;
            r = this.field_70552_h;
            g = this.field_70553_i;
            b = this.field_70551_j;
            scale = this.field_70544_f;
            float t = ((float)index + 1.0f) / ((float)this.positions.length - 1.0f);
            for (ParticleComponent component : this.components) {
                if (!(component instanceof RibbonComponent.PropertyOverLength)) continue;
                RibbonComponent.PropertyOverLength pOverLength = (RibbonComponent.PropertyOverLength)component;
                float value = pOverLength.evaluate(t);
                if (pOverLength.getProperty() == RibbonComponent.PropertyOverLength.EnumRibbonProperty.SCALE) {
                    scale *= value;
                    continue;
                }
                if (pOverLength.getProperty() == RibbonComponent.PropertyOverLength.EnumRibbonProperty.RED) {
                    r *= value;
                    continue;
                }
                if (pOverLength.getProperty() == RibbonComponent.PropertyOverLength.EnumRibbonProperty.GREEN) {
                    g *= value;
                    continue;
                }
                if (pOverLength.getProperty() == RibbonComponent.PropertyOverLength.EnumRibbonProperty.BLUE) {
                    b *= value;
                    continue;
                }
                if (pOverLength.getProperty() != RibbonComponent.PropertyOverLength.EnumRibbonProperty.ALPHA) continue;
                a *= value;
            }
            Vec3d vec3d = new Vec3d(field_70556_an, field_70554_ao, field_70555_ap);
            Vec3d p1 = this.prevPositions[index].func_178787_e(this.positions[index].func_178788_d(this.prevPositions[index]).func_186678_a((double)partialTicks)).func_178788_d(vec3d);
            Vec3d p2 = this.prevPositions[index + 1].func_178787_e(this.positions[index + 1].func_178788_d(this.prevPositions[index + 1]).func_186678_a((double)partialTicks)).func_178788_d(vec3d);
            if (index == 0) {
                Vec3d moveDir = p2.func_178788_d(p1).func_72432_b();
                offsetDir = this.faceCamera ? moveDir.func_72431_c(field_190016_K).func_72432_b() : moveDir.func_72431_c(new Vec3d(0.0, 1.0, 0.0)).func_72432_b();
                offsetDir = offsetDir.func_186678_a((double)prevScale);
            }
            Vec3d[] avec3d2 = new Vec3d[]{offsetDir.func_186678_a(-1.0), offsetDir, null, null};
            Vec3d moveDir = p2.func_178788_d(p1).func_72432_b();
            offsetDir = this.faceCamera ? moveDir.func_72431_c(field_190016_K).func_72432_b() : moveDir.func_72431_c(new Vec3d(0.0, 1.0, 0.0)).func_72432_b();
            avec3d2[2] = offsetDir = offsetDir.func_186678_a((double)scale);
            avec3d2[3] = offsetDir.func_186678_a(-1.0);
            Point3d[] vertices2 = new Point3d[]{new Point3d(avec3d2[0].field_72450_a, avec3d2[0].field_72448_b, avec3d2[0].field_72449_c), new Point3d(avec3d2[1].field_72450_a, avec3d2[1].field_72448_b, avec3d2[1].field_72449_c), new Point3d(avec3d2[2].field_72450_a, avec3d2[2].field_72448_b, avec3d2[2].field_72449_c), new Point3d(avec3d2[3].field_72450_a, avec3d2[3].field_72448_b, avec3d2[3].field_72449_c)};
            Matrix4d boxTranslate = new Matrix4d();
            boxTranslate.set(new Vector3d(p1.field_72450_a, p1.field_72448_b, p1.field_72449_c));
            boxTranslate.transform(vertices2[0]);
            boxTranslate.transform(vertices2[1]);
            boxTranslate.set(new Vector3d(p2.field_72450_a, p2.field_72448_b, p2.field_72449_c));
            boxTranslate.transform(vertices2[2]);
            boxTranslate.transform(vertices2[3]);
            buffer.func_181662_b(vertices2[0].getX(), vertices2[0].getY(), vertices2[0].getZ()).func_187315_a((double)f1, (double)f3).func_181666_a(prevR, prevG, prevB, prevA).func_187314_a(j, k).func_181675_d();
            buffer.func_181662_b(vertices2[1].getX(), vertices2[1].getY(), vertices2[1].getZ()).func_187315_a((double)f1, (double)f2).func_181666_a(prevR, prevG, prevB, prevA).func_187314_a(j, k).func_181675_d();
            buffer.func_181662_b(vertices2[2].getX(), vertices2[2].getY(), vertices2[2].getZ()).func_187315_a((double)f, (double)f2).func_181666_a(r, g, b, a).func_187314_a(j, k).func_181675_d();
            buffer.func_181662_b(vertices2[3].getX(), vertices2[3].getY(), vertices2[3].getZ()).func_187315_a((double)f, (double)f3).func_181666_a(r, g, b, a).func_187314_a(j, k).func_181675_d();
            prevR = r;
            prevG = g;
            prevB = b;
            prevA = a;
        }
        ParticleComponent[] particleComponentArray = this.components;
        int n = particleComponentArray.length;
        boolean bl = false;
        while (var29_40 < n) {
            ParticleComponent component = particleComponentArray[var29_40];
            component.postRender(this, buffer, partialTicks, j, k);
            ++var29_40;
        }
    }

    public static void spawnRibbon(World world, MMParticle particle, int length, double x, double y, double z, double motionX, double motionY, double motionZ, boolean faceCamera, double yaw, double pitch, double roll, double scale, double r, double g, double b, double a, double drag, double duration, boolean emissive) {
        particle.spawn(world, x, y, z, (ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withData(motionX, motionY, motionZ, yaw, pitch, roll, scale, r, g, b, a, drag, duration, faceCamera, emissive, length, new ParticleComponent[0]));
    }

    public static void spawnRibbon(World world, MMParticle particle, int length, double x, double y, double z, double motionX, double motionY, double motionZ, boolean faceCamera, double yaw, double pitch, double roll, double scale, double r, double g, double b, double a, double drag, double duration, boolean emissive, ParticleComponent[] components) {
        particle.spawn(world, x, y, z, (ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withData(motionX, motionY, motionZ, yaw, pitch, roll, scale, r, g, b, a, drag, duration, faceCamera, emissive, length, components));
    }

    public static final class ParticleRibbonFactory
    extends ParticleFactory<ParticleRibbonFactory, ParticleRibbon> {
        public ParticleRibbonFactory(ResourceLocation texture) {
            super(ParticleRibbon.class, ParticleTextureStitcher.create(ParticleRibbon.class, texture));
        }

        @Override
        public ParticleRibbon createParticle(ParticleFactory.ImmutableParticleArgs args) {
            return new ParticleRibbon(args.world, args.x, args.y, args.z, (double)((Double)args.data[0]), (double)((Double)args.data[1]), (double)((Double)args.data[2]), (double)((Double)args.data[3]), (double)((Double)args.data[4]), (double)((Double)args.data[5]), (double)((Double)args.data[6]), (double)((Double)args.data[7]), (double)((Double)args.data[8]), (double)((Double)args.data[9]), (double)((Double)args.data[10]), (double)((Double)args.data[11]), (double)((Double)args.data[12]), (boolean)((Boolean)args.data[13]), (boolean)((Boolean)args.data[14]), (Integer)args.data[15], (ParticleComponent[])args.data[16]);
        }
    }
}

