/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.storage;

import com.cjm721.overloaded.storage.IGenericDataStorage;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.util.INBTSerializable;

public class GenericDataStorage
implements IGenericDataStorage,
INBTSerializable<NBTTagCompound>,
Capability.IStorage<IGenericDataStorage> {
    @CapabilityInject(value=IGenericDataStorage.class)
    public static Capability<IGenericDataStorage> GENERIC_DATA_STORAGE = null;
    private final Map<String, Integer> integerMap = Maps.newHashMap();
    private final Map<String, Boolean> booleanMap = Maps.newHashMap();
    private final Map<String, Double> doubleMap = Maps.newHashMap();
    private final Map<String, Float> floatMap = Maps.newHashMap();

    public static void register() {
        CapabilityManager.INSTANCE.register(IGenericDataStorage.class, (Capability.IStorage)new GenericDataStorage(), GenericDataStorage::new);
    }

    @Override
    @Nonnull
    public Map<String, Integer> getIntegerMap() {
        return this.integerMap;
    }

    @Override
    @Nonnull
    public Map<String, Boolean> getBooleanMap() {
        return this.booleanMap;
    }

    @Override
    @Nonnull
    public Map<String, Double> getDoubleMap() {
        return this.doubleMap;
    }

    @Override
    @Nonnull
    public Map<String, Float> getFloatMap() {
        return this.floatMap;
    }

    public NBTTagCompound serializeNBT() {
        return this.writeNBT(GENERIC_DATA_STORAGE, this, null);
    }

    public void deserializeNBT(NBTTagCompound tagCompound) {
        this.readNBT(GENERIC_DATA_STORAGE, this, null, (NBTBase)tagCompound);
    }

    @Nullable
    public NBTTagCompound writeNBT(Capability<IGenericDataStorage> capability, IGenericDataStorage instance, EnumFacing side) {
        NBTTagCompound tagCompound = new NBTTagCompound();
        Map<String, Integer> integers = instance.getIntegerMap();
        Map<String, Boolean> booleans = instance.getBooleanMap();
        Map<String, Float> floats = instance.getFloatMap();
        Map<String, Double> doubles = instance.getDoubleMap();
        for (String key : integers.keySet()) {
            tagCompound.func_74768_a(key, integers.get(key).intValue());
        }
        for (String key : booleans.keySet()) {
            tagCompound.func_74757_a(key, booleans.get(key).booleanValue());
        }
        for (String key : floats.keySet()) {
            tagCompound.func_74776_a(key, floats.get(key).floatValue());
        }
        for (String key : doubles.keySet()) {
            tagCompound.func_74780_a(key, doubles.get(key).doubleValue());
        }
        return tagCompound;
    }

    public void readNBT(Capability<IGenericDataStorage> capability, IGenericDataStorage instance, EnumFacing side, NBTBase nbt) {
        if (!(nbt instanceof NBTTagCompound)) {
            return;
        }
        NBTTagCompound tagCompound = (NBTTagCompound)nbt;
        Map<String, Integer> integers = instance.getIntegerMap();
        Map<String, Boolean> booleans = instance.getBooleanMap();
        Map<String, Float> floats = instance.getFloatMap();
        Map<String, Double> doubles = instance.getDoubleMap();
        for (String key : tagCompound.func_150296_c()) {
            switch (tagCompound.func_150299_b(key)) {
                case 3: {
                    integers.put(key, tagCompound.func_74762_e(key));
                    break;
                }
                case 1: {
                    booleans.put(key, tagCompound.func_74767_n(key));
                    break;
                }
                case 5: {
                    floats.put(key, Float.valueOf(tagCompound.func_74760_g(key)));
                    break;
                }
                case 6: {
                    doubles.put(key, tagCompound.func_74769_h(key));
                }
            }
        }
    }
}

