/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.render.cache;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import mod.chiselsandbits.render.cache.ModelCacheCleanup;

public class CacheMap<K, V> {
    private final EqTest test;
    private final ReferenceQueue<K> queue = new ReferenceQueue();
    private final HashMap<Object, V> inner = new HashMap();
    private final EqWrapper lookupHelper = new EqWrapper();

    private boolean eq(Object a, Object b) {
        return this.test.doTest(a, b);
    }

    public CacheMap() {
        this.test = new EqSimple();
        ModelCacheCleanup.registerCacheMap(this);
    }

    public CacheMap(EqTest test) {
        this.test = test;
        ModelCacheCleanup.registerCacheMap(this);
    }

    protected void finalize() throws Throwable {
        ModelCacheCleanup.unregisterCacheMap(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K key, V value) {
        CacheMap cacheMap = this;
        synchronized (cacheMap) {
            this.inner.put(new WeakEntiry(key, this.queue), value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        CacheMap cacheMap = this;
        synchronized (cacheMap) {
            this.lookupHelper.setObject(key);
            return this.inner.get(this.lookupHelper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        CacheMap cacheMap = this;
        synchronized (cacheMap) {
            this.inner.clear();
            while (this.queue.poll() != null) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanup() {
        Reference<K> ref;
        while ((ref = this.queue.poll()) != null) {
            CacheMap cacheMap = this;
            synchronized (cacheMap) {
                this.inner.remove(ref);
            }
        }
    }

    private class EqWrapper {
        private int hashcode;
        private K inner;

        private EqWrapper() {
        }

        void setObject(K o) {
            if (o instanceof WeakReference) {
                this.inner = ((WeakReference)o).get();
                this.hashcode = CacheMap.this.test.getHash(this.inner);
            } else {
                this.inner = o;
                this.hashcode = CacheMap.this.test.getHash(this.inner);
            }
        }

        public int hashCode() {
            return this.hashcode;
        }

        public boolean equals(Object obj) {
            if (this.inner == null) {
                return false;
            }
            if (obj == this || this.inner == obj) {
                return true;
            }
            if (obj instanceof WeakReference) {
                Object o = ((WeakReference)obj).get();
                if (o == null) {
                    return false;
                }
                if (o == this.inner) {
                    return true;
                }
                return CacheMap.this.eq(this.inner, o);
            }
            return CacheMap.this.eq(this.inner, obj);
        }
    }

    private class WeakEntiry
    extends WeakReference<K> {
        final int hashcode;

        public WeakEntiry(K referent, ReferenceQueue<? super K> q) {
            super(referent, q);
            this.hashcode = CacheMap.this.test.getHash(referent);
        }

        public boolean equals(Object obj) {
            Object inner = this.get();
            if (inner == null) {
                return false;
            }
            if (obj == this || inner == obj) {
                return true;
            }
            if (obj instanceof WeakReference) {
                Object o = ((WeakReference)obj).get();
                if (o == null) {
                    return false;
                }
                if (o == inner) {
                    return true;
                }
                return CacheMap.this.eq(inner, o);
            }
            return CacheMap.this.eq(inner, obj);
        }

        public int hashCode() {
            return this.hashcode;
        }
    }

    private static class EqSimple
    implements EqTest {
        private EqSimple() {
        }

        @Override
        public boolean doTest(Object a, Object b) {
            return a.equals(b);
        }

        @Override
        public int getHash(Object referent) {
            return referent.hashCode();
        }
    }

    public static interface EqTest {
        public boolean doTest(Object var1, Object var2);

        public int getHash(Object var1);
    }
}

