/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.items;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import mod.chiselsandbits.bitbag.BagInventory;
import mod.chiselsandbits.chiseledblock.BlockBitInfo;
import mod.chiselsandbits.chiseledblock.BlockChiseled;
import mod.chiselsandbits.chiseledblock.ItemBlockChiseled;
import mod.chiselsandbits.chiseledblock.NBTBlobConverter;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.core.ClientSide;
import mod.chiselsandbits.helpers.ActingPlayer;
import mod.chiselsandbits.helpers.BitInventoryFeeder;
import mod.chiselsandbits.helpers.ContinousChisels;
import mod.chiselsandbits.helpers.IItemInInventory;
import mod.chiselsandbits.helpers.LocalStrings;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.integration.mcmultipart.MCMultipartProxy;
import mod.chiselsandbits.interfaces.IChiselModeItem;
import mod.chiselsandbits.items.ItemBitBag;
import mod.chiselsandbits.items.ItemChisel;
import mod.chiselsandbits.items.ItemChiseledBit;
import mod.chiselsandbits.items.ItemNegativePrint;
import mod.chiselsandbits.modes.PositivePatternMode;
import mod.chiselsandbits.network.NetworkRouter;
import mod.chiselsandbits.network.packets.PacketAccurateSneakPlace;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPositivePrint
extends ItemNegativePrint
implements IChiselModeItem,
PacketAccurateSneakPlace.IItemBlockAccurate {
    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag advanced) {
        this.defaultAddInfo(stack, worldIn, tooltip, advanced);
        ChiselsAndBits.getConfig().helpText(LocalStrings.HelpPositivePrint, tooltip, ClientSide.instance.getKeyName(Minecraft.func_71410_x().field_71474_y.field_74313_G), ClientSide.instance.getKeyName(Minecraft.func_71410_x().field_71474_y.field_74313_G), ClientSide.instance.getModeKey());
        if (stack.func_77942_o()) {
            if (ClientSide.instance.holdingShift()) {
                if (this.toolTipCache.needsUpdate(stack)) {
                    VoxelBlob blob = ModUtil.getBlobFromStack(stack, null);
                    this.toolTipCache.updateCachedValue(blob.listContents(new ArrayList<String>()));
                }
                tooltip.addAll((Collection)this.toolTipCache.getCached());
            } else {
                tooltip.add(LocalStrings.ShiftDetails.getLocal());
            }
        }
    }

    @Override
    protected NBTTagCompound getCompoundFromBlock(World world, BlockPos pos, EntityPlayer player) {
        IBlockState state = world.func_180495_p(pos);
        Block blkObj = state.func_177230_c();
        if (!(blkObj instanceof BlockChiseled) && BlockBitInfo.supportsBlock(state)) {
            NBTBlobConverter tmp = new NBTBlobConverter();
            tmp.fillWith(state);
            NBTTagCompound comp = new NBTTagCompound();
            tmp.writeChisleData(comp, false);
            comp.func_74774_a("side", (byte)ModUtil.getPlaceFace((EntityLivingBase)player).ordinal());
            return comp;
        }
        return super.getCompoundFromBlock(world, pos, player);
    }

    @Override
    protected boolean convertToStone() {
        return false;
    }

    @Override
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        IBlockState blkstate = world.func_180495_p(pos);
        if (ItemChiseledBit.checkRequiredSpace(player, blkstate)) {
            return EnumActionResult.FAIL;
        }
        boolean offgrid = false;
        if (PositivePatternMode.getMode(stack) == PositivePatternMode.PLACEMENT) {
            if (!world.field_72995_K) {
                return EnumActionResult.SUCCESS;
            }
            PacketAccurateSneakPlace pasp = new PacketAccurateSneakPlace();
            pasp.hand = hand;
            pasp.pos = pos;
            pasp.side = side;
            pasp.stack = stack;
            pasp.hitX = hitX;
            pasp.hitY = hitY;
            pasp.hitZ = hitZ;
            offgrid = pasp.offgrid = ClientSide.offGridPlacement(player);
            NetworkRouter.instance.sendToServer(pasp);
        }
        return this.placeItem(stack, player, world, pos, hand, side, hitX, hitY, hitZ, offgrid);
    }

    @Override
    public final EnumActionResult placeItem(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ, boolean offgrid) {
        ItemStack output;
        if (PositivePatternMode.getMode(stack) == PositivePatternMode.PLACEMENT && (output = this.getPatternedItem(stack, false)) != null) {
            Map<Integer, Integer> stats;
            VoxelBlob pattern = ModUtil.getBlobFromStack(stack, (EntityLivingBase)player);
            if (this.consumeEntirePattern(pattern, stats = pattern.getBlockSums(), pos, ActingPlayer.testingAs(player, hand)) && output.func_77973_b() instanceof ItemBlockChiseled) {
                ItemBlockChiseled ibc = (ItemBlockChiseled)output.func_77973_b();
                EnumActionResult res = ibc.placeItem(output, player, world, pos, hand, side, hitX, hitY, hitZ, offgrid);
                if (res == EnumActionResult.SUCCESS) {
                    this.consumeEntirePattern(pattern, stats, pos, ActingPlayer.actingAs(player, hand));
                }
                return res;
            }
            return EnumActionResult.FAIL;
        }
        return super.func_180614_a(player, world, pos, hand, side, hitX, hitY, hitZ);
    }

    private boolean consumeEntirePattern(VoxelBlob pattern, Map<Integer, Integer> stats, BlockPos pos, ActingPlayer player) {
        List<BagInventory> bags = ModUtil.getBags(player);
        for (Map.Entry<Integer, Integer> type : stats.entrySet()) {
            int inPattern = type.getKey();
            if (type.getKey() == 0) continue;
            IItemInInventory bit = ModUtil.findBit(player, pos, inPattern);
            int stillNeeded = type.getValue() - ModUtil.consumeBagBit(bags, inPattern, type.getValue());
            if (stillNeeded == 0) continue;
            for (int x = stillNeeded; x > 0 && bit.isValid(); --x) {
                if (!bit.consume()) continue;
                --stillNeeded;
                bit = ModUtil.findBit(player, pos, inPattern);
            }
            if (stillNeeded == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void applyPrint(ItemStack stack, World world, BlockPos pos, EnumFacing side, VoxelBlob vb, VoxelBlob pattern, EntityPlayer who, EnumHand hand) {
        ActingPlayer player = ActingPlayer.actingAs(who, hand);
        ContinousChisels selected = new ContinousChisels(player, pos, side);
        ItemStack spawnedItem = null;
        VoxelBlob filled = new VoxelBlob();
        MCMultipartProxy.proxyMCMultiPart.addFiller(world, pos, filled);
        List<BagInventory> bags = ModUtil.getBags(player);
        ArrayList<EntityItem> spawnlist = new ArrayList<EntityItem>();
        PositivePatternMode chiselMode = PositivePatternMode.getMode(stack);
        boolean chisel_bits = chiselMode == PositivePatternMode.IMPOSE || chiselMode == PositivePatternMode.REPLACE;
        boolean chisel_to_air = chiselMode == PositivePatternMode.REPLACE;
        for (int y = 0; y < vb.detail; ++y) {
            for (int z = 0; z < vb.detail; ++z) {
                for (int x = 0; x < vb.detail; ++x) {
                    int inPattern;
                    int inPlace = vb.get(x, y, z);
                    if (inPlace == (inPattern = pattern.get(x, y, z))) continue;
                    if (inPlace != 0 && chisel_bits && selected.isValid() && (chisel_to_air || inPattern != 0) && (spawnedItem = ItemChisel.chiselBlock(selected, player, vb, world, pos, side, x, y, z, spawnedItem, spawnlist)) != null) {
                        inPlace = 0;
                    }
                    if (inPlace != 0 || inPattern == 0 || filled.get(x, y, z) != 0) continue;
                    IItemInInventory bit = ModUtil.findBit(player, pos, inPattern);
                    if (ModUtil.consumeBagBit(bags, inPattern, 1) == 1) {
                        vb.set(x, y, z, inPattern);
                        continue;
                    }
                    if (!bit.isValid()) continue;
                    if (!player.isCreative()) {
                        if (!bit.consume()) continue;
                        vb.set(x, y, z, inPattern);
                        continue;
                    }
                    vb.set(x, y, z, inPattern);
                }
            }
        }
        BitInventoryFeeder feeder = new BitInventoryFeeder(who, world);
        for (EntityItem ei : spawnlist) {
            feeder.addItem(ei);
            ItemBitBag.cleanupInventory(who, ei.func_92059_d());
        }
    }

    public String getHighlightTip(ItemStack item, String displayName) {
        if (ChiselsAndBits.getConfig().itemNameModeDisplay) {
            return displayName + " - " + PositivePatternMode.getMode((ItemStack)item).string.getLocal();
        }
        return displayName;
    }
}

