/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.items;

import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import mod.chiselsandbits.bittank.BlockBitTank;
import mod.chiselsandbits.chiseledblock.BlockBitInfo;
import mod.chiselsandbits.chiseledblock.BlockChiseled;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled;
import mod.chiselsandbits.chiseledblock.data.BitLocation;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.core.ClientSide;
import mod.chiselsandbits.core.Log;
import mod.chiselsandbits.helpers.ActingPlayer;
import mod.chiselsandbits.helpers.BitOperation;
import mod.chiselsandbits.helpers.ChiselModeManager;
import mod.chiselsandbits.helpers.ChiselToolType;
import mod.chiselsandbits.helpers.DeprecationHelper;
import mod.chiselsandbits.helpers.IContinuousInventory;
import mod.chiselsandbits.helpers.IItemInInventory;
import mod.chiselsandbits.helpers.LocalStrings;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.interfaces.ICacheClearable;
import mod.chiselsandbits.interfaces.IChiselModeItem;
import mod.chiselsandbits.interfaces.IItemScrollWheel;
import mod.chiselsandbits.items.ItemBitBag;
import mod.chiselsandbits.items.ItemChisel;
import mod.chiselsandbits.modes.ChiselMode;
import mod.chiselsandbits.modes.IToolMode;
import mod.chiselsandbits.network.NetworkRouter;
import mod.chiselsandbits.network.packets.PacketChisel;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemChiseledBit
extends Item
implements IItemScrollWheel,
IChiselModeItem,
ICacheClearable {
    public static boolean bitBagStackLimitHack;
    private ArrayList<ItemStack> bits;
    private static Stopwatch timer;

    public ItemChiseledBit() {
        this.func_77627_a(true);
        ChiselsAndBits.getInstance().addClearable(this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag advanced) {
        super.func_77624_a(stack, worldIn, tooltip, advanced);
        ChiselsAndBits.getConfig().helpText(LocalStrings.HelpBit, tooltip, ClientSide.instance.getKeyName(Minecraft.func_71410_x().field_71474_y.field_74312_F), ClientSide.instance.getKeyName(Minecraft.func_71410_x().field_71474_y.field_74313_G), ClientSide.instance.getModeKey());
    }

    public String getHighlightTip(ItemStack item, String displayName) {
        if (ChiselsAndBits.getConfig().itemNameModeDisplay && FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            String extra = "";
            if (ItemChiseledBit.getBitOperation(ClientSide.instance.getPlayer(), EnumHand.MAIN_HAND, item) == BitOperation.REPLACE) {
                extra = " - " + LocalStrings.BitOptionReplace.getLocal();
            }
            return displayName + " - " + ChiselModeManager.getChiselMode(ClientSide.instance.getPlayer(), ChiselToolType.BIT, EnumHand.MAIN_HAND).getName().getLocal() + extra;
        }
        return displayName;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        return ItemChisel.fromBreakToChisel(ChiselMode.castMode(ChiselModeManager.getChiselMode(player, ChiselToolType.BIT, EnumHand.MAIN_HAND)), itemstack, pos, player, EnumHand.MAIN_HAND);
    }

    public static String getBitStateName(IBlockState state) {
        ItemStack target = null;
        Block blk = null;
        if (state == null) {
            return "Null";
        }
        try {
            blk = state.func_177230_c();
            Item item = Item.func_150898_a((Block)blk);
            if (ModUtil.isEmpty(item)) {
                Fluid f = BlockBitInfo.getFluidFromBlock(blk);
                if (f != null) {
                    return f.getLocalizedName(new FluidStack(f, 10));
                }
            } else {
                target = new ItemStack(blk, 1, blk.func_180651_a(state));
            }
        }
        catch (IllegalArgumentException e) {
            Log.logError("Unable to get Item Details for Bit.", e);
        }
        if (target == null || target.func_77973_b() == null) {
            return null;
        }
        try {
            String myName = target.func_82833_r();
            HashSet<String> extra = new HashSet<String>();
            if (blk != null && state != null) {
                for (IProperty p : state.func_177227_a()) {
                    if (!p.func_177701_a().equals("axis") && !p.func_177701_a().equals("facing")) continue;
                    extra.add(DeprecationHelper.translateToLocal("mod.chiselsandbits.pretty." + p.func_177701_a() + "-" + ((Comparable)state.func_177228_b().get((Object)p)).toString()));
                }
            }
            if (extra.isEmpty()) {
                return myName;
            }
            StringBuilder b = new StringBuilder(myName);
            for (String x : extra) {
                b.append(' ').append(x);
            }
            return b.toString();
        }
        catch (Exception e) {
            return "ERROR";
        }
    }

    public static String getBitTypeName(ItemStack stack) {
        return ItemChiseledBit.getBitStateName(ModUtil.getStateById(ItemChiseledBit.getStackState(stack)));
    }

    public String func_77653_i(ItemStack stack) {
        String typeName = ItemChiseledBit.getBitTypeName(stack);
        if (typeName == null) {
            return super.func_77653_i(stack);
        }
        return super.func_77653_i(stack) + " - " + typeName;
    }

    public int func_77639_j() {
        return bitBagStackLimitHack ? ChiselsAndBits.getConfig().bagStackSize : super.func_77639_j();
    }

    public EnumActionResult func_180614_a(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos usedBlock, @Nonnull EnumHand hand, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_175151_a(usedBlock, side, stack)) {
            return EnumActionResult.FAIL;
        }
        IBlockState usedState = world.func_180495_p(usedBlock);
        Block blk = usedState.func_177230_c();
        if (blk instanceof BlockBitTank) {
            if (blk.func_180639_a(world, usedBlock, usedState, player, hand, side, hitX, hitY, hitZ)) {
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.FAIL;
        }
        if (world.field_72995_K) {
            IToolMode mode = ChiselModeManager.getChiselMode(player, ClientSide.instance.getHeldToolType(hand), hand);
            BitLocation bitLocation = new BitLocation(new RayTraceResult(RayTraceResult.Type.BLOCK, new Vec3d((double)hitX, (double)hitY, (double)hitZ), side, usedBlock), false, ItemChiseledBit.getBitOperation(player, hand, stack));
            IBlockState blkstate = world.func_180495_p(bitLocation.blockPos);
            TileEntityBlockChiseled tebc = ModUtil.getChiseledTileEntity(world, bitLocation.blockPos, true);
            BlockChiseled.ReplaceWithChisledValue rv = null;
            if (tebc == null) {
                rv = BlockChiseled.replaceWithChisled(world, bitLocation.blockPos, blkstate, ItemChiseledBit.getStackState(stack), true);
                if (rv.success) {
                    blkstate = world.func_180495_p(bitLocation.blockPos);
                    tebc = rv.te;
                }
            }
            if (tebc != null) {
                PacketChisel pc = null;
                if (mode == ChiselMode.DRAWN_REGION) {
                    if (world.field_72995_K) {
                        ClientSide.instance.pointAt(ItemChiseledBit.getBitOperation(player, hand, stack).getToolType(), bitLocation, hand);
                    }
                    return EnumActionResult.FAIL;
                }
                pc = new PacketChisel(ItemChiseledBit.getBitOperation(player, hand, stack), bitLocation, side, ChiselMode.castMode(mode), hand);
                int result = pc.doAction(player);
                if (result > 0) {
                    NetworkRouter.instance.sendToServer(pc);
                }
            }
        }
        return EnumActionResult.SUCCESS;
    }

    public boolean canHarvestBlock(IBlockState blk, ItemStack stack) {
        return blk.func_177230_c() instanceof BlockChiseled || super.canHarvestBlock(blk, stack);
    }

    public boolean func_150897_b(IBlockState blk) {
        return blk.func_177230_c() instanceof BlockChiseled || super.func_150897_b(blk);
    }

    public static BitOperation getBitOperation(EntityPlayer player, EnumHand hand, ItemStack stack) {
        return ChiselsAndBits.getConfig().replaceingBits ? BitOperation.REPLACE : BitOperation.PLACE;
    }

    @Override
    public void clearCache() {
        this.bits = null;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList subItems) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        if (this.bits == null) {
            this.bits = new ArrayList();
            NonNullList List2 = NonNullList.func_191196_a();
            BitSet used = new BitSet(4096);
            for (Object obj : Item.field_150901_e) {
                if (!(obj instanceof ItemBlock)) continue;
                try {
                    Item it = (Item)obj;
                    CreativeTabs ctab = it.func_77640_w();
                    if (ctab != null) {
                        it.func_150895_a(ctab, List2);
                    }
                    for (ItemStack out : List2) {
                        IBlockState state;
                        it = out.func_77973_b();
                        if (!(it instanceof ItemBlock) || (state = DeprecationHelper.getStateFromItem(out)) == null || !BlockBitInfo.supportsBlock(state)) continue;
                        used.set(ModUtil.getStateId(state));
                        this.bits.add(ItemChiseledBit.createStack(ModUtil.getStateId(state), 1, false));
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                List2.clear();
            }
            for (Fluid o : FluidRegistry.getRegisteredFluids().values()) {
                if (!o.canBePlacedInWorld() || o.getBlock() == null || used.get(Block.func_176210_f((IBlockState)o.getBlock().func_176223_P()))) continue;
                this.bits.add(ItemChiseledBit.createStack(Block.func_176210_f((IBlockState)o.getBlock().func_176223_P()), 1, false));
            }
        }
        subItems.addAll(this.bits);
    }

    public static boolean sameBit(ItemStack output, int blk) {
        return output.func_77942_o() ? ItemChiseledBit.getStackState(output) == blk : false;
    }

    @Nonnull
    public static ItemStack createStack(int id, int count, boolean RequireStack) {
        if (ChiselsAndBits.getItems().itemBlockBit == null && !RequireStack) {
            return ModUtil.getEmptyStack();
        }
        ItemStack out = new ItemStack((Item)ChiselsAndBits.getItems().itemBlockBit, count);
        out.func_77983_a("id", (NBTBase)new NBTTagInt(id));
        return out;
    }

    @Override
    public void scroll(EntityPlayer player, ItemStack stack, int dwheel) {
        IToolMode mode = ChiselModeManager.getChiselMode(player, ChiselToolType.BIT, EnumHand.MAIN_HAND);
        ChiselModeManager.scrollOption(ChiselToolType.BIT, mode, mode, dwheel);
    }

    public static int getStackState(ItemStack inHand) {
        return inHand != null && inHand.func_77942_o() ? ModUtil.getTagCompound(inHand).func_74762_e("id") : 0;
    }

    public static boolean placeBit(IContinuousInventory bits, ActingPlayer player, VoxelBlob vb, int x, int y, int z) {
        if (vb.get(x, y, z) == 0) {
            IItemInInventory slot = bits.getItem(0);
            int stateID = ItemChiseledBit.getStackState(slot.getStack());
            if (slot.isValid()) {
                if (!player.isCreative()) {
                    if (bits.useItem(stateID)) {
                        vb.set(x, y, z, stateID);
                    }
                } else {
                    vb.set(x, y, z, stateID);
                }
            }
            return true;
        }
        return false;
    }

    public static boolean hasBitSpace(EntityPlayer player, int blk) {
        List<ItemBitBag.BagPos> bags = ItemBitBag.getBags((IInventory)player.field_71071_by);
        for (ItemBitBag.BagPos bp : bags) {
            for (int x = 0; x < bp.inv.func_70302_i_(); ++x) {
                ItemStack is = bp.inv.func_70301_a(x);
                if ((!ItemChiseledBit.sameBit(is, blk) || ModUtil.getStackSize(is) >= bp.inv.func_70297_j_()) && !ModUtil.isEmpty(is)) continue;
                return true;
            }
        }
        for (int x = 0; x < 36; ++x) {
            ItemStack is = player.field_71071_by.func_70301_a(x);
            if ((!ItemChiseledBit.sameBit(is, blk) || ModUtil.getStackSize(is) >= is.func_77976_d()) && !ModUtil.isEmpty(is)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkRequiredSpace(EntityPlayer player, IBlockState blkstate) {
        int stateId;
        if (ChiselsAndBits.getConfig().requireBagSpace && !player.func_184812_l_() && !ItemChiseledBit.hasBitSpace(player, stateId = ModUtil.getStateId(blkstate))) {
            if (player.field_70170_p.field_72995_K && (timer == null || timer.elapsed(TimeUnit.MILLISECONDS) > 1000L)) {
                timer = Stopwatch.createStarted();
                player.func_145747_a((ITextComponent)new TextComponentTranslation("mod.chiselsandbits.result.require_bag", new Object[0]));
            }
            return true;
        }
        return false;
    }
}

