/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.integration;

import java.util.ArrayList;
import java.util.List;
import mod.chiselsandbits.api.ChiselsAndBitsAddon;
import mod.chiselsandbits.api.IChiselsAndBitsAddon;
import mod.chiselsandbits.core.Log;
import mod.chiselsandbits.integration.ChiselsAndBitsIntegration;
import mod.chiselsandbits.integration.IntegrationBase;
import mod.chiselsandbits.integration.mods.PluginAPIWrapper;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class Integration {
    private final List<IntegrationBase> integrations = new ArrayList<IntegrationBase>();

    public void preinit(FMLPreInitializationEvent event) {
        for (ASMDataTable.ASMData asmData : event.getAsmData().getAll(ChiselsAndBitsAddon.class.getName())) {
            try {
                Class<?> asmClass = Class.forName(asmData.getClassName());
                Class<IChiselsAndBitsAddon> asmInstanceClass = asmClass.asSubclass(IChiselsAndBitsAddon.class);
                IChiselsAndBitsAddon instance = asmInstanceClass.newInstance();
                this.integrations.add(new PluginAPIWrapper(instance));
            }
            catch (Exception e) {
                Log.logError("Failed to create instance of " + asmData.getClassName() + " as IChiselsAndBitsAddon, Please forward this to the developer of " + asmData.getClassName(), e);
            }
        }
        for (ASMDataTable.ASMData asmData : event.getAsmData().getAll(ChiselsAndBitsIntegration.class.getName())) {
            Object modID = asmData.getAnnotationInfo().get("value");
            if (!(modID instanceof String) || !Loader.isModLoaded((String)((String)modID))) continue;
            try {
                Class<?> asmClass = Class.forName(asmData.getClassName());
                Class<IntegrationBase> asmInstanceClass = asmClass.asSubclass(IntegrationBase.class);
                IntegrationBase instance = asmInstanceClass.newInstance();
                this.integrations.add(instance);
            }
            catch (Exception e) {
                Log.logError("Failed to load: " + asmData.getClassName(), e);
            }
        }
        for (IntegrationBase i : this.integrations) {
            i.preinit();
        }
    }

    public void init() {
        for (IntegrationBase i : this.integrations) {
            i.init();
        }
    }

    public void postinit() {
        for (IntegrationBase i : this.integrations) {
            i.postinit();
        }
    }
}

