/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseledblock.iterators;

import mod.chiselsandbits.chiseledblock.data.IntegerBox;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.chiseledblock.iterators.ChiselIterator;
import net.minecraft.util.math.AxisAlignedBB;

public abstract class BaseChiselIterator
implements ChiselIterator {
    @Override
    public IntegerBox getVoxelBox(VoxelBlob vb, boolean boundSolids) {
        IntegerBox box = new IntegerBox(0, 0, 0, 0, 0, 0);
        boolean started = false;
        while (this.hasNext()) {
            if (vb.get(this.x(), this.y(), this.z()) != 0 != boundSolids) continue;
            if (started) {
                box.minX = Math.min(box.minX, this.x());
                box.minY = Math.min(box.minY, this.y());
                box.minZ = Math.min(box.minZ, this.z());
                box.maxX = Math.max(box.maxX, this.x());
                box.maxY = Math.max(box.maxY, this.y());
                box.maxZ = Math.max(box.maxZ, this.z());
                continue;
            }
            started = true;
            box.minX = this.x();
            box.minY = this.y();
            box.minZ = this.z();
            box.maxX = this.x();
            box.maxY = this.y();
            box.maxZ = this.z();
        }
        if (started) {
            return box;
        }
        return null;
    }

    @Override
    public AxisAlignedBB getBoundingBox(VoxelBlob vb, boolean boundSolids) {
        float One16thf = 1.0f / (float)vb.detail;
        IntegerBox box = this.getVoxelBox(vb, boundSolids);
        if (box != null) {
            return new AxisAlignedBB((double)((float)box.minX * One16thf), (double)((float)box.minY * One16thf), (double)((float)box.minZ * One16thf), (double)((float)(box.maxX + 1) * One16thf), (double)((float)(box.maxY + 1) * One16thf), (double)((float)(box.maxZ + 1) * One16thf));
        }
        return null;
    }
}

