/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.world.worldgen.trees.overworld;

import com.progwml6.natura.common.config.Config;
import com.progwml6.natura.overworld.NaturaOverworld;
import com.progwml6.natura.world.worldgen.trees.BaseTreeGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.IPlantable;

public class WillowTreeGenerator
extends BaseTreeGenerator {
    public final int minTreeHeight;
    public final int treeHeightRange;
    public final IBlockState log;
    public final IBlockState leaves;
    public final boolean seekHeight;
    public final boolean isSapling;

    public WillowTreeGenerator(int treeHeight, int treeRange, IBlockState log, IBlockState leaves, boolean seekHeight, boolean isSapling) {
        this.minTreeHeight = treeHeight;
        this.treeHeightRange = treeRange;
        this.log = log;
        this.leaves = leaves;
        this.seekHeight = seekHeight;
        this.isSapling = isSapling;
    }

    public WillowTreeGenerator(int treeHeight, int treeRange, IBlockState log, IBlockState leaves) {
        this(treeHeight, treeRange, log, leaves, true, false);
    }

    @Override
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
    }

    @Override
    public void generateTree(Random random, World worldIn, BlockPos position) {
        if (this.seekHeight && (position = this.findGround(worldIn, position)).func_177956_o() < 0) {
            return;
        }
        int height = random.nextInt(this.treeHeightRange) + this.minTreeHeight;
        while (worldIn.func_180495_p(position.func_177977_b()).func_185904_a() == Material.field_151586_h) {
            position = position.func_177977_b();
        }
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + height + 1 <= 128) {
            BlockPos down;
            IBlockState state;
            boolean isSoil;
            for (int j = position.func_177956_o(); j <= position.func_177956_o() + 1 + height; ++j) {
                int k = 1;
                if (j == position.func_177956_o()) {
                    k = 0;
                }
                if (j >= position.func_177956_o() + 1 + height - 2) {
                    k = 3;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = position.func_177958_n() - k; l <= position.func_177958_n() + k && flag; ++l) {
                    for (int i1 = position.func_177952_p() - k; i1 <= position.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < 128) {
                            IBlockState iblockstate = worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1));
                            Block block = iblockstate.func_177230_c();
                            if (iblockstate.func_177230_c().isAir(iblockstate, (IBlockAccess)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1)) || iblockstate.func_177230_c().isLeaves(iblockstate, (IBlockAccess)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1))) continue;
                            if (block != Blocks.field_150355_j && block != Blocks.field_150358_i) {
                                flag = false;
                                continue;
                            }
                            if (j <= position.func_177956_o()) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (flag && (isSoil = (state = worldIn.func_180495_p(down = position.func_177977_b())).func_177230_c().canSustainPlant(state, (IBlockAccess)worldIn, down, EnumFacing.UP, (IPlantable)NaturaOverworld.overworldSapling2)) && position.func_177956_o() < 128 - height - 1) {
                state.func_177230_c().onPlantGrow(state, worldIn, position.func_177977_b(), position);
                for (int k1 = position.func_177956_o() - 3 + height; k1 <= position.func_177956_o() + height; ++k1) {
                    int j2 = k1 - (position.func_177956_o() + height);
                    int l2 = 2 - j2 / 2;
                    for (int j3 = position.func_177958_n() - l2; j3 <= position.func_177958_n() + l2; ++j3) {
                        int k3 = j3 - position.func_177958_n();
                        for (int i4 = position.func_177952_p() - l2; i4 <= position.func_177952_p() + l2; ++i4) {
                            BlockPos blockpos;
                            int j1 = i4 - position.func_177952_p();
                            if (Math.abs(k3) == l2 && Math.abs(j1) == l2 && (random.nextInt(2) == 0 || j2 == 0) || !(state = worldIn.func_180495_p(blockpos = new BlockPos(j3, k1, i4))).func_177230_c().canBeReplacedByLeaves(state, (IBlockAccess)worldIn, blockpos)) continue;
                            this.setBlockAndMetadata(worldIn, blockpos, this.leaves);
                        }
                    }
                }
                for (int l1 = 0; l1 < height; ++l1) {
                    BlockPos upN = position.func_177981_b(l1);
                    IBlockState iblockstate1 = worldIn.func_180495_p(upN);
                    Block block2 = iblockstate1.func_177230_c();
                    if (!block2.isAir(iblockstate1, (IBlockAccess)worldIn, upN) && !block2.isLeaves(iblockstate1, (IBlockAccess)worldIn, upN) && !block2.func_176200_f((IBlockAccess)worldIn, upN) && block2 != Blocks.field_150358_i && block2 != Blocks.field_150355_j) continue;
                    this.setBlockAndMetadata(worldIn, position.func_177981_b(l1), this.log);
                }
                for (int i2 = position.func_177956_o() - 3 + height; i2 <= position.func_177956_o() + height; ++i2) {
                    int k2 = i2 - (position.func_177956_o() + height);
                    int i3 = 2 - k2 / 2;
                    BlockPos.MutableBlockPos blockpos$mutableblockpos1 = new BlockPos.MutableBlockPos();
                    for (int l3 = position.func_177958_n() - i3; l3 <= position.func_177958_n() + i3; ++l3) {
                        for (int j4 = position.func_177952_p() - i3; j4 <= position.func_177952_p() + i3; ++j4) {
                            blockpos$mutableblockpos1.func_181079_c(l3, i2, j4);
                            if (worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos1).func_185904_a() != Material.field_151584_j) continue;
                            BlockPos blockpos3 = blockpos$mutableblockpos1.func_177976_e();
                            BlockPos blockpos4 = blockpos$mutableblockpos1.func_177974_f();
                            BlockPos blockpos1 = blockpos$mutableblockpos1.func_177978_c();
                            BlockPos blockpos2 = blockpos$mutableblockpos1.func_177968_d();
                            if (random.nextInt(4) == 0 && this.isAir(worldIn, blockpos3)) {
                                this.addDownLeaves(worldIn, blockpos3);
                            }
                            if (random.nextInt(4) == 0 && this.isAir(worldIn, blockpos4)) {
                                this.addDownLeaves(worldIn, blockpos4);
                            }
                            if (random.nextInt(4) == 0 && this.isAir(worldIn, blockpos1)) {
                                this.addDownLeaves(worldIn, blockpos1);
                            }
                            if (random.nextInt(4) != 0 || !this.isAir(worldIn, blockpos2)) continue;
                            this.addDownLeaves(worldIn, blockpos2);
                        }
                    }
                }
            }
        }
    }

    BlockPos findGround(World world, BlockPos pos) {
        int returnHeight = 0;
        int height = pos.func_177956_o();
        if (world.func_175624_G() == WorldType.field_77138_c && this.isSapling) {
            do {
                BlockPos position;
                Block block;
                if ((block = world.func_180495_p(position = new BlockPos(pos.func_177958_n(), height, pos.func_177952_p())).func_177230_c()) != Blocks.field_150346_d && block != Blocks.field_150349_c && block != Blocks.field_150354_m || world.func_180495_p(position.func_177984_a()).func_185913_b()) continue;
                returnHeight = height + 1;
                break;
            } while (--height > Config.flatSeaLevel);
            return new BlockPos(pos.func_177958_n(), returnHeight, pos.func_177952_p());
        }
        do {
            BlockPos position;
            Block block;
            if ((block = world.func_180495_p(position = new BlockPos(pos.func_177958_n(), height, pos.func_177952_p())).func_177230_c()) != Blocks.field_150346_d && block != Blocks.field_150349_c && block != Blocks.field_150354_m || world.func_180495_p(position.func_177984_a()).func_185913_b()) continue;
            returnHeight = height + 1;
            break;
        } while (--height > Config.seaLevel);
        return new BlockPos(pos.func_177958_n(), returnHeight, pos.func_177952_p());
    }

    private void addDownLeaves(World worldIn, BlockPos pos) {
        this.setBlockAndMetadata(worldIn, pos, this.leaves);
        pos = pos.func_177977_b();
        for (int i = 4; this.isAir(worldIn, pos) && i > 0; --i) {
            this.setBlockAndMetadata(worldIn, pos, this.leaves);
            pos = pos.func_177977_b();
        }
    }

    protected void setBlockAndMetadata(World world, BlockPos pos, IBlockState stateNew) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block.isAir(state, (IBlockAccess)world, pos) || block.func_176196_c(world, pos) || world.func_180495_p(pos) == this.leaves) {
            world.func_180501_a(pos, stateNew, 2);
        }
    }

    private boolean isAir(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c().isAir(state, (IBlockAccess)world, pos);
    }
}

