/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.world.worldgen.berry.nether;

import com.progwml6.natura.common.block.BlockEnumBerryBush;
import com.progwml6.natura.world.worldgen.berry.BaseBerryBushGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class NetherBerryBushGenerator
extends BaseBerryBushGenerator {
    public final IBlockState berryBush;

    public NetherBerryBushGenerator(IBlockState berryBush) {
        this.berryBush = berryBush;
    }

    @Override
    public void generateBush(Random random, World world, BlockPos pos) {
        if ((pos = this.findGround(world, pos)).func_177956_o() < 0) {
            return;
        }
        int yPos = pos.func_177956_o();
        if (yPos >= 1) {
            int size = random.nextInt(10);
            if (size == 9) {
                this.generateLargeNode(random, world, pos);
            } else if (size >= 7) {
                this.generateShrub(random, world, pos);
            } else if (size >= 3) {
                this.generateSmallNode(random, world, pos);
            } else {
                this.generateTinyNode(random, world, pos);
            }
        }
    }

    protected void generateLargeNode(Random random, World world, BlockPos pos) {
        BlockPos blockpos;
        int iterY;
        int iterZ;
        int iterX;
        for (iterX = pos.func_177958_n() - 2; iterX <= pos.func_177958_n() + 2; ++iterX) {
            for (iterZ = pos.func_177952_p() - 1; iterZ <= pos.func_177952_p() + 1; ++iterZ) {
                for (iterY = pos.func_177956_o() - 1; iterY <= pos.func_177956_o(); ++iterY) {
                    blockpos = new BlockPos(iterX, iterY, iterZ);
                    this.setBlockAndMetadata(random, world, blockpos, this.berryBush.func_177226_a((IProperty)BlockEnumBerryBush.AGE, (Comparable)Integer.valueOf(this.randomFullAge(random))));
                }
            }
        }
        for (iterX = pos.func_177958_n() - 1; iterX <= pos.func_177958_n() + 1; ++iterX) {
            for (iterZ = pos.func_177952_p() - 2; iterZ <= pos.func_177952_p() - 2; ++iterZ) {
                for (iterY = pos.func_177956_o() - 1; iterY <= pos.func_177956_o(); ++iterY) {
                    blockpos = new BlockPos(iterX, iterY, iterZ);
                    this.setBlockAndMetadata(random, world, blockpos, this.berryBush.func_177226_a((IProperty)BlockEnumBerryBush.AGE, (Comparable)Integer.valueOf(this.randomFullAge(random))));
                }
            }
        }
        for (iterX = pos.func_177958_n() - 1; iterX <= pos.func_177958_n() + 1; ++iterX) {
            for (iterZ = pos.func_177952_p() + 2; iterZ <= pos.func_177952_p() + 2; ++iterZ) {
                for (iterY = pos.func_177956_o() - 1; iterY <= pos.func_177956_o(); ++iterY) {
                    blockpos = new BlockPos(iterX, iterY, iterZ);
                    this.setBlockAndMetadata(random, world, blockpos, this.berryBush.func_177226_a((IProperty)BlockEnumBerryBush.AGE, (Comparable)Integer.valueOf(this.randomFullAge(random))));
                }
            }
        }
        for (iterX = pos.func_177958_n() - 1; iterX <= pos.func_177958_n() + 1; ++iterX) {
            for (iterZ = pos.func_177952_p() - 1; iterZ <= pos.func_177952_p() + 1; ++iterZ) {
                int yPos = pos.func_177956_o() + 1;
                blockpos = new BlockPos(iterX, yPos, iterZ);
                this.setBlockAndMetadata(random, world, blockpos, this.berryBush.func_177226_a((IProperty)BlockEnumBerryBush.AGE, (Comparable)Integer.valueOf(this.randomFullAge(random))));
                yPos = pos.func_177956_o() - 2;
                blockpos = new BlockPos(iterX, yPos, iterZ);
                this.setBlockAndMetadata(random, world, blockpos, this.berryBush.func_177226_a((IProperty)BlockEnumBerryBush.AGE, (Comparable)Integer.valueOf(this.randomFullAge(random))));
            }
        }
    }

    protected void generateShrub(Random random, World world, BlockPos pos) {
        IBlockState state;
        Block block;
        while (((block = (state = world.func_180495_p(pos)).func_177230_c()).isAir(state, (IBlockAccess)world, pos) || block.isLeaves(state, (IBlockAccess)world, pos)) && (pos = pos.func_177977_b()).func_177956_o() > 0) {
        }
        state = world.func_180495_p(pos);
        block = state.func_177230_c();
        if (block == Blocks.field_150424_aL || block == Blocks.field_150425_aM) {
            pos.func_177984_a();
            for (int y = pos.func_177956_o(); y <= pos.func_177956_o() + 2; ++y) {
                int subract = y - pos.func_177956_o();
                int subract2 = 2 - subract;
                for (int x = pos.func_177958_n() - subract2; x <= pos.func_177958_n() + subract2; ++x) {
                    int mathX = x - pos.func_177958_n();
                    for (int z = pos.func_177952_p() - subract2; z <= pos.func_177952_p() + subract2; ++z) {
                        int mathZ = z - pos.func_177952_p();
                        BlockPos blockpos = new BlockPos(x, y, z);
                        IBlockState blockState = world.func_180495_p(blockpos);
                        if (Math.abs(mathX) == subract2 && Math.abs(mathZ) == subract2 && (random.nextInt(2) == 0 || block != null && !block.canBeReplacedByLeaves(blockState, (IBlockAccess)world, blockpos))) continue;
                        this.setBlockAndMetadata(random, world, blockpos, this.berryBush.func_177226_a((IProperty)BlockEnumBerryBush.AGE, (Comparable)Integer.valueOf(this.randomFullAge(random))));
                    }
                }
            }
        }
    }

    protected void generateSmallNode(Random random, World world, BlockPos pos) {
        this.setBlockAndMetadata(random, world, pos, this.berryBush.func_177226_a((IProperty)BlockEnumBerryBush.AGE, (Comparable)Integer.valueOf(this.randomFullAge(random))));
        if (random.nextBoolean()) {
            this.setBlockAndMetadata(random, world, pos.func_177974_f(), this.berryBush.func_177226_a((IProperty)BlockEnumBerryBush.AGE, (Comparable)Integer.valueOf(this.randomAge(random))));
        }
        if (random.nextBoolean()) {
            this.setBlockAndMetadata(random, world, pos.func_177976_e(), this.berryBush.func_177226_a((IProperty)BlockEnumBerryBush.AGE, (Comparable)Integer.valueOf(this.randomAge(random))));
        }
        if (random.nextBoolean()) {
            this.setBlockAndMetadata(random, world, pos.func_177968_d(), this.berryBush.func_177226_a((IProperty)BlockEnumBerryBush.AGE, (Comparable)Integer.valueOf(this.randomAge(random))));
        }
        if (random.nextBoolean()) {
            this.setBlockAndMetadata(random, world, pos.func_177978_c(), this.berryBush.func_177226_a((IProperty)BlockEnumBerryBush.AGE, (Comparable)Integer.valueOf(this.randomAge(random))));
        }
    }

    protected void generateTinyNode(Random random, World world, BlockPos pos) {
        this.setBlockAndMetadata(random, world, pos, this.berryBush.func_177226_a((IProperty)BlockEnumBerryBush.AGE, (Comparable)Integer.valueOf(this.randomAge(random))));
    }

    protected void setBlockAndMetadata(Random random, World world, BlockPos pos, IBlockState stateNew) {
        if (!world.func_180495_p(pos).func_185914_p()) {
            world.func_180501_a(pos, stateNew, 2);
        }
    }

    BlockPos findGround(World world, BlockPos pos) {
        int returnHeight = -1;
        IBlockState downState = world.func_180495_p(pos.func_177977_b());
        Block downBlock = downState.func_177230_c();
        if (!(world.func_175623_d(pos.func_177977_b()) || world.func_180495_p(pos).func_185914_p() || downBlock != Blocks.field_150424_aL && !downBlock.canSustainPlant(downState, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this.berryBush.func_177230_c()))) {
            return pos;
        }
        int height = pos.func_177958_n();
        BlockPos position = new BlockPos(pos.func_177958_n(), height, pos.func_177952_p());
        do {
            IBlockState state = world.func_180495_p(position);
            Block block = state.func_177230_c();
            if (!world.func_175623_d(position) && (block == Blocks.field_150424_aL || block.canSustainPlant(state, (IBlockAccess)world, position, EnumFacing.UP, (IPlantable)this.berryBush.func_177230_c()))) {
                if (world.func_180495_p(position.func_177984_a()).func_185914_p()) break;
                returnHeight = height + 1;
                break;
            }
            position = position.func_177977_b();
        } while (--height > 0);
        return new BlockPos(pos.func_177958_n(), returnHeight, pos.func_177952_p());
    }

    int randomFullAge(Random random) {
        int fruiting = random.nextInt(5) == 0 ? 1 : 0;
        return 2 + fruiting;
    }

    int randomAge(Random random) {
        return random.nextInt(3);
    }
}

