/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.architecture.client.render.shape;

import com.elytradev.architecture.client.render.ICustomRenderer;
import com.elytradev.architecture.client.render.target.RenderTargetBase;
import com.elytradev.architecture.client.render.texture.ITexture;
import com.elytradev.architecture.client.render.texture.TextureBase;
import com.elytradev.architecture.common.helpers.Trans3;
import com.elytradev.architecture.common.helpers.Utils;
import com.elytradev.architecture.common.tile.TileShape;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class ShapeRenderDispatch
implements ICustomRenderer {
    @Override
    public void renderBlock(IBlockAccess world, BlockPos pos, IBlockState state, RenderTargetBase target, BlockRenderLayer layer, Trans3 t) {
        TileShape shape = TileShape.get(world, pos);
        if (shape != null) {
            Trans3 transform = t.t(shape.localToGlobalRotation());
            boolean renderBase = this.canRenderInLayer(shape.getBaseBlockState(), layer);
            boolean renderSecondary = this.canRenderInLayer(shape.getSecondaryBlockState(), layer);
            int baseColour = renderBase ? Utils.getColourFromState(shape.getBaseBlockState()) : -1;
            int secondaryColour = renderSecondary ? Utils.getColourFromState(shape.getSecondaryBlockState()) : baseColour;
            this.renderShapeTE(shape, target, transform, renderBase, renderSecondary, baseColour, secondaryColour);
        }
    }

    private boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        if (layer == null) {
            return true;
        }
        return state != null && state.func_177230_c().canRenderInLayer(state, layer);
    }

    @Override
    public void renderItemStack(ItemStack stack, RenderTargetBase target, Trans3 t) {
        TileShape te = new TileShape();
        te.readFromItemStack(stack);
        ItemColors itemColors = Minecraft.func_71410_x().getItemColors();
        ItemStack baseStack = this.getStackFromState(te.getBaseBlockState());
        ItemStack secondaryStack = this.getStackFromState(te.getSecondaryBlockState());
        int baseColour = baseStack != null ? itemColors.func_186728_a(baseStack, 0) : -1;
        int secondaryColour = secondaryStack != null ? itemColors.func_186728_a(secondaryStack, 0) : baseColour;
        this.renderShapeTE(te, target, t, te.hasBaseBlockState(), te.hasSecondaryBlockState(), baseColour, secondaryColour);
    }

    @Nullable
    public ItemStack getStackFromState(IBlockState state) {
        Item itemBlock = Item.func_150898_a((Block)state.func_177230_c());
        if (!Objects.equals(state.func_177230_c(), Blocks.field_150350_a)) {
            ItemStack defaultInstance = itemBlock.func_190903_i();
            defaultInstance.func_77964_b(state.func_177230_c().func_180651_a(state));
            return defaultInstance;
        }
        return ItemStack.field_190927_a;
    }

    public void renderShapeTE(TileShape te, RenderTargetBase target, Trans3 t, boolean renderBase, boolean renderSecondary, int baseColour, int secondaryColour) {
        IBlockState base;
        if (te.getShape() != null && (renderBase || renderSecondary) && (base = te.getBaseBlockState()) != null) {
            TextureAtlasSprite baseSprite = Utils.getSpriteForBlockState(base);
            TextureAtlasSprite secondarySprite = Utils.getSpriteForBlockState(te.getSecondaryBlockState());
            if (baseSprite != null) {
                ITexture[] textures = new ITexture[4];
                if (renderBase) {
                    textures[0] = TextureBase.fromSprite(baseSprite);
                    textures[1] = textures[0].projected();
                }
                if (renderSecondary) {
                    if (secondarySprite != null) {
                        textures[2] = TextureBase.fromSprite(secondarySprite);
                        textures[3] = textures[2].projected();
                    } else {
                        renderSecondary = false;
                    }
                }
                if (renderBase && te.getShape().kind.secondaryDefaultsToBase() && (secondarySprite == null || te.hasSecondaryBlockState() && te.getSecondaryBlockState().func_177230_c().func_180664_k() != BlockRenderLayer.SOLID)) {
                    textures[2] = textures[0];
                    textures[3] = textures[1];
                    renderSecondary = renderBase;
                }
                te.getShape().kind.renderShape(te, textures, target, t, renderBase, renderSecondary, baseColour, secondaryColour);
            }
        }
    }

    @Override
    public void renderBlock(IBlockAccess world, BlockPos pos, IBlockState state, RenderTargetBase target, BlockRenderLayer layer, Trans3 t, boolean renderBase, boolean renderSecondary) {
        TileShape shape = TileShape.get(world, pos);
        if (shape != null) {
            Trans3 t2 = t.t(shape.localToGlobalRotation());
            int baseColour = renderBase ? Utils.getColourFromState(shape.getBaseBlockState()) : -1;
            int secondaryColour = renderSecondary ? Utils.getColourFromState(shape.getBaseBlockState()) : baseColour;
            this.renderShapeTE(TileShape.get(world, pos), target, t2, renderBase, renderSecondary, baseColour, secondaryColour);
        }
    }
}

