/*
 * Decompiled with CFR 0.152.
 */
package com.cazsius.solcarrot.client;

import com.cazsius.solcarrot.SOLCarrotConfig;
import com.cazsius.solcarrot.lib.Localization;
import com.cazsius.solcarrot.tracking.FoodList;
import com.cazsius.solcarrot.tracking.ProgressInfo;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import squeek.applecore.api.AppleCoreAPI;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="solcarrot")
public final class TooltipHandler {
    private static boolean isValidFood(ItemStack itemStack) {
        return AppleCoreAPI.accessor.isFood(itemStack);
    }

    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        if (!SOLCarrotConfig.isFoodTooltipEnabled) {
            return;
        }
        if (event.getEntityPlayer() == null) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        ItemStack food = event.getItemStack();
        if (!TooltipHandler.isValidFood(food)) {
            return;
        }
        FoodList foodList = FoodList.get(player);
        ProgressInfo.ConfigInfo configInfo = foodList.getConfigInfo();
        boolean hasBeenEaten = foodList.hasEaten(food);
        boolean isAllowed = configInfo.isAllowed(food);
        boolean isHearty = configInfo.isHearty(food);
        List tooltip = event.getToolTip();
        if (!isAllowed) {
            if (hasBeenEaten) {
                tooltip.add(TextFormatting.DARK_RED + TooltipHandler.localizedTooltip("disabled.eaten"));
            }
            String key = configInfo.hasWhitelist() ? "whitelist" : "blacklist";
            tooltip.add(TextFormatting.DARK_GRAY + TooltipHandler.localizedTooltip("disabled." + key));
        } else if (isHearty) {
            if (hasBeenEaten) {
                tooltip.add(TextFormatting.DARK_GREEN + TooltipHandler.localizedTooltip("hearty.eaten"));
            } else {
                tooltip.add(TextFormatting.DARK_AQUA + TooltipHandler.localizedTooltip("hearty.not_eaten"));
            }
        } else {
            if (hasBeenEaten) {
                tooltip.add(TextFormatting.DARK_RED + TooltipHandler.localizedTooltip("cheap.eaten"));
            }
            tooltip.add(TextFormatting.DARK_GRAY + TooltipHandler.localizedTooltip("cheap"));
        }
    }

    private static String localizedTooltip(String path) {
        return Localization.localized("tooltip", path, new Object[0]);
    }

    private TooltipHandler() {
    }
}

