/*
 * Decompiled with CFR 0.152.
 */
package com.cazsius.solcarrot.client;

import com.cazsius.solcarrot.SOLCarrot;
import com.cazsius.solcarrot.tracking.ProgressInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import squeek.applecore.api.AppleCoreAPI;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="solcarrot")
public final class FoodItemStacks {
    private static List<ItemStack> foodsBeforeBlacklist;
    private static List<ItemStack> foods;

    public static List<ItemStack> getAllFoodsIgnoringBlacklist() {
        return new ArrayList<ItemStack>(foodsBeforeBlacklist);
    }

    public static List<ItemStack> getAllFoods() {
        return new ArrayList<ItemStack>(foods);
    }

    @SubscribeEvent
    public static void postInit(SOLCarrot.PostInitializationEvent event) {
        foodsBeforeBlacklist = ForgeRegistries.ITEMS.getValuesCollection().stream().flatMap(FoodItemStacks::getSubItems).filter(itemStack -> AppleCoreAPI.accessor.isFood(itemStack)).sorted(Comparator.comparing(ItemStack::func_77960_j)).sorted(Comparator.comparing(food -> I18n.func_135052_a((String)(food.func_77977_a() + ".name"), (Object[])new Object[0]))).collect(Collectors.toList());
        FoodItemStacks.applyBlacklist();
    }

    @SubscribeEvent
    public static void onPostConfigChanged(ConfigChangedEvent.PostConfigChangedEvent event) {
        if (!event.getModID().equals("solcarrot")) {
            return;
        }
        FoodItemStacks.applyBlacklist();
    }

    private static void applyBlacklist() {
        ProgressInfo.ConfigInfo configInfo = new ProgressInfo.ConfigInfo();
        foods = foodsBeforeBlacklist.stream().filter(configInfo::isAllowed).collect(Collectors.toList());
    }

    private static String getRegistryName(ItemStack itemStack) {
        ResourceLocation registryName = itemStack.func_77973_b().getRegistryName();
        assert (registryName != null);
        return registryName.toString();
    }

    private static Stream<ItemStack> getSubItems(Item item) {
        NonNullList subItems = NonNullList.func_191196_a();
        Arrays.stream(item.getCreativeTabs()).filter(Objects::nonNull).forEach(creativeTab -> item.func_150895_a(creativeTab, subItems));
        return subItems.stream();
    }

    private FoodItemStacks() {
    }
}

