/*
 * Decompiled with CFR 0.152.
 */
package amerifrance.guideapi.info;

import amerifrance.guideapi.api.IInfoRenderer;
import amerifrance.guideapi.api.impl.Book;
import amerifrance.guideapi.api.util.GuiHelper;
import java.awt.Color;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import org.apache.commons.lang3.StringEscapeUtils;

public class InfoRendererDescription
implements IInfoRenderer {
    private final ItemStack stack;
    private final ITextComponent description;
    private boolean tiny;
    private int yOffset;

    public InfoRendererDescription(ItemStack stack, ITextComponent description) {
        this.stack = stack;
        this.description = description;
    }

    @Override
    public void drawInformation(Book book, World world, BlockPos pos, IBlockState state, RayTraceResult rayTrace, EntityPlayer player) {
        String[] lines;
        if (this.tiny) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        }
        ScaledResolution resolution = new ScaledResolution(Minecraft.func_71410_x());
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int scaleMulti = this.tiny ? 2 : 1;
        GuiHelper.drawItemStack(this.stack, (resolution.func_78326_a() / 2 + 55) * scaleMulti, (resolution.func_78328_b() / 2 - (this.tiny ? 20 : 30) + this.yOffset) * scaleMulti);
        int y = 0;
        String toDraw = StringEscapeUtils.unescapeJava((String)this.description.func_150254_d()).replaceAll("\\t", "     ");
        for (String line : lines = toDraw.split("\n")) {
            List cutLines = fontRenderer.func_78271_c(line, 100 * scaleMulti);
            for (String cut : cutLines) {
                fontRenderer.func_175063_a(cut, (float)((resolution.func_78326_a() / 2 + 20) * scaleMulti), (float)((resolution.func_78328_b() / 2 - 10 - y) * scaleMulti + this.yOffset), Color.WHITE.getRGB());
                y -= 10 / scaleMulti;
            }
        }
        if (this.tiny) {
            GlStateManager.func_179121_F();
        }
    }

    public InfoRendererDescription setTiny(boolean tiny) {
        this.tiny = tiny;
        return this;
    }

    public InfoRendererDescription setOffsetY(int yOffset) {
        this.yOffset = yOffset;
        return this;
    }
}

