/*
 * Decompiled with CFR 0.152.
 */
package amerifrance.guideapi.api.impl.abstraction;

import amerifrance.guideapi.api.impl.Book;
import amerifrance.guideapi.api.impl.abstraction.EntryAbstract;
import amerifrance.guideapi.api.util.TextHelper;
import amerifrance.guideapi.gui.GuiBase;
import amerifrance.guideapi.gui.GuiHome;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class CategoryAbstract {
    public final Map<ResourceLocation, EntryAbstract> entries;
    public final String name;
    private String keyBase;

    public CategoryAbstract(Map<ResourceLocation, EntryAbstract> entries, String name) {
        this.entries = entries;
        this.name = name;
    }

    public CategoryAbstract(String name) {
        this(Maps.newLinkedHashMap(), name);
    }

    public void addEntry(ResourceLocation key, EntryAbstract entry) {
        this.entries.put(key, entry);
    }

    public void addEntry(String key, EntryAbstract entry) {
        if (Strings.isNullOrEmpty((String)this.keyBase)) {
            throw new RuntimeException("keyBase in category with name '" + this.name + "' must be set.");
        }
        this.addEntry(new ResourceLocation(this.keyBase, key), entry);
    }

    public void removeEntry(ResourceLocation key) {
        this.entries.remove(key);
    }

    public void addEntries(Map<ResourceLocation, EntryAbstract> entries) {
        this.entries.putAll(entries);
    }

    public void removeEntries(List<ResourceLocation> keys) {
        for (ResourceLocation key : keys) {
            if (!this.entries.containsKey(key)) continue;
            this.entries.remove(key);
        }
    }

    public EntryAbstract getEntry(ResourceLocation key) {
        return this.entries.get(key);
    }

    public EntryAbstract getEntry(String key) {
        if (Strings.isNullOrEmpty((String)this.keyBase)) {
            throw new RuntimeException("keyBase in category with name '" + this.name + "' must be set.");
        }
        return this.getEntry(new ResourceLocation(this.keyBase, key));
    }

    public CategoryAbstract withKeyBase(String keyBase) {
        this.keyBase = keyBase;
        return this;
    }

    public String getLocalizedName() {
        return TextHelper.localizeEffect(this.name, new Object[0]);
    }

    public List<String> getTooltip() {
        return Lists.newArrayList((Object[])new String[]{this.getLocalizedName()});
    }

    @SideOnly(value=Side.CLIENT)
    public abstract void draw(Book var1, int var2, int var3, int var4, int var5, int var6, int var7, GuiBase var8, boolean var9, RenderItem var10);

    @SideOnly(value=Side.CLIENT)
    public abstract void drawExtras(Book var1, int var2, int var3, int var4, int var5, int var6, int var7, GuiBase var8, boolean var9, RenderItem var10);

    public abstract boolean canSee(EntityPlayer var1, ItemStack var2);

    @SideOnly(value=Side.CLIENT)
    public abstract void onLeftClicked(Book var1, int var2, int var3, EntityPlayer var4, ItemStack var5);

    @SideOnly(value=Side.CLIENT)
    public abstract void onRightClicked(Book var1, int var2, int var3, EntityPlayer var4, ItemStack var5);

    @SideOnly(value=Side.CLIENT)
    public abstract void onInit(Book var1, GuiHome var2, EntityPlayer var3, ItemStack var4);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CategoryAbstract that = (CategoryAbstract)o;
        if (this.entries != null ? !this.entries.equals(that.entries) : that.entries != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.entries != null ? this.entries.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }
}

