/*
 * Decompiled with CFR 0.152.
 */
package portablejim.bbw.shims;

import java.util.ArrayList;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import portablejim.bbw.BetterBuildersWandsMod;
import portablejim.bbw.api.IContainerHandlerSpecial;
import portablejim.bbw.basics.Point3d;
import portablejim.bbw.containers.ContainerManager;
import portablejim.bbw.core.items.IWandItem;
import portablejim.bbw.shims.IPlayerShim;
import vazkii.botania.api.item.IBlockProvider;

public class BasicPlayerShim
implements IPlayerShim {
    private EntityPlayer player;
    private boolean providersEnabled;
    protected float assumedReachDistance;

    public BasicPlayerShim(EntityPlayer player) {
        this.player = player;
        this.providersEnabled = BasicPlayerShim.areProvidersEnabled();
        this.assumedReachDistance = 4.5f;
    }

    public static Block getBlock(ItemStack stack) {
        return Block.func_149634_a((Item)stack.func_77973_b());
    }

    public static int getBlockMeta(ItemStack stack) {
        return stack.func_77981_g() ? stack.func_77952_i() : 0;
    }

    private static boolean areProvidersEnabled() {
        try {
            boolean disable = new Object() instanceof IBlockProvider;
            return true;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    @Override
    public int countItems(ItemStack itemStack) {
        int total = 0;
        if (itemStack == null || this.player.field_71071_by == null || this.player.field_71071_by.field_70462_a == null) {
            return 0;
        }
        ContainerManager containerManager = BetterBuildersWandsMod.instance.containerManager;
        Map<IContainerHandlerSpecial, Object> containerState = containerManager.initCount(this.player);
        Block block = BasicPlayerShim.getBlock(itemStack);
        int meta = BasicPlayerShim.getBlockMeta(itemStack);
        for (ItemStack inventoryStack : this.player.field_71071_by.field_70462_a) {
            if (inventoryStack != null && itemStack.func_77969_a(inventoryStack)) {
                total += Math.max(0, inventoryStack.func_190916_E());
                continue;
            }
            total += containerManager.countItems(containerState, this.player, itemStack, inventoryStack);
        }
        return itemStack.func_190916_E() > 0 ? (total += containerManager.finalCount(containerState)) / itemStack.func_190916_E() : 0;
    }

    @Override
    public boolean useItem(ItemStack itemStack) {
        if (itemStack == null || this.player.field_71071_by == null || this.player.field_71071_by.field_70462_a == null) {
            return false;
        }
        ContainerManager containerManager = BetterBuildersWandsMod.instance.containerManager;
        Map<IContainerHandlerSpecial, Object> containerState = containerManager.initUse(this.player);
        int toUse = itemStack.func_190916_E();
        ArrayList providers = new ArrayList();
        for (int i = this.player.field_71071_by.field_70462_a.size() - 1; i >= 0; --i) {
            ItemStack inventoryStack = (ItemStack)this.player.field_71071_by.field_70462_a.get(i);
            if (inventoryStack != null && itemStack.func_77969_a(inventoryStack)) {
                if (inventoryStack.func_190916_E() < toUse) {
                    inventoryStack.func_190920_e(0);
                    toUse -= inventoryStack.func_190916_E();
                } else {
                    inventoryStack.func_190920_e(inventoryStack.func_190916_E() - toUse);
                    toUse = 0;
                }
                if (inventoryStack.func_190916_E() == 0) {
                    this.player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
                }
                this.player.field_71069_bz.func_75142_b();
            } else {
                toUse = containerManager.useItems(containerState, this.player, itemStack, inventoryStack, toUse);
            }
            toUse = containerManager.finalUse(containerState, toUse);
            if (toUse > 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public ItemStack getNextItem(Block block, int meta) {
        for (int i = this.player.field_71071_by.field_70462_a.size() - 1; i >= 0; --i) {
            ItemStack itemStack = (ItemStack)this.player.field_71071_by.field_70462_a.get(i);
        }
        return null;
    }

    @Override
    public Point3d getPlayerPosition() {
        return new Point3d((int)this.player.field_70165_t, (int)this.player.field_70163_u, (int)this.player.field_70161_v);
    }

    @Override
    public EntityPlayer getPlayer() {
        return this.player;
    }

    @Override
    public ItemStack getHeldWandIfAny() {
        return BasicPlayerShim.getHeldWandIfAny(this.player);
    }

    public static ItemStack getHeldWandIfAny(EntityPlayer player) {
        ItemStack wandItem = null;
        if (player.func_184586_b(EnumHand.MAIN_HAND) != null && player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof IWandItem) {
            wandItem = player.func_184586_b(EnumHand.MAIN_HAND);
        } else if (player.func_184586_b(EnumHand.OFF_HAND) != null && player.func_184586_b(EnumHand.OFF_HAND).func_77973_b() instanceof IWandItem) {
            wandItem = player.func_184586_b(EnumHand.OFF_HAND);
        }
        return wandItem;
    }

    @Override
    public boolean isCreative() {
        return this.player.field_71075_bZ.field_75098_d;
    }

    @Override
    public double getReachDistance() {
        if (this.player instanceof EntityPlayerMP) {
            return ((EntityPlayerMP)this.player).field_71134_c.getBlockReachDistance();
        }
        return this.assumedReachDistance;
    }
}

