/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.transfernodes;

import com.rwtema.extrautils2.backend.XUItemBlock;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.transfernodes.BlockTransferHolder;
import com.rwtema.extrautils2.transfernodes.TileTransferHolder;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemBlockPipe
extends XUItemBlock {
    public ItemBlockPipe(Block block) {
        super(block);
    }

    @Override
    @Nonnull
    public EnumActionResult onItemUse(ItemStack stack, @Nonnull EntityPlayer playerIn, World worldIn, @Nonnull BlockPos pos, EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (StackHelper.isNull(stack) || StackHelper.isEmpty(stack)) {
            return EnumActionResult.FAIL;
        }
        if (!playerIn.func_175151_a(pos, facing, stack)) {
            return EnumActionResult.FAIL;
        }
        if (worldIn.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        if (!BlockTransferHolder.placePipe(worldIn, pos, playerIn) && !BlockTransferHolder.placePipe(worldIn, pos.func_177972_a(facing), playerIn)) {
            return EnumActionResult.FAIL;
        }
        SoundType soundtype = Blocks.field_150348_b.func_185467_w();
        worldIn.func_184133_a(playerIn, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
        StackHelper.decrease(stack);
        return EnumActionResult.SUCCESS;
    }

    public boolean placeBlockAt(@Nonnull ItemStack stack, @Nonnull EntityPlayer player, World world, @Nonnull BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, @Nonnull IBlockState newState) {
        return BlockTransferHolder.placePipe(world, pos, player);
    }

    public boolean func_179222_a(World worldIn, @Nonnull BlockPos pos, @Nonnull EnumFacing side, EntityPlayer player, @Nonnull ItemStack stack) {
        return super.func_179222_a(worldIn, pos, side, player, stack) || this.checkPos(worldIn, pos) || this.checkPos(worldIn, pos.func_177972_a(side));
    }

    public boolean checkPos(World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        return tileEntity instanceof TileTransferHolder && ((TileTransferHolder)tileEntity).centerPipe == null;
    }
}

